/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import mlib.MString;
import utilt.Utility;

public class MTextDataTable {
    private transient String iName = null;
    private TreeMap<Integer, String[]> iRows = new TreeMap();
    private LinkedList<Field> iFields = new LinkedList();
    public static final String EMPTY = "";
    public static final String FILEEXT = ".tab";
    private static final String FIELDNOTFOUND = "Field not found: ";
    private static final char TAB = '\t';

    public static void main(String[] args) {
        try {
            MTextDataTable table = new MTextDataTable("test");
            table.add(new Field("field1", 1));
            table.add(new Field("field2", 2));
            table.add(new Field("field3", 3));
            String[] strs1 = new String[]{"11", "12", "13"};
            MTextDataTable mTextDataTable = table;
            mTextDataTable.getClass();
            table.putRow(1, mTextDataTable.new Row(strs1));
            String[] strs2 = new String[]{"21", "22", "23"};
            MTextDataTable mTextDataTable2 = table;
            mTextDataTable2.getClass();
            table.putRow(2, mTextDataTable2.new Row(strs2));
            String[] strs3 = new String[]{"31", "32", "33"};
            MTextDataTable mTextDataTable3 = table;
            mTextDataTable3.getClass();
            table.putRow(3, mTextDataTable3.new Row(strs3));
            table.write("/home/wbough/misc/table.txt");
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static MTextDataTable importSpreadsheet(String path) throws Exception {
        MTextDataTable table = new MTextDataTable(path);
        LinkedList<String> lines = Utility.readTextFile(path);
        StringTokenizer tken = new StringTokenizer(lines.getFirst(), "\t");
        int col = 1;
        while (tken.hasMoreTokens()) {
            String name = tken.nextToken().trim();
            Field field = new Field(name, col++, Field.Type.TEXT);
            table.iFields.add(field);
        }
        Iterator iter = lines.iterator();
        iter.next();
        int row = 1;
        while (iter.hasNext()) {
            String[] fieldValues = new String[table.iFields.size()];
            col = 0;
            while (col < fieldValues.length) {
                fieldValues[col] = EMPTY;
                ++col;
            }
            MString line = new MString((String)iter.next());
            tken = new StringTokenizer(line.toString(), "\t");
            if (tken.countTokens() != table.iFields.size()) {
                Utility.throwError("Row requires " + table.iFields.size() + " values");
                continue;
            }
            col = 0;
            while (tken.hasMoreTokens()) {
                MString work = new MString(tken.nextToken());
                work.trimWhitespace();
                work.trim('\"');
                if (work.length() > 0) {
                    fieldValues[col] = work.toString();
                }
                ++col;
            }
            table.iRows.put(row++, fieldValues);
        }
        return table;
    }

    public MTextDataTable(String name) {
        this.iName = name;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getName() {
        return this.iName;
    }

    public void add(Field field) {
        this.iFields.add(field);
    }

    public Collection<Field> getFields() {
        return this.iFields;
    }

    public Field field(String name) throws Exception {
        Iterator iter = this.iFields.iterator();
        Field found = null;
        while (found == null && iter.hasNext()) {
            Field aField = (Field)iter.next();
            if (!aField.getName().equals(name)) continue;
            found = aField;
        }
        if (found == null) {
            Utility.throwError(FIELDNOTFOUND + name);
        }
        return found;
    }

    public Field field(int col) throws Exception {
        Field field = null;
        Iterator iter = this.iFields.iterator();
        while (field == null && iter.hasNext()) {
            Field aField = (Field)iter.next();
            if (aField.getCol() != col) continue;
            field = aField;
        }
        if (field == null) {
            Utility.throwError(FIELDNOTFOUND + col);
        }
        return field;
    }

    public int numRows() {
        return this.iRows.keySet().size();
    }

    public Row row(int num) throws Exception {
        Row row = new Row();
        row.putValues(this.iRows.get(num));
        return row;
    }

    public String[] columnValues(String fieldName) throws Exception {
        String[] values = new String[this.numRows()];
        int row = 1;
        while (row <= values.length) {
            values[row - 1] = this.value(fieldName, row);
            ++row;
        }
        return values;
    }

    public void putRow(int num, Row row) throws Exception {
        if (num < 1) {
            Utility.throwError("Invalid row number: " + num);
        }
        this.iRows.put(num, row.getValues());
    }

    public void putColumn(String fieldName, String[] values) throws Exception {
        Field field = this.field(fieldName);
        int rowNum = 1;
        while (rowNum <= values.length) {
            Row row = new Row();
            String[] newRow = row.getValues();
            String[] curRow = this.row(rowNum).getValues();
            if (curRow != null) {
                int col = 0;
                while (col < curRow.length) {
                    newRow[col] = curRow[col];
                    ++col;
                }
            }
            this.iRows.put(rowNum, newRow);
            newRow[field.getCol() - 1] = values[rowNum - 1];
            ++rowNum;
        }
    }

    public void write(String path) throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(path));
        MString line = new MString();
        int count = 0;
        for (Field field : this.iFields) {
            if (count++ > 0) {
                line.concat('\t');
            }
            line.concat(field.getName());
        }
        out.println(line.toString());
        count = this.numRows();
        int row = 1;
        while (row <= count) {
            String[] values;
            line = new MString();
            String[] stringArray = values = this.row(row).getValues();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                line.concat(String.valueOf(str) + '\t');
                ++n2;
            }
            line.trimTail('\t');
            out.println(line.toString());
            ++row;
        }
        out.close();
    }

    private String value(String fieldName, int row) throws Exception {
        Field field = this.field(fieldName);
        String[] values = this.iRows.get(row);
        String value = values[field.getCol() - 1];
        if ((value = value.trim()).length() == 0) {
            value = EMPTY;
        }
        return value;
    }

    public static class Field {
        private String iName = null;
        private int iCol = 0;
        private Type iType = Type.TEXT;

        public Field(String name, int col) throws Exception {
            this(name, col, Type.TEXT);
        }

        public Field(String name, int col, Type type) throws Exception {
            if (col < 1 || col > 1024) {
                Utility.throwError("Field column must be > 0 and < 1024");
            }
            if (name.length() == 0) {
                Utility.throwError("Field name length must be > 0");
            }
            this.iName = name;
            this.iCol = col;
            this.iType = type;
        }

        public String getName() {
            return this.iName;
        }

        public int getCol() {
            return this.iCol;
        }

        public Type getType() {
            return this.iType;
        }

        public String toString() {
            String str = this.iCol + "," + this.iName + "," + this.iType.toString();
            return str;
        }

        public static class ColComparator
        implements Comparator<Field> {
            @Override
            public int compare(Field field1, Field field2) {
                int result = -1;
                if (field1 != null && field2 != null) {
                    result = field1.getCol() - field2.getCol();
                }
                return result;
            }
        }

        public static enum Type {
            TEXT,
            NUMBER,
            FORMULA;

        }
    }

    public class Row {
        private String[] iValues = null;

        public Row() {
            this.iValues = new String[MTextDataTable.this.iFields.size()];
            int i = 0;
            while (i < this.iValues.length) {
                this.iValues[i] = MTextDataTable.EMPTY;
                ++i;
            }
        }

        public Row(String[] values) throws Exception {
            this.putValues(values);
        }

        public void putValue(Field field, String value) {
            if (value.length() == 0 && field.getType() == Field.Type.NUMBER) {
                value = "0";
            }
            this.iValues[field.getCol() - 1] = value;
        }

        public void putValues(String[] values) throws Exception {
            if (values.length != MTextDataTable.this.getFields().size()) {
                Utility.throwError("Row requires " + MTextDataTable.this.getFields().size() + " values");
            } else {
                this.iValues = values;
            }
        }

        public String value(Field field) {
            return this.iValues[field.getCol() - 1];
        }

        public String value(String fieldName) throws Exception {
            Field field = MTextDataTable.this.field(fieldName);
            return this.value(field);
        }

        public String[] getValues() {
            return this.iValues;
        }
    }
}

