/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import mlib.MEncrypter;

public class MString
implements Serializable,
Cloneable,
Comparable<MString>,
CharSequence {
    private char[] iChars = null;
    private int iCurLen = 0;
    private transient String iString = null;
    private static final int MINSIZEINCREMENT = 32;
    private static final int DEFAULTSIZE = 32;
    private static final int NOTFOUND = -1;
    private static final char TAB = '\t';
    static final long serialVersionUID = -3977318587652447614L;

    public static void main(String[] args) {
        try {
            MString str1 = new MString("123   || 456 |");
            str1.reverse();
            str1.reverse();
            str1.concat("abc");
            str1.removeWhitespaceBefore('|');
            str1 = new MString("||    123  |   a  |");
            str1.removeWhitespaceAfter('|');
            str1 = new MString("<html><div style='background-color:'><DIV class=RTE>  1 -  4=  c </DIV></div><br clear=all><hr> <a href=\"http://g.msn.com/8HMAENUS/2752??PS=47575\" target=\"_top\">All-in-one security and maintenance for your PC.\u00ef\u00bf\u00bd Get a free 90-day trial! </a> </html>");
            str1.removeHtml();
            str1 = new MString('\n');
            str1.concat('\n');
            str1.concat("abc");
            str1.concat('\t');
            str1.removeControlChars();
            str1 = new MString("abc");
            MString str2 = new MString("");
            int result = str1.compareTo(str2);
            System.out.println(result);
            result = str2.compareTo(str1);
            result = str1.compareTo(str1);
            TreeSet<MString> coll = new TreeSet<MString>();
            coll.add(new MString("123"));
            coll.add(new MString("123"));
            coll.add(new MString("123"));
            for (MString str : coll) {
                System.out.println("  " + str);
            }
            int minLen = 4;
            str1 = new MString("abcdef");
            str2 = new MString("abcedf");
            System.out.println(String.valueOf(str1.approxMatches(str2, minLen, false)) + " " + str1 + " " + str2);
            str1 = new MString("abcdef");
            str2 = new MString("abcfed");
            System.out.println(String.valueOf(str1.approxMatches(str2, minLen, false)) + " " + str1 + " " + str2);
            str1 = new MString("abcdef");
            str2 = new MString("abcef");
            System.out.println(String.valueOf(str1.approxMatches(str2, minLen, false)) + " " + str1 + " " + str2);
            str1 = new MString("c://java//lecturequiz.bat");
            str2 = new MString("c://Java//lecutrequiz.bat");
            System.out.println(String.valueOf(str1.approxMatches(str2, minLen, false)) + " " + str1 + " " + str2);
            str1 = new MString("abcdefgh");
            str2 = new MString("abcfgh");
            System.out.println(String.valueOf(str1.approxMatches(str2, minLen, false)) + " " + str1 + " " + str2);
            str1 = new MString("1000");
            str2 = new MString("4000");
            System.out.println(String.valueOf(str1.approxMatches(str2, minLen, false)) + " " + str1 + " " + str2);
            str1 = new MString("123456789");
            str2 = str1.removeBlock('1', '9');
            str1 = new MString("\t12345\t6789");
            str2 = str1.expandTabs(3);
            str1 = new MString("abc[?def [?[?gggggg");
            result = str1.countOf("[?");
            System.out.println(result);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static MString valueOf(double adouble, int rightDigits) {
        double round = 0.5;
        int power = 0;
        while (power < rightDigits) {
            round *= 0.1;
            ++power;
        }
        String orig = String.valueOf(adouble + round);
        int decimalPos = orig.indexOf(46);
        int zerosToAdd = rightDigits - (orig.length() - decimalPos - 1);
        int i = 0;
        while (i < zerosToAdd) {
            orig = String.valueOf(orig) + "0";
            ++i;
        }
        orig = orig.substring(0, decimalPos + rightDigits + 1);
        return new MString(orig);
    }

    public MString() {
        this.iChars = new char[32];
        this.iCurLen = 0;
    }

    public MString(char c) {
        this();
        char[] chr = new char[]{c};
        this.assign(chr);
    }

    public MString(int size) {
        this.iChars = new char[size];
        this.iCurLen = 0;
    }

    public MString(String obj) {
        this();
        this.assign(obj);
    }

    public MString(char[] chars) {
        this();
        this.assign(chars);
    }

    public MString(char[] chars, int numChars) {
        this();
        this.allocate(numChars);
        int i = 0;
        while (i < numChars) {
            this.iChars[i] = chars[i];
            ++i;
        }
        this.iCurLen = numChars;
    }

    public MString addHead(char chr, int length) {
        this.iString = null;
        if (length > this.iCurLen) {
            int newLen = length;
            if (this.iChars.length > newLen) {
                newLen = this.iChars.length;
            }
            char[] newChars = new char[newLen];
            int addLen = length - this.iCurLen;
            int i = 0;
            while (i < addLen) {
                newChars[i] = chr;
                ++i;
            }
            int j = 0;
            while (j < this.iCurLen) {
                newChars[i] = this.iChars[j];
                ++i;
                ++j;
            }
            this.iChars = null;
            this.iChars = newChars;
            this.iCurLen = length;
        }
        return this;
    }

    public MString addTail(char chr, int length) {
        this.iString = null;
        this.allocate(length);
        int addLen = length - this.iCurLen;
        int i = 0;
        while (i < addLen) {
            this.iChars[this.iCurLen] = chr;
            ++this.iCurLen;
            ++i;
        }
        return this;
    }

    public MString assign(String str) {
        this.iString = null;
        int objLen = str.length();
        this.allocate(objLen);
        int i = 0;
        while (i < objLen) {
            this.iChars[i] = str.charAt(i);
            ++i;
        }
        this.iCurLen = objLen;
        return this;
    }

    public MString assign(MString str) {
        this.iString = null;
        this.allocate(str.iCurLen);
        int i = 0;
        while (i < str.iCurLen) {
            this.iChars[i] = str.iChars[i];
            ++i;
        }
        this.iCurLen = str.iCurLen;
        return this;
    }

    public MString assign(byte[] bytes) {
        this.iString = null;
        this.allocate(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            this.iChars[i] = (char)bytes[i];
            ++i;
        }
        this.iCurLen = bytes.length;
        return this;
    }

    public MString assign(char[] chars) {
        this.iString = null;
        this.allocate(chars.length);
        int i = 0;
        while (i < chars.length) {
            this.iChars[i] = chars[i];
            ++i;
        }
        this.iCurLen = chars.length;
        return this;
    }

    public MString center(int length, char padChar) {
        this.iString = null;
        if (length > this.iCurLen) {
            int newLen = length;
            if (this.iChars.length > newLen) {
                newLen = this.iChars.length;
            }
            char[] newChars = new char[newLen];
            int padLen = (length - this.iCurLen) / 2;
            int i = 0;
            while (i < padLen) {
                newChars[i] = padChar;
                ++i;
            }
            int j = 0;
            while (j < this.iCurLen) {
                newChars[i] = this.iChars[j];
                ++i;
                ++j;
            }
            while (i < length) {
                newChars[i] = padChar;
                ++i;
            }
            this.iChars = null;
            this.iChars = newChars;
            this.iCurLen = i;
        }
        return this;
    }

    public MString pad(int length, char pad) {
        this.iString = null;
        if (length > this.iCurLen) {
            this.compress(this.iCurLen);
            this.allocate(length);
            while (this.iCurLen < length) {
                this.iChars[this.iCurLen] = pad;
                ++this.iCurLen;
            }
            this.compress(this.iCurLen);
        }
        return this;
    }

    public MString truncate(int length) {
        if (length < 0 || length >= this.iCurLen) {
            throw new IndexOutOfBoundsException();
        }
        this.iCurLen = length;
        return this;
    }

    public MString concat(char chr) {
        this.iString = null;
        this.allocate(1);
        this.iChars[this.iCurLen++] = chr;
        return this;
    }

    public MString concat(String str) {
        this.iString = null;
        int objLen = str.length();
        this.allocate(objLen);
        int i = 0;
        while (i < objLen) {
            this.iChars[this.iCurLen + i] = str.charAt(i);
            ++i;
        }
        this.iCurLen += objLen;
        return this;
    }

    public MString concat(MString str) {
        this.iString = null;
        this.allocate(str.iCurLen);
        int i = 0;
        while (i < str.iCurLen) {
            this.iChars[this.iCurLen + i] = str.iChars[i];
            ++i;
        }
        this.iCurLen += str.iCurLen;
        return this;
    }

    public MString concat(char[] chars) {
        this.iString = null;
        this.allocate(chars.length);
        int i = 0;
        while (i < chars.length) {
            this.iChars[this.iCurLen + i] = chars[i];
            ++i;
        }
        this.iCurLen += chars.length;
        return this;
    }

    public MString concat(String[] strs, char delim) {
        this.iString = null;
        int length = 0;
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            length += str.length() + 1;
            ++n2;
        }
        this.allocate(length);
        int num = 0;
        String[] stringArray2 = strs;
        int n3 = strs.length;
        n = 0;
        while (n < n3) {
            String str = stringArray2[n];
            if (num++ > 0) {
                this.concat(delim);
            }
            this.concat(str);
            ++n;
        }
        return this;
    }

    public MString toLowerCase() {
        this.iString = null;
        int i = 0;
        while (i < this.iCurLen) {
            this.iChars[i] = Character.toLowerCase(this.iChars[i]);
            ++i;
        }
        return this;
    }

    public MString toUpperCase() {
        int i = 0;
        while (i < this.iCurLen) {
            this.iChars[i] = Character.toUpperCase(this.iChars[i]);
            ++i;
        }
        return this;
    }

    public MString insert(char c, int index) throws Exception {
        this.iString = null;
        char[] chars = new char[]{c};
        this.insert(chars, index);
        return this;
    }

    public MString insert(String obj, int startIndex) throws Exception {
        this.iString = null;
        this.insert(obj.toCharArray(), startIndex);
        return this;
    }

    public MString insert(MString obj, int startIndex) throws Exception {
        this.iString = null;
        this.insert(obj.toCharArray(), startIndex);
        return this;
    }

    public int remove(String obj, int maxnum, int startPos) {
        this.iString = null;
        char[] chars = obj.toCharArray();
        int num = this.remove(chars, maxnum, startPos);
        return num;
    }

    public int remove(MString obj, int maxnum, int startPos) {
        this.iString = null;
        char[] chars = obj.toCharArray();
        int num = this.remove(chars, maxnum, startPos);
        return num;
    }

    public int remove(char aChar, int maxnum, int startPos) {
        this.iString = null;
        char[] chars = new char[]{aChar};
        int num = this.remove(chars, maxnum, startPos);
        return num;
    }

    public void remove(int pos, int numChars) {
        this.iString = null;
        if (pos > 0 && pos + numChars <= this.iCurLen) {
            int i = pos + numChars;
            while (i < this.iCurLen) {
                this.iChars[i - numChars] = this.iChars[i];
                ++i;
            }
            this.iCurLen -= numChars;
        }
    }

    public void removeEndComment() {
        this.iString = null;
        int index = this.indexOfOutsideQuotes(0, "//");
        if (index >= 0) {
            this.iCurLen = index;
        }
    }

    public void removeAlphabetic() {
        this.iString = null;
        if (this.iCurLen > 1) {
            char[] newChars = new char[this.iChars.length];
            int len = 0;
            int j = 0;
            while (j < this.iCurLen) {
                if (Character.isDigit(this.iChars[j])) {
                    newChars[len++] = this.iChars[j];
                }
                ++j;
            }
            this.iChars = newChars;
            this.iCurLen = len;
        }
    }

    public MString removeWhitespaceBefore(char aChar) {
        this.iString = null;
        if (this.iCurLen > 1) {
            char[] newChars = new char[this.iChars.length];
            int j = 0;
            int startWs = 0;
            int i = 0;
            while (i < this.iCurLen) {
                newChars[j] = this.iChars[i];
                if (Character.isWhitespace(this.iChars[i]) && !this.charIsWithinQuotes(i)) {
                    if (startWs == 0) {
                        startWs = j;
                    }
                } else if (this.iChars[i] == aChar) {
                    if (startWs > 0) {
                        j = startWs;
                        newChars[j] = aChar;
                        startWs = 0;
                    }
                } else {
                    startWs = 0;
                }
                ++j;
                ++i;
            }
            this.iChars = null;
            this.iChars = newChars;
            this.iCurLen = j;
        }
        return this;
    }

    public MString removeWhitespaceAfter(char aChar) {
        this.iString = null;
        if (this.iCurLen > 1) {
            char[] newChars = new char[this.iChars.length];
            int j = 0;
            boolean haveChar = false;
            int i = 0;
            while (i < this.iCurLen) {
                if (this.iChars[i] == aChar) {
                    newChars[j] = this.iChars[i];
                    ++j;
                    haveChar = true;
                } else if (Character.isWhitespace(this.iChars[i]) && !this.charIsWithinQuotes(i)) {
                    if (!haveChar) {
                        newChars[j] = this.iChars[i];
                        ++j;
                    }
                } else {
                    newChars[j] = this.iChars[i];
                    ++j;
                    haveChar = false;
                }
                ++i;
            }
            this.iChars = null;
            this.iChars = newChars;
            this.iCurLen = j;
        }
        return this;
    }

    public MString removeWhitespace() {
        this.iString = null;
        char[] newChars = new char[this.iChars.length];
        int j = 0;
        int i = 0;
        while (i < this.iCurLen) {
            if (!Character.isWhitespace(this.iChars[i])) {
                newChars[j] = this.iChars[i];
                ++j;
            }
            ++i;
        }
        this.iChars = null;
        this.iChars = newChars;
        this.iCurLen = j;
        return this;
    }

    public MString removeControlChars() {
        this.iString = null;
        char[] chars = new char[this.iChars.length];
        int j = 0;
        int i = 0;
        while (i < this.iCurLen) {
            chars[j++] = !Character.isISOControl(this.iChars[i]) ? this.iChars[i] : 32;
            ++i;
        }
        this.iChars = chars;
        this.iCurLen = j;
        return this;
    }

    public MString encode(int value) {
        this.iString = null;
        int i = 0;
        while (i < this.iCurLen) {
            this.iChars[i] = (char)(this.iChars[i] + value);
            ++i;
        }
        return this;
    }

    public MString decode(int value) {
        this.iString = null;
        int i = 0;
        while (i < this.iCurLen) {
            this.iChars[i] = (char)(this.iChars[i] - value);
            ++i;
        }
        return this;
    }

    public MString removeBlock(char start, char end) {
        this.iString = null;
        int left = this.indexOf(start);
        if (left >= 0 && this.indexOf(end) > left) {
            char[] chars = new char[this.iChars.length];
            int j = 0;
            boolean inBlock = false;
            int i = 0;
            while (i < this.iCurLen) {
                if (this.iChars[i] == start) {
                    inBlock = true;
                } else if (this.iChars[i] == end) {
                    inBlock = false;
                } else if (!inBlock) {
                    chars[j++] = this.iChars[i];
                }
                ++i;
            }
            this.iChars = chars;
            this.iCurLen = j;
        }
        return this;
    }

    public MString removeHtml() {
        this.iString = null;
        this.removeBlock('<', '>');
        this.removeBlock('{', '}');
        return this;
    }

    public MString replaceRepetition(char chr) {
        this.iString = null;
        char[] chars = new char[this.iChars.length];
        int j = 0;
        int i = 0;
        while (i < this.iCurLen) {
            boolean add;
            boolean bl = add = j == 0;
            if (!add) {
                boolean bl2 = add = this.iChars[i] != chr;
            }
            if (!add) {
                boolean bl3 = add = this.iChars[i] == chr && chars[j - 1] != chr;
            }
            if (add) {
                chars[j] = this.iChars[i];
                ++j;
            }
            ++i;
        }
        this.iChars = null;
        this.iChars = chars;
        this.iCurLen = j;
        return this;
    }

    public MString replace(char from, char to) {
        this.iString = null;
        int i = 0;
        while (i < this.iCurLen) {
            if (this.iChars[i] == from) {
                this.iChars[i] = to;
            }
            ++i;
        }
        return this;
    }

    public boolean replace(String from, String to) {
        this.iString = null;
        char[] fromChars = from.toCharArray();
        char[] toChars = to.toCharArray();
        boolean result = this.replace(fromChars, toChars);
        return result;
    }

    public boolean replaceAll(String from, String to) {
        this.iString = null;
        boolean more = true;
        while (more) {
            more = this.replace(from, to);
        }
        return more;
    }

    public boolean replace(MString from, MString to) {
        this.iString = null;
        return this.replace(from.iChars, to.iChars);
    }

    public MString trimWhitespace() {
        this.iString = null;
        this.trimWhitespaceHead();
        this.trimWhitespaceTail();
        return this;
    }

    public MString trimWhitespaceTail() {
        this.iString = null;
        while (this.iCurLen > 0 && Character.isWhitespace(this.iChars[this.iCurLen - 1])) {
            --this.iCurLen;
        }
        return this;
    }

    public MString trimWhitespaceHead() {
        this.iString = null;
        int start = 0;
        while (start < this.iCurLen && Character.isWhitespace(this.iChars[start])) {
            ++start;
        }
        int i = start;
        while (i < this.iCurLen) {
            this.iChars[i - start] = this.iChars[i];
            ++i;
        }
        this.iCurLen -= start;
        return this;
    }

    public MString trim(char chr) {
        this.iString = null;
        this.trimHead(chr);
        this.trimTail(chr);
        return this;
    }

    public MString trimHead(char chr) {
        this.iString = null;
        int start = 0;
        while (start < this.iCurLen && this.iChars[start] == chr) {
            ++start;
        }
        int i = start;
        while (i < this.iCurLen) {
            this.iChars[i - start] = this.iChars[i];
            ++i;
        }
        this.iCurLen -= start;
        return this;
    }

    public MString trimTail(char chr) {
        this.iString = null;
        while (this.iCurLen > 0 && this.iChars[this.iCurLen - 1] == chr) {
            --this.iCurLen;
        }
        return this;
    }

    public MString putFirstChar(char chr) {
        this.iString = null;
        if (this.iCurLen > 0) {
            this.iChars[0] = chr;
        }
        return this;
    }

    public MString capFirstChar() {
        this.iString = null;
        if (this.iCurLen > 0) {
            this.iChars[0] = Character.toUpperCase(this.iChars[0]);
        }
        return this;
    }

    public MString cipher(MEncrypter encrypter) {
        this.iString = null;
        int i = 0;
        while (i < this.iCurLen) {
            byte[] in = new byte[]{(byte)this.iChars[i]};
            byte[] out = encrypter.xor(in);
            this.iChars[i] = (char)out[0];
            ++i;
        }
        return this;
    }

    public MString reverse() {
        char[] chars = new char[this.iCurLen];
        int i = 0;
        while (i < this.iCurLen) {
            int end = this.iCurLen - i - 1;
            chars[i] = this.iChars[end];
            ++i;
        }
        this.iChars = chars;
        return this;
    }

    public MString clean() {
        this.iString = null;
        char replace = '-';
        int i = 0;
        while (i < this.iCurLen) {
            if (this.iChars[i] != '.') {
                if (this.iChars[i] == ' ') {
                    this.iChars[i] = replace;
                } else if (!Character.isLetterOrDigit(this.iChars[i])) {
                    this.iChars[i] = replace;
                }
            }
            ++i;
        }
        this.replaceRepetition(replace);
        return this;
    }

    public MString fill(char chr, int count) {
        this.iString = null;
        this.iCurLen = 0;
        this.allocate(count);
        int i = 0;
        while (i < count) {
            this.iChars[this.iCurLen++] = chr;
            ++i;
        }
        return this;
    }

    public MString clear() {
        this.iString = null;
        this.iCurLen = 0;
        return this;
    }

    public int count(char chr) {
        int count = 0;
        int i = 0;
        while (i < this.iCurLen) {
            if (this.iChars[i] == chr) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void toLowerCaseNotQuoted() {
        this.iString = null;
        int i = 0;
        while (i < this.iCurLen) {
            if (!this.charIsWithinQuotes(i)) {
                this.iChars[i] = Character.toLowerCase(this.iChars[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.iCurLen) {
            if (this.iChars[i] == '\"') {
                this.iChars[i] = 10;
            }
            ++i;
        }
        this.removeControlChars();
    }

    public MString expandTabs(int tabsize) {
        this.iString = null;
        int numTabs = this.countOf('\t');
        if (numTabs > 0) {
            int nextPos = 0;
            int newMaxLen = this.iCurLen + tabsize * numTabs;
            if (newMaxLen < this.iChars.length) {
                newMaxLen = this.iChars.length;
            }
            char[] chars = new char[newMaxLen];
            int i = 0;
            while (i < this.iCurLen) {
                if (this.iChars[i] == '\t') {
                    int nextTabPos = (nextPos + tabsize) / tabsize * tabsize;
                    while (nextPos < nextTabPos) {
                        chars[nextPos] = 32;
                        ++nextPos;
                    }
                } else {
                    chars[nextPos] = this.iChars[i];
                    ++nextPos;
                }
                ++i;
            }
            this.iChars = chars;
            this.iCurLen = nextPos;
        }
        return this;
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        char aChar = '\u0000';
        if (index < 0 || index >= this.iCurLen) {
            throw new IndexOutOfBoundsException();
        }
        aChar = this.iChars[index];
        return aChar;
    }

    public char charAtNoXcp(int index) {
        return this.iChars[index];
    }

    public Object clone() {
        MString copy = null;
        try {
            copy = (MString)super.clone();
            copy.iChars = (char[])this.iChars.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public boolean endsWith(String obj) {
        char[] chars = obj.toCharArray();
        return this.endsWith(chars);
    }

    public boolean endsWith(MString obj) {
        return this.endsWith(obj.toCharArray());
    }

    public boolean endsWith(char chr) {
        boolean endsWith = false;
        if (this.iCurLen > 0) {
            endsWith = chr == this.iChars[this.iCurLen - 1];
        }
        return endsWith;
    }

    public boolean startsWith(String obj) {
        char[] chars = obj.toCharArray();
        return this.startsWith(chars);
    }

    public boolean startsWith(MString obj) {
        return this.startsWith(obj.toCharArray());
    }

    public boolean startsWith(char chr) {
        boolean startsWith = false;
        if (this.iCurLen > 0) {
            startsWith = chr == this.iChars[0];
        }
        return startsWith;
    }

    @Override
    public int compareTo(MString obj) {
        int result = this.toString().compareTo(obj.toString());
        return result;
    }

    public boolean equals(MString obj) {
        boolean equal = this.compareTo(obj) == 0;
        return equal;
    }

    public boolean equalsIgnoreCase(Object obj) {
        boolean equal = this.toString().equalsIgnoreCase(obj.toString());
        return equal;
    }

    public boolean equals(String str) {
        boolean equal = this.toString().equals(str);
        return equal;
    }

    public boolean equalsIgnoreCase(String str) {
        boolean equal = this.toString().equalsIgnoreCase(str);
        return equal;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int indexOf(char chr) {
        return this.indexOf(0, chr);
    }

    public int indexOf(int startPos, char chr) {
        int index = -1;
        if (startPos < this.iCurLen) {
            int i = startPos;
            while (i < this.iCurLen && index == -1) {
                if (this.iChars[i] == chr) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    public int indexOf(String obj) {
        char[] chars = obj.toCharArray();
        return this.indexOf(0, chars);
    }

    public int indexOf(MString obj) {
        char[] chars = obj.toCharArray();
        return this.indexOf(0, chars);
    }

    public int indexOf(MString obj, int startPos) {
        char[] chars = obj.toCharArray();
        return this.indexOf(startPos, chars);
    }

    public int indexOf(String obj, int startPos) {
        char[] chars = obj.toCharArray();
        return this.indexOf(startPos, chars);
    }

    public int indexOf(char[] chars) {
        int index = -1;
        int i = 0;
        while (i < this.iCurLen && index == -1) {
            int j = 0;
            while (j < chars.length && index == -1) {
                if (this.iChars[i] == chars[j]) {
                    index = i;
                }
                ++j;
            }
            ++i;
        }
        return index;
    }

    public int indexOf(int startIndex, char[] chars) {
        int index = -1;
        int j = 0;
        int i = startIndex;
        while (i < this.iCurLen) {
            j = 0;
            while (j < chars.length) {
                int k = i + j;
                if (k >= this.iChars.length || this.iChars[k] != chars[j]) break;
                ++j;
            }
            if (j == chars.length) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int lastIndexOf(String obj) {
        char[] chars = obj.toCharArray();
        int index = -1;
        int pos = 0;
        while (pos < this.iCurLen) {
            int at = this.indexOf(pos, chars);
            if (at >= 0) {
                index = at;
                pos += chars.length;
                continue;
            }
            ++pos;
        }
        return index;
    }

    public int lastIndexOf(char chr) {
        int index = -1;
        int i = this.iCurLen - 1;
        while (i >= 0) {
            if (this.iChars[i] == chr) {
                index = i;
                break;
            }
            --i;
        }
        return index;
    }

    public int prevIndexOf(char chr, int lastPos) {
        int index = -1;
        int i = lastPos - 1;
        while (i >= 0) {
            if (this.iChars[i] == chr) {
                index = i;
                break;
            }
            --i;
        }
        return index;
    }

    public int nextIndexOf(char chr, int prevPos) {
        int index = -1;
        int i = prevPos + 1;
        while (i < this.iCurLen) {
            if (this.iChars[i] == chr) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public char nextNotWhitespace(int startIndex) {
        char next = '\u0000';
        int i = startIndex;
        while (next == '\u0000' && i < this.iCurLen) {
            if (!Character.isWhitespace(this.iChars[i])) {
                next = this.iChars[i];
            }
            ++i;
        }
        return next;
    }

    public int indexOfOutside(int startPos, char chrToFind, char start, char end) {
        int index = this.indexOf(startPos, chrToFind);
        if (index != -1) {
            index = -1;
            boolean inRegion = false;
            int i = startPos;
            while (i < this.iCurLen) {
                if (!inRegion && this.iChars[i] == chrToFind) {
                    index = i;
                    break;
                }
                if (!inRegion && this.iChars[i] == start) {
                    inRegion = true;
                } else if (inRegion && this.iChars[i] == end) {
                    inRegion = false;
                }
                ++i;
            }
        }
        return index;
    }

    public int indexOfOutsideQuotes(int startPos, char chrToFind) {
        int index = this.indexOf(startPos, chrToFind);
        if (index != -1) {
            index = -1;
            boolean inRegion = false;
            int i = startPos;
            while (i < this.iCurLen) {
                if (!inRegion && this.iChars[i] == chrToFind) {
                    index = i;
                    break;
                }
                if (!(inRegion || this.iChars[i] != '\"' && this.iChars[i] != '\'')) {
                    inRegion = true;
                } else if (inRegion && (this.iChars[i] == '\"' || this.iChars[i] == '\'')) {
                    inRegion = false;
                }
                ++i;
            }
        }
        return index;
    }

    public int lastIndexOfOutside(char chrToFind, char start, char end) {
        int index = this.indexOf(chrToFind);
        if (index != -1) {
            index = -1;
            boolean inRegion = false;
            int i = this.iCurLen - 1;
            while (i > 0) {
                if (!inRegion && this.iChars[i] == chrToFind) {
                    index = i;
                    break;
                }
                if (!inRegion && this.iChars[i] == end) {
                    inRegion = true;
                } else if (inRegion && this.iChars[i] == start) {
                    inRegion = false;
                }
                --i;
            }
        }
        return index;
    }

    public boolean charIsWithinQuotes(int index) {
        int quotesBefore = 0;
        int i = 0;
        while (i < index) {
            if (this.iChars[i] == '\"') {
                ++quotesBefore;
            }
            ++i;
        }
        boolean isIn = quotesBefore % 2 > 0;
        return isIn;
    }

    public boolean hasStrAtPos(String str, int index) {
        boolean has = true;
        int j = 0;
        while (has && index + j < this.iCurLen && j < str.length()) {
            if (this.iChars[index + j] != str.charAt(j)) {
                has = false;
                continue;
            }
            ++j;
        }
        has = j >= str.length();
        return has;
    }

    public int indexOfOutside(int startPos, String strToFind, char start, char end) {
        int index = -1;
        if (strToFind.length() > 0 && this.indexOf(strToFind.charAt(0)) >= 0) {
            index = -1;
            boolean inRegion = false;
            int i = startPos;
            while (i < this.iCurLen) {
                if (!inRegion && this.hasStrAtPos(strToFind, i)) {
                    index = i;
                    break;
                }
                if (!inRegion && this.iChars[i] == start) {
                    inRegion = true;
                } else if (inRegion && this.iChars[i] == end) {
                    inRegion = false;
                }
                ++i;
            }
        }
        return index;
    }

    public int indexOfOutsideQuotes(int startPos, String strToFind) {
        int index = -1;
        if (strToFind.length() > 0 && this.indexOf(startPos, strToFind.charAt(0)) >= 0) {
            index = -1;
            boolean inRegion = false;
            int i = startPos;
            while (i < this.iCurLen) {
                if (!inRegion && this.hasStrAtPos(strToFind, i)) {
                    index = i;
                    break;
                }
                if (!(inRegion || this.iChars[i] != '\"' && this.iChars[i] != '\'')) {
                    inRegion = true;
                } else if (inRegion && (this.iChars[i] == '\"' || this.iChars[i] == '\'')) {
                    inRegion = false;
                }
                ++i;
            }
        }
        return index;
    }

    public int countOutside(int startPos, char chrToFind, char start, char end) {
        int count = 0;
        boolean more = true;
        while (more) {
            int index = this.indexOfOutside(startPos, chrToFind, start, end);
            if (index < 0) {
                more = false;
                continue;
            }
            ++count;
            startPos = index + 1;
        }
        return count;
    }

    public int countOutsideQuotes(int startPos, char chrToFind) {
        int count = 0;
        boolean more = true;
        while (more) {
            int index = this.indexOfOutsideQuotes(startPos, chrToFind);
            if (index < 0) {
                more = false;
                continue;
            }
            ++count;
            startPos = index + 1;
        }
        return count;
    }

    @Override
    public int length() {
        return this.iCurLen;
    }

    public byte[] bytes() {
        byte[] bytes = new byte[this.iCurLen];
        int i = 0;
        while (i < this.iCurLen) {
            bytes[i] = (byte)this.iChars[i];
            ++i;
        }
        return bytes;
    }

    public boolean isWhitespace() {
        boolean isSpace = this.iCurLen > 0;
        int i = 0;
        while (isSpace && i < this.iCurLen) {
            isSpace = Character.isWhitespace(this.iChars[i]);
            ++i;
        }
        return isSpace;
    }

    public MString headWhitespace() {
        MString newStr = new MString();
        int i = 0;
        while (i < this.iCurLen) {
            if (!Character.isWhitespace(this.iChars[i])) break;
            newStr.concat(this.iChars[i]);
            ++i;
        }
        return newStr;
    }

    public boolean strHasWhitespaceAfter(String str) {
        boolean has = true;
        int strLen = str.length();
        char[] chars = str.toCharArray();
        int startIndex = 0;
        while (has) {
            int endIndex;
            if ((startIndex = this.indexOf(startIndex, chars)) == -1 || (endIndex = startIndex + strLen) >= this.iCurLen) break;
            if (!Character.isWhitespace(this.iChars[endIndex])) {
                has = false;
            }
            ++startIndex;
        }
        return has;
    }

    public LinkedList<MString> tokenize(String tokens, boolean includeEmpty) {
        LinkedList<MString> items = new LinkedList<MString>();
        StringTokenizer tken = new StringTokenizer(this.toString(), tokens);
        while (tken.hasMoreTokens()) {
            MString next = new MString(tken.nextToken());
            if (!next.isWhitespace()) {
                items.add(next);
                continue;
            }
            if (!includeEmpty) continue;
            items.add(next);
        }
        return items;
    }

    public LinkedList<MString> tokenizeToWidth(int width) {
        LinkedList<MString> lines = new LinkedList<MString>();
        MString work = (MString)this.clone();
        MString line = new MString();
        while (work.length() > 0) {
            StringTokenizer tken = new StringTokenizer(work.toString());
            while (tken.hasMoreTokens()) {
                int newWidth;
                String token = tken.nextToken();
                int spacing = 1;
                if (line.length() == 0) {
                    spacing = 0;
                }
                if ((newWidth = line.length() + spacing + token.length()) >= width) {
                    lines.add((MString)line.clone());
                    line.clear();
                }
                line.concat(String.valueOf(token) + " ");
                work.remove(token, 1, 0);
                work.trimWhitespaceHead();
            }
        }
        lines.add((MString)line.clone());
        return lines;
    }

    public MString substring(int startIndex) throws Exception {
        return this.substring(startIndex, this.iCurLen - 1);
    }

    @Override
    public CharSequence subSequence(int startIndex, int endIndex) throws IndexOutOfBoundsException {
        MString result = new MString();
        try {
            result = this.substring(startIndex, endIndex);
        }
        catch (Exception xcp) {
            throw new IndexOutOfBoundsException();
        }
        return result;
    }

    public MString substring(int startIndex, int endIndex) throws Exception {
        if (endIndex < startIndex || startIndex < 0 || endIndex >= this.iCurLen) {
            throw new StringIndexOutOfBoundsException();
        }
        MString substr = new MString(endIndex - startIndex + 1);
        int i = startIndex;
        while (i <= endIndex) {
            substr.iChars[substr.iCurLen] = this.iChars[i];
            ++substr.iCurLen;
            ++i;
        }
        return substr;
    }

    public char[] toCharArray() {
        char[] chars = new char[this.iCurLen];
        int i = 0;
        while (i < this.iCurLen) {
            chars[i] = this.iChars[i];
            ++i;
        }
        return chars;
    }

    public boolean isUpperCase() {
        boolean ucase = true;
        if (this.length() == 0) {
            ucase = false;
        }
        int i = 0;
        while (i < this.iCurLen) {
            if (!Character.isUpperCase(this.iChars[i])) {
                ucase = false;
                break;
            }
            ++i;
        }
        return ucase;
    }

    public int countOf(char chr) {
        int count = 0;
        int i = 0;
        while (i < this.iCurLen) {
            if (this.iChars[i] == chr) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int countOf(String str) {
        int count = 0;
        int startPos = 0;
        while (startPos < this.iCurLen) {
            int index = this.indexOf(str, startPos);
            if (index >= 0) {
                ++count;
                startPos = index + str.length();
                continue;
            }
            startPos = this.iCurLen;
        }
        return count;
    }

    public boolean hasLetterOrDigit() {
        boolean result = false;
        int i = 0;
        while (!result && i < this.iCurLen) {
            result |= Character.isLetterOrDigit(this.iChars[i]);
            ++i;
        }
        return result;
    }

    public boolean hasDigit() {
        boolean result = false;
        int i = 0;
        while (!result && i < this.iCurLen) {
            result |= Character.isDigit(this.iChars[i]);
            ++i;
        }
        return result;
    }

    public int numDigits() {
        int num = 0;
        int i = 0;
        while (i < this.iCurLen) {
            if (Character.isDigit(this.iChars[i])) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public boolean isLettersOnly() {
        boolean result = this.length() > 0;
        int i = 0;
        while (result && i < this.iCurLen) {
            result = !Character.isDigit(this.iChars[i]);
            ++i;
        }
        return result;
    }

    public boolean isAscii() {
        boolean is = true;
        int i = 0;
        while (is && i < this.iCurLen) {
            is &= this.iChars[i] <= '\u007f';
            ++i;
        }
        return is;
    }

    public MString compress(int len) {
        this.iString = null;
        if (this.iChars.length > len) {
            char[] chars = new char[len];
            int i = 0;
            while (i < len) {
                chars[i] = this.iChars[i];
                ++i;
            }
            this.iChars = chars;
            this.iCurLen = len;
        }
        return this;
    }

    public boolean isCompressed() {
        return this.iChars.length == this.iCurLen;
    }

    public MString selectBetween(MString leftTag, MString rightTag) {
        if (!leftTag.isCompressed()) {
            leftTag.compress(leftTag.iCurLen);
        }
        if (!rightTag.isCompressed()) {
            rightTag.compress(rightTag.iCurLen);
        }
        char[] chars = new char[this.iChars.length];
        int j = 0;
        int i = 0;
        while (i < this.iCurLen) {
            int start = this.indexOf(i, leftTag.iChars);
            if (start >= 0) {
                int end = this.indexOf(start += leftTag.iCurLen, rightTag.iChars);
                if (end >= 0) {
                    int k = start;
                    while (k < end) {
                        chars[j++] = this.iChars[k];
                        ++k;
                    }
                    i += end + rightTag.iCurLen;
                } else {
                    i += this.iCurLen;
                }
            } else {
                i += this.iCurLen;
            }
            ++i;
        }
        MString selected = new MString();
        selected.iChars = chars;
        selected.iCurLen = j;
        return selected;
    }

    @Override
    public boolean isEmpty() {
        return this.isWhitespace() || this.iCurLen == 0;
    }

    public boolean approxMatches(MString other, int minLen, boolean caseSens) {
        boolean approx;
        boolean bl = approx = this.isLettersOnly() && this.iCurLen >= minLen && other.iCurLen >= minLen;
        if (approx) {
            MString one = this;
            MString two = other;
            if (!caseSens) {
                one = ((MString)this.clone()).toLowerCase();
                two = ((MString)other.clone()).toLowerCase();
            }
            if (!(approx = one.hasReversedChars(two))) {
                approx = one.hasMissingChar(two);
            }
        }
        return approx;
    }

    public boolean wcMatches(MString other) {
        boolean match;
        boolean bl = match = this.iCurLen == other.iCurLen;
        if (match) {
            try {
                int i = 0;
                while (match && i < this.iCurLen) {
                    char otherChar = other.charAt(i);
                    if (otherChar != '?') {
                        match = otherChar == this.charAt(i);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return match;
    }

    /*
     * Unable to fully structure code
     */
    public MString key() {
        block2: {
            key = new MString();
            tken = new StringTokenizer(this.toString(), " ,");
            if (tken.countTokens() != 1) ** GOTO lbl16
            key.concat(this);
            break block2;
lbl-1000:
            // 1 sources

            {
                token = tken.nextToken();
                key.concat(token.charAt(0));
                if (token.length() > 1) {
                    key.concat(token.charAt(1));
                    continue;
                }
                key.concat('-');
lbl16:
                // 3 sources

                ** while (tken.hasMoreTokens())
            }
        }
        return key;
    }

    public boolean contains(String str) {
        int index = this.indexOf(str);
        return index >= 0;
    }

    public boolean contains(MString str) {
        int index = this.indexOf(str);
        return index >= 0;
    }

    public int firstAlphaIndex() {
        int index = -1;
        if (this.iCurLen > 0) {
            int i = 0;
            while (index == -1) {
                if (Character.isAlphabetic(this.iChars[i])) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    public TreeSet<String> wordGroups(int numWords, String delim) {
        TreeSet<String> groups = new TreeSet<String>();
        StringTokenizer tken = new StringTokenizer(this.toString(), delim);
        String[] words = new String[tken.countTokens()];
        if (words.length >= numWords) {
            int index = 0;
            while (tken.hasMoreTokens()) {
                words[index++] = tken.nextToken();
            }
            index = 0;
            while (index <= words.length - numWords) {
                String group = "";
                int word = 0;
                while (word < numWords) {
                    group = String.valueOf(group) + words[index + word] + " ";
                    ++word;
                }
                groups.add(group.trim());
                ++index;
            }
        }
        return groups;
    }

    public boolean hasReversedChars(MString str) {
        boolean has;
        boolean bl = has = this.iCurLen == str.iCurLen;
        if (has) {
            int count = 0;
            int i = 0;
            while (i < this.iCurLen - 1) {
                if (this.iChars[i] != str.iChars[i]) {
                    boolean reversed;
                    boolean bl2 = reversed = this.iChars[i] == str.iChars[i + 1] && this.iChars[i + 1] == str.iChars[i];
                    if (reversed) {
                        ++count;
                    }
                }
                ++i;
            }
            has = count == 1;
        }
        return has;
    }

    public boolean hasMissingChar(MString str) {
        boolean has;
        boolean bl = has = Math.abs(this.iCurLen - str.iCurLen) == 1;
        if (has) {
            MString longer = this;
            MString shorter = str;
            if (longer.length() < shorter.length()) {
                longer = str;
                shorter = this;
            }
            longer = (MString)longer.clone();
            boolean done = false;
            int i = 0;
            while (!done && i < longer.iCurLen) {
                if (longer.iChars[i] != shorter.iChars[i]) {
                    longer.remove(longer.iChars[i], 1, i);
                    has = longer.equals(shorter);
                    done = true;
                }
                ++i;
            }
        }
        return has;
    }

    @Override
    public String toString() {
        if (this.iString == null) {
            this.iString = new String(this.iChars, 0, this.iCurLen);
        }
        return this.iString;
    }

    private boolean endsWith(char[] chars) {
        boolean endsWith = false;
        if (this.iCurLen >= chars.length) {
            int i = 0;
            int j = this.iCurLen - 1;
            i = chars.length - 1;
            while (i >= 0) {
                if (chars[i] != this.iChars[j]) break;
                --j;
                --i;
            }
            if (i < 0) {
                endsWith = true;
            }
        }
        return endsWith;
    }

    private boolean startsWith(char[] chars) {
        boolean startsWith = false;
        if (this.iCurLen >= chars.length) {
            int i = 0;
            i = 0;
            while (i < chars.length) {
                if (chars[i] != this.iChars[i]) break;
                ++i;
            }
            if (i == chars.length) {
                startsWith = true;
            }
        }
        return startsWith;
    }

    private void insert(char[] chars, int startIndex) throws Exception {
        this.iString = null;
        if (startIndex < 0 || startIndex > this.iCurLen) {
            throw new StringIndexOutOfBoundsException();
        }
        int newMaxLen = this.iCurLen + chars.length + 32;
        if (this.iChars.length > newMaxLen) {
            newMaxLen = this.iChars.length;
        }
        char[] newChars = new char[newMaxLen];
        int index = 0;
        while (index < startIndex) {
            newChars[index] = this.iChars[index];
            ++index;
        }
        int i = 0;
        while (i < chars.length) {
            newChars[index] = chars[i];
            ++index;
            ++i;
        }
        i = startIndex;
        while (i < this.iCurLen) {
            newChars[index] = this.iChars[i];
            ++index;
            ++i;
        }
        this.iChars = null;
        this.iChars = newChars;
        this.iCurLen = index;
    }

    private int avail() {
        return this.iChars.length - this.iCurLen;
    }

    private void allocate(int moreNeeded) {
        this.iString = null;
        if (moreNeeded > this.avail()) {
            char[] newChars = new char[this.iCurLen + moreNeeded + 32];
            int i = 0;
            while (i < this.iCurLen) {
                newChars[i] = this.iChars[i];
                ++i;
            }
            this.iChars = null;
            this.iChars = newChars;
        }
    }

    private int remove(char[] chars, int maxnum, int startPos) {
        this.iString = null;
        int num = 0;
        if (maxnum > 0) {
            int count = 0;
            while (count < maxnum) {
                int startIndex = this.indexOf(startPos, chars);
                if (startIndex == -1) break;
                int length = this.iCurLen - startIndex - chars.length;
                int i = 0;
                while (i < length) {
                    this.iChars[startIndex + i] = this.iChars[startIndex + chars.length + i];
                    ++i;
                }
                this.iCurLen -= chars.length;
                ++num;
                ++count;
            }
        }
        return num;
    }

    private boolean replace(char[] from, char[] to) {
        this.iString = null;
        boolean replaced = false;
        int startIndex = 0;
        boolean more = true;
        while (more) {
            if ((startIndex = this.indexOf(startIndex, from)) == -1) {
                more = false;
                continue;
            }
            this.remove(from, 1, startIndex);
            try {
                this.insert(to, startIndex);
                replaced = true;
                startIndex += to.length;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return replaced;
    }
}

