/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.util.Iterator;
import java.util.LinkedList;
import mlib.MString;

public class MSignature
implements Cloneable {
    private LinkedList<String> iTokens = new LinkedList();

    public MSignature() {
    }

    public MSignature(String cmdStr) {
        this.add(cmdStr);
    }

    public void add(String cmdStr) {
        MString work = new MString(cmdStr.toLowerCase());
        LinkedList<MString> tokens = work.tokenize(" ", false);
        for (MString aToken : tokens) {
            this.iTokens.add(aToken.toString());
        }
    }

    public void add(MSignature sig) {
        this.iTokens.addAll(sig.iTokens);
    }

    public boolean hasToken(String token) {
        boolean has = false;
        Iterator iter = this.iTokens.iterator();
        while (!has && iter.hasNext()) {
            has = ((String)iter.next()).equalsIgnoreCase(token);
        }
        return has;
    }

    public boolean remove(String token) {
        boolean removed = false;
        Iterator iter = this.iTokens.iterator();
        while (!removed && iter.hasNext()) {
            removed = ((String)iter.next()).equalsIgnoreCase(token);
            if (!removed) continue;
            iter.remove();
        }
        return removed;
    }

    public boolean equals(MSignature otherSig) {
        boolean equals;
        boolean bl = equals = this.numTokens() == otherSig.numTokens();
        if (equals) {
            Iterator iter = otherSig.iTokens.iterator();
            while (equals && iter.hasNext()) {
                equals = this.hasToken((String)iter.next());
            }
        }
        return equals;
    }

    public int numTokens() {
        return this.iTokens.size();
    }

    public String[] tokens() {
        String[] tokens = this.iTokens.toArray(new String[0]);
        return tokens;
    }

    public Object clone() {
        MSignature copy = null;
        try {
            copy = (MSignature)super.clone();
            copy.iTokens = new LinkedList();
            for (String token : this.iTokens) {
                copy.iTokens.add(token);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public String toString() {
        MString str = new MString();
        for (String token : this.iTokens) {
            str.concat(String.valueOf(token) + ' ');
        }
        str.trimWhitespaceTail();
        return str.toString();
    }
}

