/*
 * Decompiled with CFR 0.152.
 */
package mlib;

public class MShiftBuffer {
    private Object[] iObjs = null;
    private int iEnd = 0;

    public MShiftBuffer(int size) {
        this.iObjs = new Object[size];
    }

    public int size() {
        return this.iObjs.length;
    }

    public void clear() {
        int i = 0;
        while (i < this.iObjs.length) {
            this.iObjs[i] = null;
            ++i;
        }
        this.iEnd = 0;
    }

    public void add(Object obj) {
        if (this.iEnd < this.iObjs.length) {
            this.iObjs[this.iEnd++] = obj;
        } else {
            int i = 1;
            while (i < this.iObjs.length) {
                this.iObjs[i - 1] = this.iObjs[i];
                ++i;
            }
            this.iEnd = this.iObjs.length;
            this.iObjs[this.iEnd - 1] = obj;
        }
    }

    public void addUnique(Object obj) {
        boolean equals = false;
        int i = 1;
        while (i < this.iEnd) {
            equals |= this.iObjs[i].equals(obj);
            ++i;
        }
        if (!equals) {
            this.add(obj);
        }
    }

    public int numObjs() {
        return this.iEnd;
    }

    public Object[] allObjs() {
        return this.mostRecentObjs(Integer.MAX_VALUE);
    }

    public Object[] mostRecentObjs(int maxNum) {
        if (this.numObjs() < maxNum) {
            maxNum = this.numObjs();
        }
        Object[] recent = new Object[maxNum];
        int i = 0;
        while (i < maxNum) {
            recent[i] = this.iObjs[this.iEnd - i - 1];
            ++i;
        }
        return recent;
    }

    public String toString() {
        String str = "";
        Object[] objectArray = this.iObjs;
        int n = this.iObjs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            str = String.valueOf(str) + obj.toString() + "\r";
            ++n2;
        }
        return str;
    }
}

