/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import mlib.MEncStr;
import mlib.MLogging;
import mlib.MString;
import mlib.MWildcard;

public class MReport
implements Serializable {
    private MEncStr iTitle = null;
    private boolean iShowDate = true;
    private LinkedList<MEncStr> iLines = new LinkedList();
    private String iIndent = "";
    private int iTokenizeWidth = -1;
    private int iMaxLines = Integer.MAX_VALUE;
    public static final String BLANKLINE = "";
    public static final String NEWPAGE = "\f\n";
    public static final MString MBLANKLINE = new MString();
    public static final String FILEEXT = ".txt";
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("E dd-MMM-yyyy");
    static final long serialVersionUID = 5866261762254370344L;

    public MReport(String title) {
        this(title, true);
    }

    public MReport(String title, boolean showDate) {
        this.iTitle = new MEncStr(title);
        this.iShowDate = showDate;
    }

    public String title() {
        return this.iTitle.str().toString();
    }

    public void setIndent(String indent) {
        this.iIndent = indent;
    }

    public void setMaxLines(int maxLines) {
        this.iMaxLines = maxLines;
    }

    public void setTokenizeWidth(int width) {
        this.iTokenizeWidth = width;
    }

    public void addLine(String line) {
        this.addLine(new MString(line));
    }

    public void addLine(MString line) {
        if (this.iLines.size() < this.iMaxLines) {
            if (this.iLines.size() == 0) {
                this.addTitle();
            }
            if (line.length() == 0) {
                MEncStr str = new MEncStr(line);
                this.iLines.add(str);
            } else if (this.iTokenizeWidth > 1) {
                LinkedList<MString> lines = line.tokenize("\r\n", true);
                for (MString aLine : lines) {
                    aLine.removeControlChars();
                    LinkedList<MString> items = aLine.tokenizeToWidth(this.iTokenizeWidth - this.iIndent.length());
                    for (MString bLine : items) {
                        MEncStr str = new MEncStr(String.valueOf(this.iIndent) + bLine);
                        this.iLines.add(str);
                    }
                }
            } else {
                MEncStr str = new MEncStr(String.valueOf(this.iIndent) + line);
                this.iLines.add(str);
            }
        }
    }

    public void addAll(Collection<String> lines) {
        for (String line : lines) {
            this.addLine(line);
        }
    }

    public void addLines(Collection<MString> lines) {
        for (MString line : lines) {
            this.addLine(line.toString());
        }
    }

    public void add(MReport report) {
        boolean foundFirst = false;
        for (MEncStr line : report.iLines) {
            if (foundFirst || line.length() > 0) {
                this.iLines.add(line);
                foundFirst = true;
                continue;
            }
            if (line.length() <= 0) continue;
            this.iLines.add(line);
            foundFirst = true;
        }
    }

    public void remove(MWildcard wc) {
        Iterator iter = this.iLines.iterator();
        while (iter.hasNext()) {
            MEncStr line = (MEncStr)iter.next();
            if (!wc.matchesAny(line.toString())) continue;
            iter.remove();
        }
    }

    public void addDivider(int minWidth) {
        int len = 0;
        for (MEncStr line : this.iLines) {
            if (line.length() <= len) continue;
            len = line.length();
        }
        if (len < minWidth) {
            len = minWidth;
        }
        MString divider = new MString();
        divider.fill('-', len);
        this.iLines.add(new MEncStr(divider));
    }

    public void addSpacer() {
        this.addLine(BLANKLINE);
    }

    public LinkedList<String> lines() {
        LinkedList<String> lines = new LinkedList<String>();
        for (MEncStr line : this.iLines) {
            lines.add(line.toString());
        }
        return lines;
    }

    public int numLines() {
        return this.iLines.size();
    }

    public boolean isEmpty() {
        return this.iLines.size() <= 3;
    }

    public String defaultFileName() {
        MString name = new MString(String.valueOf(this.title()) + FILEEXT);
        name.replaceRepetition(' ');
        name.replace(' ', '-');
        name.toLowerCase();
        return name.toString();
    }

    public void addTitle() {
        String firstLine = "Report: " + this.iTitle.toString();
        if (this.iShowDate) {
            GregorianCalendar now = new GregorianCalendar();
            firstLine = String.valueOf(firstLine) + ", " + DATEFORMAT.format(now.getTime());
        }
        this.iLines.add(new MEncStr(firstLine));
        MEncStr divider = this.divider(firstLine.length());
        this.iLines.add(divider);
    }

    public void filter(char startDelim, char endDelim) {
        LinkedList<MEncStr> newLines = new LinkedList<MEncStr>();
        for (MEncStr line : this.iLines) {
            MString str = line.str();
            str.removeBlock(startDelim, endDelim);
            newLines.add(new MEncStr(str));
        }
        this.iLines = newLines;
    }

    public void writeTo(MLogging logger) {
        for (MEncStr str : this.iLines) {
            logger.writeln(str.str().toString());
        }
        logger.close();
    }

    public String toString() {
        return this.title();
    }

    private MEncStr divider(int minWidth) {
        int len = 0;
        for (MEncStr line : this.iLines) {
            if (line.length() <= len) continue;
            len = line.length();
        }
        if (len < minWidth) {
            len = minWidth;
        }
        MString divider = new MString();
        divider.fill('-', len);
        return new MEncStr(divider);
    }
}

