/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeSet;
import mlib.MCmdParser;
import mlib.MLogger;
import mlib.MLogging;
import utilt.Utility;

public class MProgArgs
implements Serializable {
    private MCmdParser.Arguments iCmdArgs = null;
    private transient int iNumRequired = 0;
    private transient int iNumFound = 0;
    private transient String iUnknownArg = null;
    private transient ArrayList<Arg> iArgs = new ArrayList();
    private static final char VALUESPREFIX = '-';
    private static final char VALUESDELIM = ',';
    private static final int NOERROR = 0;
    private static final int NOTSUPPLIED = 1;
    private static final int INVALNUM_VALUES = 2;
    private static final MCmdParser Parser = new MCmdParser('-', ',');

    public static void main(String[] args) {
        MProgArgs progArgs = new MProgArgs();
        try {
            progArgs.addArg("f", "Test file (no default)", null, true, 1, 1);
            progArgs.addArg("e", "Flag for running as exercise", null, false, 0, 0);
            progArgs.showDesc(new MLogger.System());
            boolean status = progArgs.parse(args);
            if (!status) {
                progArgs.showFirstError(new MLogger.System());
            }
            String filePath = progArgs.argValue("f", 0);
            boolean exercise = progArgs.argSupplied("e");
            System.out.println(String.valueOf(exercise) + " " + filePath);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public void addArg(String name, String desc, String def, boolean required, int minValues, int maxValues) throws Exception {
        Arg newArg = new Arg(name, desc, def, required, minValues, maxValues);
        this.iArgs.add(newArg);
        if (required && def == null) {
            ++this.iNumRequired;
        }
    }

    public void removeAllArgs() {
        this.iArgs.clear();
        this.iNumRequired = 0;
        this.iNumFound = 0;
    }

    public void removeArg(String name) {
        Arg arg = this.findArg(name);
        if (arg != null) {
            this.iArgs.remove(arg);
        }
    }

    public int numFound() {
        return this.iNumFound;
    }

    public int numRequired() {
        return this.iNumRequired;
    }

    public boolean argSupplied(String name) {
        boolean supplied = false;
        Arg arg = this.findArg(name);
        if (arg != null && arg.iStatus == 0) {
            supplied = arg.iSupplied || arg.iDefault != null;
        }
        return supplied;
    }

    public int numArgValues(String name) {
        int num = -1;
        Arg arg = this.findArg(name);
        if (arg != null && arg.iStatus == 0) {
            num = arg.iNumValues;
        }
        return num;
    }

    public String[] arg(String name) {
        String[] values = null;
        Arg arg = this.findArg(name);
        if (arg != null && arg.iStatus == 0) {
            values = arg.iValues;
        }
        return values;
    }

    public String argAsString(String name) {
        String str = "";
        Arg arg = this.findArg(name);
        if (arg != null && arg.iStatus == 0) {
            int count = 0;
            String[] stringArray = arg.iValues;
            int n = arg.iValues.length;
            int n2 = 0;
            while (n2 < n) {
                String anArg = stringArray[n2];
                if (count++ > 0) {
                    str = String.valueOf(str) + ",";
                }
                str = String.valueOf(str) + anArg;
                ++n2;
            }
        }
        return str;
    }

    public String argValue(String name, int number) {
        String value = null;
        Arg arg = this.findArg(name);
        if (arg != null && arg.iStatus == 0 && arg.iNumValues > number) {
            value = arg.iValues[number].trim();
        }
        return value;
    }

    public boolean parse(String[] args) {
        boolean status = true;
        if (this.iArgs.size() > 0) {
            this.iUnknownArg = null;
            String cmd = "";
            int i = 0;
            while (i < args.length) {
                cmd = String.valueOf(cmd) + args[i] + " ";
                ++i;
            }
            if (cmd.length() > 0) {
                this.iCmdArgs = Parser.parse(cmd);
                if (this.iCmdArgs != null) {
                    this.iUnknownArg = this.testForUnknownArg(this.iCmdArgs);
                    if (this.iUnknownArg == null) {
                        i = 0;
                        while (status && i < this.iArgs.size()) {
                            Arg arg = this.iArgs.get(i);
                            status = arg.parse(this.iCmdArgs) == 0;
                            ++i;
                        }
                    } else {
                        status = false;
                    }
                }
            }
            if (status) {
                status = this.testForRequired();
            }
        }
        return status;
    }

    public String testForUnknownArg(MCmdParser.Arguments args) {
        String unknown = null;
        MCmdParser.Arg[] allArgs = args.allArgs();
        int i = 0;
        while (i < allArgs.length) {
            boolean found = false;
            int j = 0;
            while (j < this.iArgs.size()) {
                Arg arg = this.iArgs.get(j);
                if (allArgs[i].getName().equalsIgnoreCase(arg.iName)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                unknown = allArgs[i].getName();
                break;
            }
            ++i;
        }
        return unknown;
    }

    public void showFirstError(MLogging logger) {
        if (this.iUnknownArg != null) {
            logger.writeln("Argument " + this.iUnknownArg + " is unknown.", true);
        } else {
            Arg arg = null;
            int i = 0;
            while (i < this.iArgs.size()) {
                arg = this.iArgs.get(i);
                if (arg.iStatus != 0) {
                    String msg = null;
                    if (arg.iStatus == 1) {
                        msg = "Argument " + arg.iName + " required";
                    } else if (arg.iStatus == 2) {
                        msg = "Argument " + arg.iName + " has an invalid number of values.";
                    }
                    logger.writeln(msg, true);
                    break;
                }
                ++i;
            }
        }
    }

    public void showDesc(MLogging logger) {
        logger.writeln("Arguments are:", false);
        TreeSet<Arg> args = new TreeSet<Arg>();
        args.addAll(this.iArgs);
        for (Arg arg : args) {
            String desc = String.valueOf(arg.iName) + '-' + arg.iDesc.toString();
            if (!arg.iRequired) {
                desc = String.valueOf(desc) + ", optional";
            }
            logger.writeln("   " + desc, false);
        }
    }

    private Arg findArg(String name) {
        Arg arg = null;
        int i = 0;
        while (i < this.iArgs.size()) {
            Arg anArg = this.iArgs.get(i);
            if (anArg.iName.equalsIgnoreCase(name)) {
                arg = anArg;
                break;
            }
            ++i;
        }
        return arg;
    }

    private boolean testForRequired() {
        boolean status = true;
        int i = 0;
        while (status && i < this.iArgs.size()) {
            Arg arg = this.iArgs.get(i);
            if (arg.iRequired) {
                status = this.argSupplied(arg.iName);
            }
            ++i;
        }
        return status;
    }

    private class Arg
    implements Comparable<Arg> {
        String iName = "";
        String iDesc = null;
        String[] iValues = null;
        boolean iRequired = false;
        String iDefault = null;
        boolean iSupplied = false;
        int iMaxValues = 0;
        int iMinValues = 0;
        int iNumValues = 0;
        int iStatus = 1;

        Arg(String name, String desc, String def, boolean required, int minValues, int maxValues) throws Exception {
            this.iName = name;
            this.iDesc = desc;
            this.iRequired = required;
            this.iMinValues = minValues;
            this.iMaxValues = maxValues;
            this.iDefault = def;
            if (this.iDefault != null) {
                this.iValues = Utility.parseDelimStr(this.iDefault, ",");
                if (this.iValues.length < minValues || this.iValues.length > maxValues) {
                    Utility.throwError("invalid number of argument values: " + name + "," + this.iValues.length);
                }
                this.iNumValues = this.iValues.length;
                this.iStatus = 0;
            }
            if (!required) {
                this.iStatus = 0;
            }
        }

        int parse(MCmdParser.Arguments args) {
            this.iStatus = 0;
            MCmdParser.Arg[] allArgs = args.allArgs();
            int i = 0;
            while (!this.iSupplied && i < allArgs.length) {
                String name = allArgs[i].getName();
                if (name.equalsIgnoreCase(this.iName)) {
                    if (allArgs[i].getValues() != null) {
                        this.iValues = allArgs[i].getValues();
                        this.iNumValues = this.iValues.length;
                    }
                    this.iSupplied = true;
                }
                ++i;
            }
            if (this.iSupplied) {
                MProgArgs mProgArgs = MProgArgs.this;
                mProgArgs.iNumFound = mProgArgs.iNumFound + 1;
                if (this.iNumValues > this.iMaxValues || this.iNumValues < this.iMinValues) {
                    this.iStatus = 2;
                }
            }
            return this.iStatus;
        }

        @Override
        public int compareTo(Arg arg) {
            int res = 0;
            if (arg != this) {
                res = -1;
                if (arg != null) {
                    res = this.iName.compareTo(arg.iName);
                }
            }
            return res;
        }

        public boolean equals(Object obj) {
            return this.compareTo((Arg)obj) == 0;
        }

        public String toString() {
            return this.iName;
        }
    }
}

