/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.Serializable;
import java.util.TreeMap;
import utilt.Utility;

public class MAppMsg
implements Serializable {
    private String iName = null;
    private String iMsg = null;
    private short iNumArgs = 0;
    private boolean iError = false;
    public static final char SUBSTITUTE = '%';
    public static final String DEBUGDELIM = " > ";
    private static final String ARG1 = "%1";
    private static final String ARG2 = "%2";
    private static final String ERRORMSG = "Invalid arguments for message: ";

    public MAppMsg(String name, String msg, boolean error) {
        this.iName = name;
        this.iMsg = msg;
        this.iError = error;
        int index = msg.indexOf(ARG1);
        if (index >= 0) {
            this.iNumArgs = (short)(this.iNumArgs + 1);
        }
        if ((index = this.iMsg.indexOf(ARG2)) >= 0) {
            this.iNumArgs = (short)(this.iNumArgs + 1);
        }
    }

    public String name() {
        return this.iName;
    }

    public String msg() {
        return this.iMsg;
    }

    public boolean isError() {
        return this.iError;
    }

    public String format() {
        return this.iMsg;
    }

    public String format(String arg) {
        String format = this.iMsg;
        format = this.iNumArgs == 1 ? format.replace(ARG1, arg) : ERRORMSG + this.iName;
        return format;
    }

    public String format(String arg1, String arg2) {
        String format = this.iMsg;
        if (this.iNumArgs == 2) {
            format = format.replace(ARG1, arg1);
            format = format.replace(ARG2, arg2);
        } else {
            format = ERRORMSG + this.iName;
        }
        return format;
    }

    public String format(Exception xcp) {
        String format = this.iMsg;
        format = this.iNumArgs == 1 ? format.replace(ARG1, Utility.xcpMsg(xcp)) : ERRORMSG + this.iName;
        return format;
    }

    public String format(int arg) {
        String format = this.iMsg;
        format = this.iNumArgs == 1 ? format.replace(ARG1, Integer.toString(arg)) : ERRORMSG + this.iName;
        return format;
    }

    public String format(int arg1, int arg2) {
        String format = this.iMsg;
        if (this.iNumArgs == 2) {
            format = format.replace(ARG1, Integer.toString(arg1));
            format = format.replace(ARG2, Integer.toString(arg2));
        } else {
            format = ERRORMSG + this.iName;
        }
        return format;
    }

    public static class Database {
        private TreeMap<String, MAppMsg> iMsgs = new TreeMap();

        public void add(MAppMsg msg) throws Exception {
            MAppMsg existing = this.iMsgs.get(msg.name());
            if (existing != null) {
                Exception xcp = new Exception("Duplicate UserMsg name: " + msg.name());
                throw xcp;
            }
            for (MAppMsg aMsg : this.iMsgs.values()) {
                if (!aMsg.msg().equalsIgnoreCase(msg.msg())) continue;
                Exception xcp = new Exception("Duplicate UserMsg: " + aMsg.msg());
                throw xcp;
            }
            this.iMsgs.put(msg.name(), msg);
        }

        public MAppMsg get(String name) {
            MAppMsg msg = this.iMsgs.get(name);
            if (msg == null) {
                String text = new String("Message not found: %1");
                text = text.replace(MAppMsg.ARG1, name);
                msg = new MAppMsg("", text.toString(), true);
            }
            return msg;
        }

        public void add(Database db) throws Exception {
            for (MAppMsg aMsg : db.iMsgs.values()) {
                this.add(aMsg);
            }
        }
    }
}

