/*
 * Decompiled with CFR 0.152.
 */
package misc;

import files.FileInfo;
import files.Filesystem;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.PicTag;
import oroma.db.Query;

public class SampleAlbum {
    public static final String SAMPLENAME = "Sample Album";
    private static final String TOPIC = "FSA-OWI samples";
    private static final String RATING = "Selected";
    private static final String COUNTRY = "U.S.A.";
    private static final String SAMPLESDIRNAME = "samples";
    private static final String FILM = "Kodachrome";

    public static void create() throws Exception {
        Database db = Database.singleton();
        db.clear();
        Filesystem.Local fs = new Filesystem.Local(db.parms().bpmPath(), true);
        FileInfo.Local samplesDir = new FileInfo.Local((Filesystem)fs, SAMPLESDIRNAME);
        db.putPic(SampleAlbum.picInfo1(samplesDir), false);
        db.putPic(SampleAlbum.picInfo2(samplesDir), false);
        db.putPic(SampleAlbum.picInfo3(samplesDir), false);
        db.putPic(SampleAlbum.picInfo4(samplesDir), false);
        db.putPic(SampleAlbum.picInfo5(samplesDir), false);
        db.putPic(SampleAlbum.picInfo6(samplesDir), false);
        db.putPic(SampleAlbum.picInfo7(samplesDir), false);
        db.putPic(SampleAlbum.picInfo8(samplesDir), false);
        db.putPic(SampleAlbum.picInfo9(samplesDir), false);
        db.putPic(SampleAlbum.picInfo10(samplesDir), false);
        db.putQuery(SampleAlbum.createAlbum(), true);
        db.save();
    }

    private static Query createAlbum() throws Exception {
        Query query = new Query(Database.singleton().nextObjNum());
        query.setName(SAMPLENAME);
        query.setDesc("Sample FSA-OWI color photos, Library of Congress");
        query.setCategory("*");
        PicInfo info = query.picInfo();
        info.comboField("topic").setValue(TOPIC);
        info.comboField("country").setValue(COUNTRY);
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1940);
        info.setUncer(5);
        return query;
    }

    private static PicInfo picInfo1(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a33853u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("town").setValue("Brockton");
        info.comboField("region").setValue("Massachusetts");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Jack Delano");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1940);
        return info;
    }

    private static PicInfo picInfo2(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a33894u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("region").setValue("Georgia");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Jack Delano");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1941);
        PicTag tag = new PicTag("Child watching family", 25, 750);
        info.tags().add(tag);
        return info;
    }

    private static PicInfo picInfo3(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a34096u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("town").setValue("Pie Town");
        info.comboField("region").setValue("New Mexico");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Russell Lee");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1940);
        return info;
    }

    private static PicInfo picInfo4(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a34209u.jpg";
        info.setPicPathname(picPath);
        info.comboField("place").setValue("Main Street");
        info.comboField("topic").setValue(TOPIC);
        info.comboField("town").setValue("Cascade");
        info.comboField("region").setValue("Idaho");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Russell Lee");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1941);
        return info;
    }

    private static PicInfo picInfo5(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a34426u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("town").setValue("Washington");
        info.comboField("region").setValue("D.C.");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Louise Rosskam");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1942);
        info.setNotes("Location uncertain");
        return info;
    }

    private static PicInfo picInfo6(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a34807u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("town").setValue("Clinton");
        info.comboField("region").setValue("Iowa");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Jack Delano");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1943);
        info.setNotes("Steam cleaning locomotive");
        return info;
    }

    private static PicInfo picInfo7(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a34951u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("place").setValue("Consolidated Aircraft Corporation");
        info.comboField("town").setValue("Fort Worth");
        info.comboField("region").setValue("Texas");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Howard R. Hollem");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1942);
        return info;
    }

    private static PicInfo picInfo8(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a35238u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("place").setValue("TVA Douglas Dam");
        info.comboField("region").setValue("Tennessee");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Alfred T. Palmer");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1942);
        return info;
    }

    private static PicInfo picInfo9(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a35291u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("place").setValue("North American Aviation");
        info.comboField("town").setValue("Kansas City");
        info.comboField("region").setValue("Kansas");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Alfred T. Palmer");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1942);
        PicTag tag = new PicTag("B-25 bomber", 500, 700);
        info.tags().add(tag);
        return info;
    }

    private static PicInfo picInfo10(FileInfo samplesDir) throws Exception {
        PicInfo info = new PicInfo(Database.singleton().nextObjNum());
        String picPath = String.valueOf(samplesDir.path()) + "1a35360u.jpg";
        info.setPicPathname(picPath);
        info.comboField("topic").setValue(TOPIC);
        info.comboField("place").setValue("Douglas Aircraft Company");
        info.comboField("town").setValue("Long Beach");
        info.comboField("region").setValue("California");
        info.comboField("country").setValue(COUNTRY);
        info.comboField("taken by").setValue("Alfred T. Palmer");
        info.comboField("rating").setValue(RATING);
        info.comboField("film type").setValue(FILM);
        info.setYear(1942);
        return info;
    }
}

