/*
 * Decompiled with CFR 0.152.
 */
package minstall;

import files.ApacheFtpServer;
import files.FtpServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Date;
import java.util.zip.ZipFile;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mlib.MLogger;
import swing.ColorPanel;
import swing.SwingProgram;
import utilt.Utility;
import utilt.ZipHandler;

public abstract class Installer
extends SwingProgram {
    private JTextArea iTextArea = new JTextArea();
    private String iProgName = null;
    private String iProgAbbrev = null;
    private String iProgServerDirName = null;
    private String iProgLatestZipFileName = null;
    private String iProgLatestJarFileName = null;
    private String iProgLocalJarFileName = null;
    private String iProgInstallerZipFileName = null;
    private String[] iInstallOnceFiles = null;
    private static final String PREFIX = " > ";

    public Installer() {
        this.setTitle(this.iProgName);
        this.center(0.5, 0.5);
        ColorPanel panel = new ColorPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.iTextArea), "Center");
        this.getContentPane().add(panel);
        this.addWindowListener(new WindowHandler());
        this.iTextArea.setFont(Utility.stdFont());
        this.setIconImage(this.iconMgr().icon("bpm").getImage());
        this.setLogger(new MLogger.TextArea(this.iTextArea));
        this.logger().setPrefix(PREFIX);
    }

    public void setup(String progName, String progAbbrev, String[] installOnceFiles) {
        this.iProgName = progName;
        this.iProgServerDirName = this.iProgAbbrev = progAbbrev;
        this.iProgLatestZipFileName = String.valueOf(this.iProgAbbrev) + "-latest.zip";
        this.iProgLatestJarFileName = String.valueOf(this.iProgAbbrev) + "-latest.jar";
        this.iProgLocalJarFileName = String.valueOf(this.iProgAbbrev) + ".jar";
        this.iProgInstallerZipFileName = String.valueOf(this.iProgAbbrev) + "-installer.zip";
        this.iInstallOnceFiles = installOnceFiles;
    }

    public boolean process(String installerVersion) {
        boolean success = false;
        this.logger().writeln("Installer version " + installerVersion);
        try {
            Date latestProgVer = this.download();
            if (latestProgVer != null) {
                this.extract();
                success = this.install(latestProgVer);
            }
            String curDir = System.getProperty("user.dir");
            File file = new File(String.valueOf(curDir) + File.separator + this.iProgLatestZipFileName);
            file.delete();
            file = new File(String.valueOf(curDir) + File.separator + this.iProgInstallerZipFileName);
            file.delete();
        }
        catch (Exception xcp) {
            this.logger().writeln("*****Installation error: " + Utility.xcpMsg(xcp));
        }
        return success;
    }

    public void showMsg(String msg) {
        this.logger().writeln(msg);
    }

    public abstract boolean writeInstallFile(Date var1);

    private Date download() {
        Date date = null;
        try {
            ApacheFtpServer server = new ApacheFtpServer(new MLogger.Empty());
            server.setHoldCount(FtpServer.defaultHoldCount());
            server.setParms(FtpServer.Parms.instrParms());
            this.logger().writeln("Downloading latest version... ");
            try {
                try {
                    server.connect();
                    String fromPath = String.valueOf(this.iProgServerDirName) + "/" + this.iProgLatestZipFileName;
                    String toPath = String.valueOf(System.getProperty("user.dir")) + File.separator + this.iProgLatestZipFileName;
                    server.downloadFile(fromPath, toPath);
                    File file = new File(toPath);
                    date = new Date(file.lastModified());
                }
                catch (Exception xcp) {
                    this.logger().writeln("Unable to download from server");
                    server.disconnect();
                }
            }
            finally {
                server.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    private void extract() throws Exception {
        try (ZipFile zipFile = null;){
            try {
                String curDir = System.getProperty("user.dir");
                File toFolder = new File(curDir);
                zipFile = new ZipFile(String.valueOf(curDir) + File.separator + this.iProgLatestZipFileName);
                ZipHandler.extract(zipFile, toFolder, this.iInstallOnceFiles, this.logger());
            }
            catch (Exception xcp) {
                System.out.println(xcp);
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
    }

    private boolean install(Date latestVer) throws Exception {
        boolean success = false;
        String curDir = System.getProperty("user.dir");
        if (!curDir.endsWith(File.separator)) {
            curDir = String.valueOf(curDir) + File.separator;
        }
        File installed = new File(String.valueOf(curDir) + this.iProgLocalJarFileName);
        installed.delete();
        File latest = new File(String.valueOf(curDir) + this.iProgLatestJarFileName);
        File toRun = new File(String.valueOf(curDir) + this.iProgLocalJarFileName);
        Utility.copyFile(latest, toRun);
        latest.delete();
        if (this.writeInstallFile(latestVer)) {
            this.logger().writeln("Installation successful");
            this.logger().writeln("Installation is up-to-date");
            success = true;
        } else {
            this.logger().writeln("Unable to write installation file");
            this.logger().writeln("Installation unsuccessful");
        }
        File file = new File(String.valueOf(curDir) + File.separator + this.iProgInstallerZipFileName);
        file.delete();
        return success;
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }
    }
}

