/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Comparator;

public class Percent
implements Serializable,
Comparable<Percent> {
    private float iValue = -999.0f;
    private boolean iRounded = false;
    public static final DecimalFormat FORMAT = new DecimalFormat("0.0");
    private static final DecimalFormat ROUNDED = new DecimalFormat("0");
    private static final float NOVALUE = -999.0f;
    private static final long serialVersionUID = -4254511954121967823L;

    public Percent(float value) {
        this.iValue = value;
    }

    public Percent(double value) {
        this.iValue = (float)value;
    }

    public void add(Percent pc) {
        this.iValue += pc.iValue;
    }

    public boolean hasValue() {
        Float value = Float.valueOf(this.iValue);
        boolean has = !value.isInfinite() && !Double.isNaN(value.floatValue());
        return has;
    }

    public float value() {
        return this.iValue;
    }

    public void round() {
        this.iValue = (int)((double)this.iValue + 0.5);
        this.iRounded = true;
    }

    public Percent rounded() {
        Percent pc = new Percent(this.iValue);
        pc.round();
        return pc;
    }

    public Percent plus(Percent pc) {
        return new Percent(this.iValue + pc.iValue);
    }

    public Percent minus(Percent pc) {
        return new Percent(this.iValue - pc.iValue);
    }

    public Percent divideBy(float value) {
        return new Percent(this.iValue / value);
    }

    @Override
    public int compareTo(Percent pc) {
        int result = 0;
        if (pc != this) {
            result = -1;
            if (pc != null) {
                result = this.iValue > pc.iValue ? 1 : (this.iValue < pc.iValue ? -1 : 0);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo((Percent)obj) == 0;
    }

    public int hashCode() {
        return (int)this.iValue;
    }

    public String toString() {
        DecimalFormat format = FORMAT;
        if (this.iRounded) {
            format = ROUNDED;
        }
        return String.valueOf(format.format(this.iValue)) + "%";
    }

    public static class DuplicatesOrderer
    implements Comparator<Percent> {
        @Override
        public int compare(Percent percent1, Percent percent2) {
            int result = -1;
            if (percent1 != null && percent2 != null && (result = percent1.compareTo(percent2)) == 0) {
                result = -1;
            }
            return result;
        }
    }
}

