/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.DataBin;
import math.DataModel;

public class LinearModel
extends DataModel {
    private double iSumX = 0.0;
    private double iSumY = 0.0;
    private double iSumXY = 0.0;
    private double iSumXSqd = 0.0;
    private double iSumWt = 0.0;
    public static final String SLOPE = "slope";
    public static final String YINTER = "yinter";

    public static LinearModel fit(DataBin.Dataset dataset) {
        LinearModel model = new LinearModel();
        model.doSums(dataset);
        model.doParms(dataset);
        return model;
    }

    public LinearModel(double slope, double yInter) {
        DataModel.Parm[] state = new DataModel.Parm[]{new DataModel.Parm(SLOPE, slope), new DataModel.Parm(YINTER, yInter)};
        this.setState(state);
    }

    @Override
    public double value(DataBin bin) {
        DataModel.Parm[] state = this.state();
        double value = state[0].value() * (double)bin.center() + state[1].value();
        return value;
    }

    @Override
    public double partialDeriv(DataBin bin, DataModel.Parm parm) {
        DataModel.Parm yinter = this.parm(YINTER);
        return yinter.value();
    }

    private LinearModel() {
    }

    private void doSums(DataBin.Dataset dataset) {
        DataBin[] bins;
        DataBin[] dataBinArray = bins = dataset.bins();
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            DataBin bin = dataBinArray[n2];
            if (bin.hasValue()) {
                this.iSumX += (double)bin.center();
                this.iSumY += (double)bin.count();
                this.iSumXY += (double)(bin.center() * (float)bin.count());
                this.iSumXSqd += (double)(bin.center() * bin.center());
                this.iSumWt += (double)bin.weight();
            }
            ++n2;
        }
    }

    private void doParms(DataBin.Dataset dataset) {
        DataBin[] bins;
        double denom = this.iSumXSqd * this.iSumWt - this.iSumX * this.iSumX;
        double slope = (this.iSumWt * this.iSumXY - this.iSumX * this.iSumY) / denom;
        double yInter = (this.iSumXSqd * this.iSumY - this.iSumX * this.iSumXY) / denom;
        DataModel.Parm[] state = new DataModel.Parm[]{new DataModel.Parm(SLOPE, slope), new DataModel.Parm(YINTER, yInter)};
        this.setState(state);
        double sumRes = 0.0;
        DataBin[] dataBinArray = bins = dataset.bins();
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            DataBin bin = dataBinArray[n2];
            if (bin.hasValue()) {
                bin.setModelCount((float)this.value(bin));
                sumRes += (double)(bin.residual() * bin.residual());
            }
            ++n2;
        }
        double fitSigma = Math.sqrt(sumRes / (double)(bins.length - 2));
        double slopeSigma = Math.sqrt(this.iSumWt / denom) * fitSigma;
        state[0].setSigma(slopeSigma);
        double yinterSigma = Math.sqrt(this.iSumXSqd / denom) * fitSigma;
        state[1].setSigma(yinterSigma);
    }
}

