/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.io.Serializable;
import java.text.DecimalFormat;
import mlib.MString;
import utilt.Utility;

public class FloatVector
implements Serializable,
Comparable<FloatVector> {
    private float[] iEles = null;
    private static final long serialVersionUID = 7732952308897333351L;

    public FloatVector(int numEles) throws Exception {
        if (numEles <= 0) {
            Utility.throwError("Invalid number of elements");
        }
        this.iEles = new float[numEles];
        this.init(0.0f);
    }

    public FloatVector(float[] eles) throws Exception {
        this(eles.length);
        int i = 0;
        while (i < this.iEles.length) {
            this.iEles[i] = eles[i];
            ++i;
        }
    }

    public FloatVector(float ele1, float ele2, float ele3) throws Exception {
        this(3);
        this.iEles[0] = ele1;
        this.iEles[1] = ele2;
        this.iEles[2] = ele3;
    }

    public void init(float value) {
        int i = 0;
        while (i < this.iEles.length) {
            this.iEles[i] = value;
            ++i;
        }
    }

    public float ele(int index) {
        return this.iEles[index];
    }

    public void setEle(int index, float value) {
        this.iEles[index] = value;
    }

    public float[] eles() {
        return this.iEles;
    }

    public int length() {
        return this.iEles.length;
    }

    public float dot(FloatVector vec) throws Exception {
        this.test(vec);
        float dot = 0.0f;
        int i = 0;
        while (i < this.iEles.length) {
            dot += this.iEles[i] * vec.iEles[i];
            ++i;
        }
        return dot;
    }

    public void sum(FloatVector vec) throws Exception {
        this.test(vec);
        int i = 0;
        while (i < this.iEles.length) {
            int n = i;
            this.iEles[n] = this.iEles[n] + vec.iEles[i];
            ++i;
        }
    }

    public float separation(FloatVector vec) throws Exception {
        this.test(vec);
        float diff = 0.0f;
        int i = 0;
        while (i < this.iEles.length) {
            float eleDiff = this.iEles[i] - vec.iEles[i];
            diff += eleDiff * eleDiff;
            ++i;
        }
        diff = (float)Math.sqrt(diff);
        return diff;
    }

    public void mul(float factor) {
        int i = 0;
        while (i < this.iEles.length) {
            int n = i++;
            this.iEles[n] = this.iEles[n] * factor;
        }
    }

    public FloatVector combine(FloatVector vector) throws Exception {
        float[] eles = new float[this.iEles.length + vector.iEles.length];
        int i = 0;
        while (i < this.iEles.length) {
            eles[i] = this.iEles[i];
            ++i;
        }
        int j = 0;
        while (i < vector.iEles.length) {
            eles[i] = vector.iEles[j++];
            ++i;
        }
        return new FloatVector(eles);
    }

    public float mag() {
        float mag = 0.0f;
        int i = 0;
        while (i < this.iEles.length) {
            mag += this.iEles[i] * this.iEles[i];
            ++i;
        }
        mag = (float)Math.sqrt(mag);
        return mag;
    }

    public void normalize() {
        float mag = this.mag();
        int i = 0;
        while (i < this.iEles.length) {
            int n = i++;
            this.iEles[n] = this.iEles[n] / mag;
        }
    }

    @Override
    public int compareTo(FloatVector vec) {
        int res = 0;
        if (vec != this) {
            res = -1;
            if (vec != null) {
                float mag2;
                float mag1 = this.mag();
                if (mag1 < (mag2 = vec.mag())) {
                    res = -1;
                } else if (mag1 > mag2) {
                    res = 1;
                }
            }
        }
        return res;
    }

    public boolean equals(Object vec) {
        return this.compareTo((FloatVector)vec) == 0;
    }

    public int hashCode() {
        return (int)this.iEles[0];
    }

    public String format(DecimalFormat format) {
        MString str = new MString("[");
        int i = 0;
        while (i < this.iEles.length) {
            if (i > 0) {
                str.concat(",");
            }
            String ele = format.format(this.iEles[i]);
            str.concat(ele);
            ++i;
        }
        str.concat("]");
        return str.toString();
    }

    public String toString() {
        String str = Utility.objPrefix(this);
        str = String.valueOf(str) + this.iEles.length + "," + this.mag();
        return str;
    }

    private void test(FloatVector vec) throws Exception {
        if (vec.iEles.length != this.iEles.length) {
            throw new Exception("number of elements must match");
        }
    }
}

