/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import math.DistStats;

public interface Filterable {
    public static final float NOVALUE = -99999.0f;

    public double residual();

    public void setResidual(double var1);

    public double weight();

    public void setWeight(double var1);

    public boolean hasValue();

    public double value();

    public void setValue(double var1);

    public String label();

    public void setFilterByX(boolean var1);

    public boolean isFilterByX();

    public void setObject(Object var1);

    public Object object();

    public static class List<T>
    implements Serializable {
        private LinkedList<Filterable> iObjs = new LinkedList();
        private DistStats iStats = null;
        private Color iColor = null;
        private int iNumFiltered = 0;

        public List(String name) {
            this.iStats = new DistStats(name);
        }

        public String name() {
            return this.iStats.getName();
        }

        public void setName(String name) {
            this.iStats.setName(name);
        }

        public Color color() {
            return this.iColor;
        }

        public void setColor(Color color) {
            this.iColor = color;
        }

        public int numFiltered() {
            return this.iNumFiltered;
        }

        public Iterator<Filterable> iterator() {
            return this.iObjs.iterator();
        }

        public void add(Filterable obj) {
            this.iObjs.add(obj);
            this.iStats.add(obj.value(), obj.weight());
        }

        public void addAll(Collection<Filterable> objs) {
            for (Filterable obj : objs) {
                this.add(obj);
            }
        }

        public int size() {
            return this.iObjs.size();
        }

        public DistStats stats() {
            for (Filterable obj : this.iObjs) {
                double res = (obj.value() - this.iStats.avg()) / this.iStats.sigma();
                obj.setResidual((float)res);
            }
            return this.iStats;
        }

        public Filterable min() {
            double minValue = Double.MAX_VALUE;
            Filterable min = null;
            for (Filterable obj : this.iObjs) {
                double value = obj.value();
                if (value == -99999.0 || !(value < minValue)) continue;
                minValue = value;
                min = obj;
            }
            return min;
        }

        public Filterable max() {
            double maxValue = -1.7976931348623157E308;
            Filterable max = null;
            for (Filterable obj : this.iObjs) {
                double value = obj.value();
                if (value == -99999.0 || !(value > maxValue)) continue;
                maxValue = value;
                max = obj;
            }
            return max;
        }

        public List<T> noOutliers(String name, float sigmaUnits, Collection<Filterable> removed) {
            List<T> trimmed = new List<T>(name);
            double min = this.iStats.avg() - this.iStats.sigma() * (double)Math.abs(sigmaUnits);
            double max = this.iStats.avg() + this.iStats.sigma() * (double)Math.abs(sigmaUnits);
            for (Filterable obj : this.iObjs) {
                if (obj.value() > min && obj.value() < max) {
                    trimmed.add(obj);
                    continue;
                }
                removed.add(obj);
            }
            trimmed.iNumFiltered += removed.size();
            return trimmed;
        }

        public List<T> noOutliersAbove(String name, float sigmaUnits, Collection<Filterable> removed) {
            List<T> trimmed = new List<T>(name);
            double max = this.iStats.avg() + this.iStats.sigma() * (double)sigmaUnits;
            for (Filterable obj : this.iObjs) {
                if (obj.value() < max) {
                    trimmed.add(obj);
                    continue;
                }
                removed.add(obj);
            }
            trimmed.iNumFiltered += removed.size();
            return trimmed;
        }

        public List<T> onlyOutliersAboveRel(String name, float sigmaUnits, Collection<Filterable> removed) {
            List<T> trimmed = new List<T>(name);
            double max = this.iStats.avg() + this.iStats.sigma() * (double)sigmaUnits;
            for (Filterable obj : this.iObjs) {
                if (obj.value() > max) {
                    trimmed.add(obj);
                    continue;
                }
                removed.add(obj);
            }
            trimmed.iNumFiltered += removed.size();
            return trimmed;
        }

        public List<T> onlyOutliersBelowRel(String name, float sigmaUnits, Collection<Filterable> removed) {
            List<T> trimmed = new List<T>(name);
            double max = this.iStats.avg() + this.iStats.sigma() * (double)sigmaUnits;
            for (Filterable obj : this.iObjs) {
                if (obj.value() < max) {
                    trimmed.add(obj);
                    continue;
                }
                removed.add(obj);
            }
            trimmed.iNumFiltered += removed.size();
            return trimmed;
        }

        public List<T> removeMax(Collection<Filterable> removed) {
            List<T> list = new List<T>(this.iStats.getName());
            double max = this.iStats.maxValue();
            for (Filterable obj : this.iObjs) {
                if (obj.value() < max) {
                    list.add(obj);
                    continue;
                }
                removed.add(obj);
            }
            list.iNumFiltered += removed.size();
            return list;
        }

        public List<T> trimMax(float changeFactor, float maxChangeFrac, Collection<Filterable> removed) {
            List<T> trimmed;
            int maxToRemove = (int)(maxChangeFrac * (float)this.size() + 1.0f);
            List<T> prev = trimmed = this.copy();
            boolean done = false;
            while (!done) {
                double curSigma;
                trimmed = prev.removeMax(removed);
                boolean bl = done = removed.size() >= maxToRemove;
                if (done) continue;
                double prevSigma = prev.stats().sigma();
                double change = (prevSigma - (curSigma = trimmed.stats().sigma())) / prevSigma;
                boolean bl2 = done = change < (double)changeFactor;
                if (done) continue;
                prev = trimmed;
            }
            trimmed.iNumFiltered += this.iNumFiltered + this.size() - trimmed.size();
            return trimmed;
        }

        public List<T> trimMaxIgnoringZeros(float changeFactor, float maxChangeFrac, Collection<Filterable> removed) {
            List<T> noZeros = this.removeZeros();
            List<T> trimmed = noZeros.trimMax(changeFactor, maxChangeFrac, removed);
            trimmed = this.remove(removed);
            trimmed.iNumFiltered += this.iNumFiltered + this.size() - trimmed.size();
            return trimmed;
        }

        public List<T> removeMin(Collection<Filterable> removed) {
            List<T> list = new List<T>(this.iStats.getName());
            double min = this.iStats.minValue();
            for (Filterable obj : this.iObjs) {
                if (obj.value() > min) {
                    list.add(obj);
                    continue;
                }
                removed.add(obj);
            }
            list.iNumFiltered += removed.size();
            return list;
        }

        public List<T> trimMin(float changeFactor, Collection<Filterable> removed) {
            List<T> trimmed;
            List<T> prev = trimmed = this.copy();
            boolean done = false;
            while (!done) {
                double curSigma;
                trimmed = prev.removeMin(removed);
                double prevSigma = prev.stats().sigma();
                double change = (prevSigma - (curSigma = trimmed.stats().sigma())) / prevSigma;
                boolean bl = done = change < (double)changeFactor;
                if (done) continue;
                prev = trimmed;
            }
            trimmed.iNumFiltered += this.iNumFiltered + this.size() - trimmed.size();
            return trimmed;
        }

        public List<T> diff(List<T> set) {
            List<T> diff = new List<T>("diff");
            LinkedList<Filterable> larger = this.iObjs;
            LinkedList<Filterable> smaller = set.iObjs;
            if (set.iObjs.size() > this.iObjs.size()) {
                larger = set.iObjs;
                smaller = this.iObjs;
            }
            for (Filterable obj : larger) {
                if (smaller.contains(obj)) continue;
                diff.add(obj);
            }
            return diff;
        }

        public List<T> diff(List<T> set, Comparator<Filterable> comp) {
            List<T> diff = new List<T>("diff");
            LinkedList<Filterable> larger = this.iObjs;
            LinkedList<Filterable> smaller = set.iObjs;
            if (set.iObjs.size() > this.iObjs.size()) {
                larger = set.iObjs;
                smaller = this.iObjs;
            }
            for (Filterable obj1 : larger) {
                boolean found = false;
                for (Filterable obj2 : smaller) {
                    boolean bl = found = comp.compare(obj1, obj2) == 0;
                    if (found) break;
                }
                if (found) continue;
                diff.add(obj1);
            }
            return diff;
        }

        public String toString() {
            String str = this.iStats.toString();
            if (!str.endsWith(",")) {
                str = String.valueOf(str) + ',';
            }
            str = String.valueOf(str) + "-" + this.iNumFiltered;
            return str;
        }

        private List<T> copy() {
            List<T> copy = new List<T>(this.iStats.getName());
            for (Filterable obj : this.iObjs) {
                copy.add(obj);
            }
            return copy;
        }

        private List<T> removeZeros() {
            List<T> copy = new List<T>(this.iStats.getName());
            for (Filterable obj : this.iObjs) {
                double value = Math.abs(obj.value());
                if (!(value > Double.MIN_VALUE)) continue;
                copy.add(obj);
            }
            return copy;
        }

        private List<T> remove(Collection<Filterable> removed) {
            List<T> copy = new List<T>(this.iStats.getName());
            for (Filterable obj : this.iObjs) {
                boolean found = false;
                Iterator<Filterable> iter = removed.iterator();
                while (!found && iter.hasNext()) {
                    Filterable removedObj = iter.next();
                    double diff = Math.abs(obj.value() - removedObj.value());
                    boolean bl = found = diff < Double.MIN_VALUE;
                }
                if (found) continue;
                copy.add(obj);
            }
            return copy;
        }
    }
}

