/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import mlib.MLogging;
import utilt.Utility;

public interface Dataset<T extends Comparable<T>> {
    public String name();

    public void add(T var1);

    public void add(Collection<T> var1);

    public void add(Dataset<T> var1);

    public int size();

    public T min();

    public T max();

    public Collection<T> intersection(Dataset<T> var1);

    public Collection<T> objects();

    public Iterator<T> iterator();

    public void write(MLogging var1);

    public static class List<T extends Comparable<T>>
    implements Dataset<T>,
    Serializable {
        private String iName = null;
        private T iMin = null;
        private T iMax = null;
        private LinkedList<T> iObjects = new LinkedList();
        private static final long serialVersionUID = -1178043256306022831L;

        public List(String name) {
            this.iName = name;
        }

        @Override
        public String name() {
            return this.iName;
        }

        @Override
        public void add(T obj) {
            if (this.iMin == null) {
                this.iMin = obj;
            } else if (this.iMax == null) {
                this.iMax = obj;
            } else if (obj.compareTo(this.iMin) < 0) {
                this.iMin = obj;
            } else if (obj.compareTo(this.iMax) > 0) {
                this.iMax = obj;
            }
            this.iObjects.add(obj);
        }

        @Override
        public void add(Collection<T> objs) {
            Iterator<T> iter = objs.iterator();
            while (iter.hasNext()) {
                this.iObjects.add((Comparable)iter.next());
            }
        }

        @Override
        public void add(Dataset<T> dataset) {
            Iterator<T> iter = dataset.iterator();
            while (iter.hasNext()) {
                this.iObjects.add((Comparable)iter.next());
            }
        }

        @Override
        public int size() {
            return this.iObjects.size();
        }

        @Override
        public T min() {
            return this.iMin;
        }

        @Override
        public T max() {
            return this.iMax;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iObjects.iterator();
        }

        @Override
        public Collection<T> objects() {
            return this.iObjects;
        }

        @Override
        public Collection<T> intersection(Dataset<T> set) {
            LinkedList<Comparable> inter = new LinkedList<Comparable>();
            block0: for (Comparable thisObj : this.iObjects) {
                Collection<T> other = set.objects();
                for (Comparable setObj : other) {
                    if (!thisObj.equals(setObj)) continue;
                    inter.add(thisObj);
                    continue block0;
                }
            }
            return inter;
        }

        @Override
        public void write(MLogging logger) {
            String msg = String.valueOf(Utility.objPrefix(this)) + this.name() + ", " + this.size() + " points";
            logger.writeln(msg, false);
            for (Comparable thisObj : this.iObjects) {
                logger.writeln(thisObj.toString(), false);
            }
        }
    }

    public static class Set<T extends Comparable<T>>
    implements Dataset<T>,
    Serializable {
        private String iName = null;
        private T iMin = null;
        private T iMax = null;
        private TreeSet<T> iObjects = new TreeSet();
        private static final long serialVersionUID = -1178043256306022831L;

        public Set(String name) {
            this.iName = name;
        }

        @Override
        public String name() {
            return this.iName;
        }

        @Override
        public void add(T obj) {
            if (this.iMin == null) {
                this.iMin = obj;
                this.iMax = obj;
            } else if (obj.compareTo(this.iMin) < 0) {
                this.iMin = obj;
            } else if (obj.compareTo(this.iMax) > 0) {
                this.iMax = obj;
            }
            this.iObjects.add(obj);
        }

        @Override
        public void add(Collection<T> objs) {
            Iterator<T> iter = objs.iterator();
            while (iter.hasNext()) {
                this.iObjects.add((Comparable)iter.next());
            }
        }

        @Override
        public void add(Dataset<T> dataset) {
            Iterator<T> iter = dataset.iterator();
            while (iter.hasNext()) {
                this.iObjects.add((Comparable)iter.next());
            }
        }

        @Override
        public int size() {
            return this.iObjects.size();
        }

        @Override
        public T min() {
            return this.iMin;
        }

        @Override
        public T max() {
            return this.iMax;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iObjects.iterator();
        }

        @Override
        public Collection<T> objects() {
            return this.iObjects;
        }

        @Override
        public Collection<T> intersection(Dataset<T> set) {
            LinkedList<Comparable> inter = new LinkedList<Comparable>();
            block0: for (Comparable thisObj : this.iObjects) {
                Collection<T> other = set.objects();
                for (Comparable setObj : other) {
                    if (!thisObj.equals(setObj)) continue;
                    inter.add(thisObj);
                    continue block0;
                }
            }
            return inter;
        }

        public T median() {
            int count = this.iObjects.size() / 2;
            Iterator<T> iter = this.iterator();
            while (iter.hasNext() && count-- > 0) {
                iter.next();
            }
            Comparable median = (Comparable)iter.next();
            return (T)median;
        }

        @Override
        public void write(MLogging logger) {
            String msg = String.valueOf(Utility.objPrefix(this)) + this.name() + ", " + this.size() + " points";
            logger.writeln(msg, false);
            for (Comparable thisObj : this.iObjects) {
                logger.writeln(thisObj.toString(), false);
            }
        }
    }
}

