/*
 * Decompiled with CFR 0.152.
 */
package help;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import mlib.MString;
import utilt.Utility;

public class TaggedText
implements Serializable {
    private MString iTokens = new MString();
    private transient String[] iTokensArray = null;
    private static final char SPACE = ' ';
    private static final int ENCODE = 765123;
    static final long serialVersionUID = -4608594067699397511L;

    public static TaggedText parseText(String text) {
        TaggedText tText = new TaggedText();
        StringTokenizer tken = new StringTokenizer(text, " ");
        while (tken.hasMoreTokens()) {
            String token = tken.nextToken().trim();
            if (token.length() <= 0) continue;
            tText.iTokens.concat(String.valueOf(token) + ' ');
        }
        tText.iTokens.encode(765123);
        return tText;
    }

    public static TaggedText parseFile(String textFile) throws Exception {
        LinkedList<String> lines = Utility.readTextFile(textFile);
        TaggedText tText = new TaggedText();
        for (String line : lines) {
            TaggedText aText = TaggedText.parseText(line);
            tText.add(aText);
        }
        return tText;
    }

    public static boolean tokensMatch(String toFind, String aToken) {
        boolean match;
        int diff = Math.abs(toFind.length() - aToken.length());
        boolean bl = match = diff <= 1;
        if (match) {
            MString tempToFind = new MString(toFind);
            tempToFind.trimTail(' ');
            MString tempToken = new MString(aToken);
            tempToken.trimTail(' ');
            tempToken.trim('.');
            tempToken.trim(',');
            tempToken.trim(';');
            match = tempToFind.equalsIgnoreCase(tempToken);
        }
        return match;
    }

    public void add(TaggedText tText) {
        this.iTokens.concat(tText.iTokens);
    }

    public int length() {
        int len = 0;
        if (this.iTokens != null) {
            len = this.iTokens.length();
        }
        return len;
    }

    public boolean contains(TaggedText ttext) {
        String[] toFind = ttext.tokens();
        String[] tokens = this.tokens();
        boolean found = false;
        if (toFind != null) {
            int i = 0;
            while (i < tokens.length) {
                int j = 0;
                while (j < toFind.length) {
                    if (!TaggedText.tokensMatch(toFind[j], tokens[i + j])) break;
                    ++j;
                }
                if (j == toFind.length) {
                    found = true;
                }
                ++i;
            }
        }
        return found;
    }

    public String[] tokens() {
        if (this.iTokensArray == null) {
            this.iTokens.decode(765123);
            StringTokenizer tken = new StringTokenizer(this.iTokens.toString(), " ");
            this.iTokensArray = new String[tken.countTokens()];
            int index = 0;
            while (tken.hasMoreTokens()) {
                this.iTokensArray[index++] = String.valueOf(tken.nextToken()) + ' ';
            }
        }
        return this.iTokensArray;
    }

    public String toString() {
        return this.iTokens.length() + " characters";
    }
}

