/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.HelpPanel;
import help.TaggedText;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import utilt.Utility;

public class HelpNode
implements Serializable {
    private String iTitle = "";
    private String iTextFileName = null;
    private String iImageFileName = null;
    private int iImagePercent = 33;
    private boolean iImageAbove = true;
    private boolean iImageZoomable = false;
    private TaggedText iText = null;
    private transient Image iImage = null;
    public static final String LICENSE = "License";
    private static final String ERRMSG = "File must be in current directory: ";
    private static final long serialVersionUID = 1285719273898405876L;

    public HelpNode(String text) {
        this.iText = TaggedText.parseText(text);
    }

    public HelpNode(String title, String textFileName) throws Exception {
        this.iTitle = title;
        this.iTextFileName = textFileName;
        if (textFileName != null) {
            this.iText = TaggedText.parseFile(textFileName);
        }
    }

    public void setImage(String imgFileName, int imgPercent, boolean imgAbove, boolean zoomable) throws Exception {
        int index = imgFileName.indexOf(File.separator);
        if (index >= 0) {
            Utility.throwError(ERRMSG + imgFileName);
        }
        this.iImageFileName = imgFileName;
        this.iImagePercent = imgPercent;
        this.iImageAbove = imgAbove;
        this.iImageZoomable = zoomable;
    }

    public boolean equals(Object obj) {
        boolean equals;
        boolean bl = equals = obj == this;
        if (!equals && obj != null) {
            boolean bl2 = equals = this.getClass() == obj.getClass();
            if (equals) {
                HelpNode node = (HelpNode)obj;
                equals = this.iTitle.equals(node.iTitle);
            }
        }
        return equals;
    }

    public String textFileName() {
        return this.iTextFileName;
    }

    public String imageFileName() {
        return this.iImageFileName;
    }

    public int imagePercent() {
        return this.iImagePercent;
    }

    public TaggedText text() {
        return this.iText;
    }

    public String title() {
        return this.iTitle;
    }

    public boolean isImageAbove() {
        return this.iImageAbove;
    }

    public boolean isImageZoomable() {
        return this.iImageZoomable;
    }

    public void putImage(Image image) {
        this.iImage = image;
    }

    public Image image() {
        return this.iImage;
    }

    public synchronized void loadImage() throws IOException {
        if (this.iImageFileName != null) {
            try (InputStream is = null;){
                is = new BufferedInputStream(new FileInputStream(this.iImageFileName));
                this.iImage = ImageIO.read(is);
            }
        }
    }

    public synchronized void loadImageResource() throws Exception {
        if (this.iImageFileName != null) {
            URL url = HelpPanel.class.getResource(this.iImageFileName);
            this.iImage = Toolkit.getDefaultToolkit().getImage(url);
            ImageIcon imageIcon = new ImageIcon(this.iImage);
        }
    }

    public String toString() {
        int numTokens = 0;
        if (this.iText != null) {
            numTokens = this.iText.length();
        }
        String str = String.valueOf(this.iTitle.trim()) + ", " + numTokens + ", ";
        str = this.iImageFileName == null ? String.valueOf(str) + "none" : String.valueOf(str) + this.iImageFileName;
        return str;
    }
}

