/*
 * Decompiled with CFR 0.152.
 */
package files;

import files.FileInfo;
import files.FtpServer;
import java.io.File;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import mlib.MString;
import mlib.MWildcard;
import utilt.Utility;

public abstract class Filesystem {
    private FileInfo iRootDir = null;
    private boolean iWriteTo = true;
    private int iNumFiles = 0;
    private int iNumDirs = 0;

    private static void checkLocal(FileInfo info) throws Exception {
        if (info.getClass() != FileInfo.Local.class) {
            Utility.throwError("Parameter class must be: " + FileInfo.Local.class.getName());
        }
    }

    private static void checkApache(FileInfo info) throws Exception {
        if (info.getClass() != FileInfo.Apache.class) {
            Utility.throwError("Parameter class must be: " + FileInfo.Apache.class.getName());
        }
    }

    protected static boolean alwaysExclude(FileInfo info) {
        boolean exclude;
        String name = info.name();
        boolean bl = exclude = name.indexOf(".tmp") >= 0;
        if (!exclude) {
            boolean bl2 = exclude = name.charAt(0) == '.';
        }
        if (!exclude) {
            exclude = name.equalsIgnoreCase("x");
        }
        if (!exclude) {
            exclude = name.equalsIgnoreCase("y");
        }
        if (!exclude) {
            exclude = name.equalsIgnoreCase("z");
        }
        if (!exclude) {
            exclude = name.equalsIgnoreCase("x.txt");
        }
        return exclude;
    }

    public TreeMap<String, FileInfo> filesMap(LinkedList<MWildcard> excludes) throws Exception {
        TreeMap<String, FileInfo> map = new TreeMap<String, FileInfo>();
        this.doTree(this.iRootDir, map, excludes);
        return map;
    }

    public FileInfo rootDir() {
        return this.iRootDir;
    }

    public boolean isWriteTo() {
        return this.iWriteTo;
    }

    public int numFiles() {
        return this.iNumFiles;
    }

    public int numDirs() {
        return this.iNumDirs;
    }

    public String lastName() {
        return this.iRootDir.name();
    }

    public abstract boolean isLocal();

    public String toString() {
        String str = "Filesystem>" + this.iRootDir.path();
        return str;
    }

    public abstract void put(FileInfo var1, FileInfo var2) throws Exception;

    public abstract void put(FileInfo var1, String var2) throws Exception;

    public abstract void get(FileInfo var1, FileInfo var2) throws Exception;

    public abstract void mkdir(FileInfo var1) throws Exception;

    public abstract void mkdir(String var1) throws Exception;

    public abstract void setHoldCount(int var1) throws Exception;

    protected abstract void doTree(FileInfo var1, TreeMap<String, FileInfo> var2, LinkedList<MWildcard> var3) throws Exception;

    protected Filesystem(boolean writeTo) {
        this.iWriteTo = writeTo;
    }

    protected void setRootDir(FileInfo dir) {
        this.iRootDir = dir;
    }

    protected void incNumFiles() {
        ++this.iNumFiles;
    }

    protected void incNumDirs() {
        ++this.iNumDirs;
    }

    public static class ApacheFtp
    extends Filesystem {
        private FtpServer iServer = null;

        public ApacheFtp(String rootDirPath, boolean writeTo, FtpServer server) {
            super(writeTo);
            rootDirPath = rootDirPath.replace('\\', '/');
            if (!rootDirPath.endsWith("/")) {
                rootDirPath = String.valueOf(rootDirPath) + File.separatorChar;
            }
            this.setRootDir(new FileInfo.Apache(this, rootDirPath));
            this.iServer = server;
        }

        @Override
        public void get(FileInfo from, FileInfo to) throws Exception {
            Filesystem.checkApache(from);
            Filesystem.checkLocal(to);
            this.iServer.downloadFile(from.fileSysPath(), to.path());
        }

        @Override
        public void put(FileInfo from, FileInfo to) throws Exception {
            Filesystem.checkLocal(from);
            Filesystem.checkApache(to);
            this.iServer.uploadFile(to.path(), from.path());
        }

        @Override
        public void put(FileInfo from, String to) throws Exception {
            Filesystem.checkLocal(from);
            this.iServer.uploadFile(to, from.path());
        }

        @Override
        public void mkdir(FileInfo info) throws Exception {
            Filesystem.checkLocal(info);
            if (this.isWriteTo()) {
                this.iServer.mkdir(info.path());
            }
        }

        @Override
        public void mkdir(String path) throws Exception {
            if (this.isWriteTo()) {
                this.iServer.mkdir(path);
            }
        }

        @Override
        public void setHoldCount(int count) throws Exception {
            this.iServer.setHoldCount(count);
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        protected void doTree(FileInfo dir, TreeMap<String, FileInfo> map, LinkedList<MWildcard> excludes) throws Exception {
            this.doDir(dir.fileSysPath(), map, excludes);
            TreeSet<FileInfo> children = dir.directChildren();
            for (FileInfo child : children) {
                if (!child.isDir()) continue;
                this.doTree(child, map, excludes);
            }
        }

        protected FileInfo.Apache doDir(String fsPath, TreeMap<String, FileInfo> map, LinkedList<MWildcard> excludes) throws Exception {
            FileInfo.Apache dirInfo = null;
            int holdCount = this.iServer.holdCount();
            try {
                dirInfo = new FileInfo.Apache(this, fsPath);
                MString path = new MString(String.valueOf(this.rootDir().path()) + fsPath);
                path.trim(File.separatorChar);
                this.iServer.setHoldCount(FtpServer.defaultHoldCount());
                LinkedList<FileInfo> work = this.iServer.files(this, path.toString(), excludes);
                for (FileInfo anInfo : work) {
                    if (ApacheFtp.alwaysExclude(anInfo)) continue;
                    map.put(anInfo.path(), anInfo);
                }
            }
            finally {
                this.iServer.setHoldCount(holdCount);
            }
            return dirInfo;
        }
    }

    public static class Local
    extends Filesystem {
        public Local(String rootDirPath, boolean writeTo) throws Exception {
            super(writeTo);
            File file;
            rootDirPath = Utility.setupPath(rootDirPath);
            if (!rootDirPath.endsWith("/")) {
                rootDirPath = String.valueOf(rootDirPath) + File.separatorChar;
            }
            if (!(file = new File(rootDirPath)).exists()) {
                Utility.throwError("Root directory not found: " + rootDirPath);
            }
            this.setRootDir(new FileInfo.Local((Filesystem)this, file));
        }

        public Local(FileInfo.Local info, boolean writeTo) throws Exception {
            this(info.path(), writeTo);
        }

        @Override
        public void put(FileInfo from, FileInfo to) throws Exception {
            Filesystem.checkLocal(from);
            Filesystem.checkLocal(to);
            Utility.copyFile(from.path(), to.path());
        }

        @Override
        public void put(FileInfo from, String to) throws Exception {
            Filesystem.checkLocal(from);
            Utility.copyFile(from.path(), to);
        }

        @Override
        public void get(FileInfo from, FileInfo to) throws Exception {
            Filesystem.checkLocal(from);
            Filesystem.checkLocal(to);
            Utility.copyFile(from.path(), to.path());
        }

        @Override
        public void mkdir(FileInfo info) throws Exception {
            Filesystem.checkLocal(info);
            if (this.isWriteTo()) {
                File file = new File(info.path());
                file.mkdir();
            }
        }

        @Override
        public void mkdir(String path) throws Exception {
            if (this.isWriteTo()) {
                File file = new File(path);
                file.mkdir();
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public void setHoldCount(int count) {
        }

        @Override
        protected void doTree(FileInfo dir, TreeMap<String, FileInfo> map, LinkedList<MWildcard> excludes) throws Exception {
            FileInfo info = this.doDir(dir.fileSysPath(), map, excludes);
            TreeSet<FileInfo> children = info.directChildren();
            for (FileInfo child : children) {
                if (!child.isDir()) continue;
                this.doTree(child, map, excludes);
            }
        }

        private FileInfo doDir(String fsPath, TreeMap<String, FileInfo> map, LinkedList<MWildcard> excludes) throws Exception {
            this.incNumDirs();
            String path = String.valueOf(this.rootDir().path()) + fsPath;
            File dir = new File(path);
            File[] files = dir.listFiles();
            FileInfo.Local dirInfo = new FileInfo.Local((Filesystem)this, dir);
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean exclude;
                    File aFile = fileArray[n2];
                    FileInfo.Local anInfo = new FileInfo.Local((Filesystem)this, aFile);
                    if (aFile.isDirectory()) {
                        exclude = Local.alwaysExclude(anInfo);
                        if (!exclude) {
                            dirInfo.addChild(anInfo);
                            map.put(anInfo.fileSysPath(), anInfo);
                        }
                    } else {
                        exclude = Local.alwaysExclude(anInfo);
                        if (!exclude && excludes != null) {
                            for (MWildcard wc : excludes) {
                                exclude |= wc.matches(((FileInfo)anInfo).name());
                            }
                        }
                        if (!exclude) {
                            dirInfo.addChild(anInfo);
                            map.put(anInfo.fileSysPath(), anInfo);
                            this.incNumFiles();
                        }
                    }
                    ++n2;
                }
            }
            return dirInfo;
        }
    }
}

