/*
 * Decompiled with CFR 0.152.
 */
package files;

import files.FileInfo;
import files.Filesystem;
import files.FtpServer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;
import mlib.MWildcard;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.util.TrustManagerUtils;
import utilt.ImageIOUtil;
import utilt.Utility;

public class ApacheFtpServer
extends FtpServer {
    private FTPSClient iClient = null;
    private HostDirListings iCache = new HostDirListings();
    private String iConnectMsg = null;
    private static final String MSGPREFIX = "FTP: ";

    public static void main(String[] args) {
        ObjectOutputStream outs = null;
        ObjectInputStream ins = null;
        FtpServer.Parms parms = FtpServer.Parms.instrParms();
        ApacheFtpServer server = new ApacheFtpServer(parms, new MLogger.System());
        try {
            try {
                server.connect();
                String localPath = "c:\\misc\\may25-198.jpg";
                String serverPath = "tmp/may25-198.jpg";
                server.uploadFile(serverPath, localPath);
                String path = "c:\\misc\\pic.jpg";
                server.downloadFile(serverPath, path);
                BufferedImage image = ImageIOUtil.load(path);
                System.out.println(image);
                FtpServer.Parms bpvParms = new FtpServer.Parms("ftp.bluemontsw.com", "harper@bluemontsw.com", "Alfa25Jetta14$", "");
                String parmsPath = "c:\\java\\eclipse\\bpm\\bpv\\ftpparms.dat";
                outs = new ObjectOutputStream(new FileOutputStream(parmsPath));
                outs.writeObject(bpvParms);
                outs.close();
                ins = new ObjectInputStream(new FileInputStream(parmsPath));
                bpvParms = (FtpServer.Parms)ins.readObject();
                System.out.println(bpvParms);
                serverPath = "bpv/ftpparms.dat";
                server.uploadFile(serverPath, parmsPath);
            }
            catch (Exception xcp) {
                System.out.println(xcp);
                try {
                    outs.close();
                    ins.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                server.disconnect();
            }
        }
        finally {
            try {
                outs.close();
                ins.close();
            }
            catch (Exception exception) {}
            server.disconnect();
        }
    }

    public ApacheFtpServer() {
        this(new MLogger.System());
    }

    public ApacheFtpServer(MLogging logger) {
        this(FtpServer.Parms.stuParms(), logger);
        this.setLogger(logger);
    }

    public ApacheFtpServer(FtpServer.Parms parms, MLogging logger) {
        this.setParms(parms);
        this.setLogger(logger);
    }

    public ApacheFtpServer(String ftpParmsUrl) throws Exception {
        URL url = new URL(ftpParmsUrl);
        URLConnection conn = url.openConnection();
        ObjectInputStream in = new ObjectInputStream(conn.getInputStream());
        this.setParms((FtpServer.Parms)in.readObject());
        in.close();
    }

    @Override
    public void connect() throws Exception {
        if (this.iClient == null) {
            this.iClient = new FTPSClient(false);
            this.iClient.setTrustManager(TrustManagerUtils.getValidateServerCertificateTrustManager());
            this.iClient.setTrustManager(TrustManagerUtils.getAcceptAllTrustManager());
            this.iClient.configure(new FTPClientConfig());
            this.iClient.setDataTimeout(10000);
        }
        if (!this.isConnected()) {
            Connector connector = new Connector();
            connector.start();
            int delay = 2000;
            int accumDelay = 0;
            while (!this.isConnected() && accumDelay < 10000) {
                Thread.sleep(delay);
                accumDelay += delay;
            }
            if (this.isConnected()) {
                String hostName = this.parms().hostName();
                this.logger().writeln("FTP: connected to " + hostName, false);
            } else {
                String msg = "Unable to connect to server: " + this.iConnectMsg;
                Utility.throwError(msg);
            }
        }
    }

    @Override
    public Object readObj(String serverPath, boolean gzip) throws Exception {
        this.logger().write("FTP: reading object: " + serverPath + "...", false);
        this.connect();
        Object obj = null;
        ByteArrayOutputStream in = null;
        try {
            try {
                in = new ByteArrayOutputStream();
                this.iClient.retrieveFile(serverPath, in);
                byte[] bytes = in.toByteArray();
                if (bytes.length > 0) {
                    ByteArrayInputStream out = new ByteArrayInputStream(bytes);
                    ObjectInputStream objIn = null;
                    if (gzip) {
                        GZIPInputStream zipin = new GZIPInputStream(out);
                        objIn = new ObjectInputStream(zipin);
                    } else {
                        objIn = new ObjectInputStream(out);
                    }
                    obj = objIn.readObject();
                    objIn.close();
                    this.logger().writeln("FTP: OK", false);
                } else {
                    this.logger().writeln("", false);
                    Utility.throwError("FTP: unable to read file: " + serverPath);
                }
            }
            catch (Exception xcp) {
                this.logger().writeln("", false);
                throw xcp;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            this.cleanup();
        }
        return obj;
    }

    @Override
    public Object readGzipObjHttp(String serverPath) throws Exception {
        this.logger().write("FTP: reading HTTP object: " + serverPath + "...", false);
        MString hostName = new MString(this.parms().hostName());
        hostName.replace("ftp", "www");
        String urlStr = "http://" + hostName + "/" + serverPath;
        URL url = new URL(urlStr);
        URLConnection conn = url.openConnection();
        Object obj = null;
        try (ObjectInputStream in = null;){
            try {
                in = new ObjectInputStream(new GZIPInputStream(conn.getInputStream()));
                obj = in.readObject();
                this.logger().writeln("OK", false);
            }
            catch (Exception xcp) {
                this.logger().writeln("", false);
                throw xcp;
            }
        }
        return obj;
    }

    public void uploadObjDirect(String serverPath, Object obj) throws Exception {
        this.logger().write("FTP: uploading object: " + obj.getClass().getName() + "...", false);
        ObjectOutputStream objOut = null;
        ByteArrayInputStream inStream = null;
        try {
            try {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                objOut = new ObjectOutputStream(byteOut);
                objOut.writeObject(obj);
                inStream = new ByteArrayInputStream(byteOut.toByteArray());
                this.iClient.storeFile(serverPath, inStream);
                this.logger().writeln("OK", false);
            }
            catch (Exception xcp) {
                this.logger().writeln("", false);
                throw xcp;
            }
        }
        finally {
            if (objOut != null) {
                objOut.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            this.cleanup();
        }
    }

    @Override
    public void uploadObj(String serverPath, Object obj, boolean gzip) throws Exception {
        String localPath = String.valueOf(Utility.tmpDir()) + "ftptemp.dat";
        ObjectOutputStream objOut = null;
        try {
            FileOutputStream out = new FileOutputStream(localPath);
            if (gzip) {
                GZIPOutputStream zipOut = new GZIPOutputStream(out);
                objOut = new ObjectOutputStream(zipOut);
            } else {
                objOut = new ObjectOutputStream(out);
            }
            objOut.writeObject(obj);
            objOut.close();
            this.uploadFile(serverPath, localPath);
        }
        finally {
            File file = new File(localPath);
            file.delete();
            if (objOut != null) {
                objOut.close();
            }
        }
    }

    @Override
    public void downloadFile(String serverPath, String localPath) throws Exception {
        this.logger().write("FTP: downloading file: " + serverPath + "...", false);
        this.connect();
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(localPath);
                this.iClient.retrieveFile(serverPath, out);
                this.logger().writeln("OK", false);
            }
            catch (Exception xcp) {
                this.logger().writeln("", false);
                throw xcp;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            this.cleanup();
        }
    }

    @Override
    public int downloadFolder(String serverDirPath, String localDirPath) throws Exception {
        FTPFile[] ftpFiles;
        this.logger().write("FTP: downloading folder: " + serverDirPath + "...", false);
        int holdCount = this.holdCount();
        this.connect();
        this.setHoldCount(FtpServer.defaultHoldCount());
        FTPFile[] fTPFileArray = ftpFiles = this.iCache.addHostDir(serverDirPath);
        int n = ftpFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile file = fTPFileArray[n2];
            if (!file.getName().equals(".") && !file.getName().equals("..")) {
                String serverPath = String.valueOf(serverDirPath) + '/' + file.getName();
                String localPath = String.valueOf(localDirPath) + File.separator + file.getName();
                localPath = localPath.replace('/', File.separatorChar);
                this.downloadFile(serverPath, localPath);
            }
            ++n2;
        }
        this.setHoldCount(holdCount);
        this.cleanup();
        return ftpFiles.length;
    }

    @Override
    public void uploadFile(String serverPath, String localPath) throws Exception {
        this.logger().write("FTP: uploading file: " + serverPath + "...", false);
        this.connect();
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(localPath);
                this.iClient.storeFile(serverPath, in);
                in.close();
                this.logger().writeln("OK", false);
            }
            catch (Exception xcp) {
                this.logger().writeln("", false);
                throw xcp;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            this.cleanup();
        }
    }

    @Override
    public int uploadFolder(String serverDirPath, String localDirPath) throws Exception {
        File[] files;
        int holdCount = this.holdCount();
        this.connect();
        this.setHoldCount(FtpServer.defaultHoldCount());
        File localDir = new File(localDirPath);
        File[] fileArray = files = localDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().equals(".") && !file.getName().equals("..")) {
                String serverPath = String.valueOf(serverDirPath) + '/' + file.getName();
                this.uploadFile(serverPath, file.getAbsolutePath());
            }
            ++n2;
        }
        this.setHoldCount(holdCount);
        this.cleanup();
        return files.length;
    }

    @Override
    public void renameFile(String pathFrom, String pathTo) throws Exception {
        this.connect();
        this.iClient.rename(pathFrom, pathTo);
    }

    @Override
    public void deleteFile(String serverPath) throws Exception {
        this.logger().write("FTP: deleting file: " + serverPath + "...", false);
        this.connect();
        try {
            this.iClient.deleteFile(serverPath);
            this.logger().writeln("OK", false);
        }
        catch (Exception xcp) {
            this.logger().writeln("", false);
            throw xcp;
        }
    }

    @Override
    public void deleteFolder(String serverPath) throws Exception {
        this.logger().write("FTP: deleting folder: " + serverPath + "...", false);
        this.connect();
        try {
            FTPFile[] serverFiles;
            FTPFile[] fTPFileArray = serverFiles = this.iCache.addHostDir(serverPath);
            int n = serverFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile file = fTPFileArray[n2];
                if (!file.getName().equals(".") && !file.getName().equals("..")) {
                    String path = String.valueOf(serverPath) + '/' + file.getName();
                    this.deleteFile(path);
                }
                ++n2;
            }
            this.logger().writeln("OK", false);
            this.iClient.removeDirectory(serverPath);
        }
        catch (Exception xcp) {
            this.logger().writeln("", false);
            throw xcp;
        }
    }

    @Override
    public FileInfo.Apache fileExists(String serverPath) throws Exception {
        String path = serverPath;
        int index = serverPath.lastIndexOf(47);
        if (index >= 0) {
            path = serverPath.substring(0, index);
        }
        this.iCache.addHostDir(path);
        FileInfo.Apache theFile = this.iCache.file(serverPath);
        return theFile;
    }

    @Override
    public void mkdir(String path) throws Exception {
        StringTokenizer tken = new StringTokenizer(path, "/");
        this.connect();
        String curPath = "";
        while (tken.hasMoreTokens()) {
            curPath = String.valueOf(curPath) + tken.nextToken();
            this.getClient().makeDirectory(curPath);
            curPath = String.valueOf(curPath) + "/";
        }
        this.cleanup();
    }

    @Override
    public long fileSize(String serverPath) throws Exception {
        long size = -1L;
        FileInfo.Apache file = this.fileExists(serverPath);
        if (file != null) {
            size = file.size();
        } else {
            Utility.throwError("file not found: " + serverPath);
        }
        return size;
    }

    @Override
    public LinkedList<FileInfo> files(Filesystem.ApacheFtp fs, String serverPath, LinkedList<MWildcard> includes) throws Exception {
        this.logger().write("FTP: listing " + serverPath + "...", false);
        LinkedList<FileInfo> files = new LinkedList<FileInfo>();
        try {
            try {
                FTPFile[] serverFiles;
                FTPFile[] fTPFileArray = serverFiles = this.iCache.addHostDir(serverPath);
                int n = serverFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    FTPFile file = fTPFileArray[n2];
                    boolean matches = false;
                    Iterator iter = includes.iterator();
                    while (!matches && iter.hasNext()) {
                        MWildcard wc = (MWildcard)iter.next();
                        matches = wc.matches(file.getName());
                        if (!matches) continue;
                        FileInfo.Apache aFile = new FileInfo.Apache(fs, file, serverPath);
                        files.add(aFile);
                    }
                    ++n2;
                }
                this.logger().writeln("OK", false);
            }
            catch (Exception xcp) {
                this.logger().writeln("", false);
                throw xcp;
            }
        }
        finally {
            this.cleanup();
        }
        return files;
    }

    public FTPClient getClient() throws Exception {
        if (this.iClient == null) {
            this.iClient = new FTPSClient();
        }
        return this.iClient;
    }

    @Override
    public void disconnect() {
        try {
            if (this.iClient != null && this.isConnected()) {
                this.logger().write("FTP: disconnecting...", false);
                this.setConnected(false);
                this.iClient.logout();
                this.iClient.disconnect();
                this.logger().writeln("OK", false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearCache() {
        this.iCache.clear();
    }

    private void cleanup() throws Exception {
        if (this.holdCount() == 0) {
            this.disconnect();
        } else {
            boolean ok = this.incTransferCount(1);
            if (!ok) {
                this.logger().writeln("FTP: hold count exceeded, reset", false);
                this.resetTransferCount();
                this.disconnect();
                this.connect();
            }
        }
    }

    private class Connector
    extends Thread {
        private Connector() {
        }

        @Override
        public void run() {
            ApacheFtpServer.this.iConnectMsg = null;
            String hostName = ApacheFtpServer.this.parms().hostName();
            try {
                ApacheFtpServer.this.logger().writeln("FTP: connecting to " + hostName + ":" + "...", false);
                ApacheFtpServer.this.iClient.connect(hostName);
                int reply = ApacheFtpServer.this.iClient.getReplyCode();
                if (FTPReply.isPositiveCompletion(reply)) {
                    ApacheFtpServer.this.iClient.enterLocalPassiveMode();
                    ApacheFtpServer.this.iClient.setFileType(2);
                    ApacheFtpServer.this.logger().write("FTP: logging in: " + ApacheFtpServer.this.parms().userName() + "...", false);
                    if (!ApacheFtpServer.this.iClient.login(ApacheFtpServer.this.parms().userName(), ApacheFtpServer.this.parms().password())) {
                        ApacheFtpServer.this.iConnectMsg = "login failed";
                        ApacheFtpServer.this.logger().writeln("", false);
                        ApacheFtpServer.this.disconnect();
                    } else {
                        ApacheFtpServer.this.logger().writeln("OK", false);
                        ApacheFtpServer.this.setConnected(true);
                    }
                } else {
                    ApacheFtpServer.this.iConnectMsg = "no server reply";
                }
            }
            catch (Exception xcp) {
                ApacheFtpServer.this.disconnect();
                ApacheFtpServer.this.logger().writeln(ApacheFtpServer.MSGPREFIX + Utility.xcpMsg(xcp), true);
            }
        }
    }

    private class HostDirListings {
        private TreeMap<String, FTPFile[]> iMap = new TreeMap();

        private HostDirListings() {
        }

        public FTPFile[] addHostDir(String serverPath) throws Exception {
            FTPFile[] files = new FTPFile[]{};
            files = this.iMap.get(serverPath);
            if (files == null) {
                ApacheFtpServer.this.connect();
                files = ApacheFtpServer.this.iClient.listFiles(serverPath);
                this.iMap.put(serverPath, files);
            }
            return files;
        }

        public FileInfo.Apache file(String serverPath) {
            FTPFile[] files;
            FileInfo.Apache result = null;
            String path = serverPath;
            int index = serverPath.lastIndexOf(47);
            if (index >= 0) {
                path = serverPath.substring(0, index);
            }
            if ((files = this.iMap.get(path)) != null) {
                index = serverPath.lastIndexOf("/");
                String name = serverPath.substring(index + 1);
                FTPFile theFile = null;
                int i = 0;
                while (theFile == null && i < files.length) {
                    if (files[i].getName().equals(name)) {
                        theFile = files[i];
                    }
                    ++i;
                }
                if (theFile != null) {
                    result = new FileInfo.Apache(null, theFile, serverPath);
                }
            }
            return result;
        }

        public void clear() {
            this.iMap.clear();
        }
    }
}

