/*
 * Decompiled with CFR 0.152.
 */
package filedialog;

import filedialog.FileChooser;
import filedialog.FileChooserFilter;
import filedialog.FilePopupObject;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import popup.PopupItem;
import popup.PopupPanel;
import swing.StatusBox;
import swing.SwingProgram;
import utilt.Utility;

class FilePanel
extends PopupPanel {
    private FileChooser iChooser = null;
    private LinkedList<FilePopupObject> iItems = null;
    private int iPercent = 0;
    private FileChooserFilter iFilter = null;
    private boolean iContinue = false;
    private static ThumbsDisplay dispThread = null;
    private static Collection<String> DriveNames = null;

    public FilePanel(FileChooser chooser, FileChooserFilter filter) {
        this.iChooser = chooser;
        this.iFilter = filter;
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        this.setHgap((int)((double)screen.width / 100.0));
        this.setVgap((int)((double)screen.width / 100.0));
        this.addListener(new SelectionListener());
        this.setBorder(SwingProgram.STDBORDER);
    }

    public FileChooser getFileChooser() {
        return this.iChooser;
    }

    @Override
    public void handleMenu(String menuCmd) {
    }

    @Override
    public JPopupMenu panelMenu() {
        return null;
    }

    void showDir(String dirPath) {
        this.iContinue = false;
        this.iChooser.enableAcceptButton(false);
        this.iChooser.enableSelectAllButton(false);
        this.iChooser.enableUpButton(!this.iChooser.atTop(dirPath));
        this.iChooser.setCurDir(dirPath);
        if (dirPath.equals("System drives")) {
            this.showDrives();
            this.iChooser.enableThumbButton(false);
        } else {
            this.clearSelectedItems();
            this.iItems = this.popupItems(dirPath);
            int count = this.showCount(dirPath);
            this.removeAll();
            if (this.iChooser.isShowThumbs() && count > 0) {
                this.iContinue = true;
                this.iChooser.enableButtons(false);
                dispThread = new ThumbsDisplay();
                dispThread.start();
            } else {
                this.showPopupItems();
            }
            boolean enableThumb = count > 0;
            this.iChooser.enableThumbButton(enableThumb);
            if (count > 0) {
                this.iChooser.enableSelectAllButton(true);
            }
        }
    }

    private LinkedList<File> selectableFiles(String dirPath) {
        if (!dirPath.endsWith(File.separator)) {
            dirPath = String.valueOf(dirPath) + File.separator;
        }
        LinkedList<File> files = new LinkedList<File>();
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            files.add(dir);
        } else {
            File[] list = dir.listFiles();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    if (this.iFilter.accept(list[i])) {
                        files.add(list[i]);
                    }
                    ++i;
                }
            }
        }
        return files;
    }

    private LinkedList<FilePopupObject> popupItems(String dirPath) {
        LinkedList<File> files = this.selectableFiles(dirPath);
        LinkedList<FilePopupObject> items = new LinkedList<FilePopupObject>();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            boolean add = true;
            File file = (File)iter.next();
            int type = 0;
            if (!file.isDirectory()) {
                type = 1;
                boolean bl = add = !this.iFilter.ignore(file);
            }
            if (!add) continue;
            FilePopupObject obj = new FilePopupObject(this, type);
            obj.setName(file.getAbsolutePath());
            obj.setUseThumbnail(this.iChooser.isShowThumbs());
            items.add(obj);
        }
        return items;
    }

    private int showCount(String dirPath) {
        int count = this.countMatches(dirPath);
        if (this.iFilter.getDesc() == null) {
            this.iChooser.emptyMsg();
        } else if (this.iFilter.getDesc().equals("SelectDir")) {
            this.iChooser.putMsg(dirPath, null);
        } else {
            this.iChooser.putMsg(dirPath, String.valueOf(count) + " " + this.iFilter.getDesc());
        }
        return count;
    }

    private int countMatches(String dirPath) {
        int count = 0;
        File dir = new File(dirPath);
        File[] list = dir.listFiles();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                boolean include;
                boolean bl = include = this.iFilter.accept(list[i]) && this.iFilter.matchesExts(list[i]) && !this.iFilter.ignore(list[i]);
                if (include) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    void stopShow() {
        this.iContinue = false;
    }

    void showDrives() {
        this.clearSelectedItems();
        this.removeAll();
        DriveNames = Utility.dosDrives();
        for (String drive : DriveNames) {
            FilePopupObject obj = new FilePopupObject(this, 2);
            obj.setName(drive);
            this.add(obj, false, false);
        }
        this.iChooser.putMsg("System drives", "");
        this.showItems();
    }

    private void showPopupItems() {
        for (FilePopupObject popup : this.iItems) {
            boolean selectable = false;
            if (popup.getType() == 1) {
                selectable = true;
            } else if (popup.getType() == 0 && this.iFilter.isAcceptDirs()) {
                selectable = true;
            }
            this.add(popup, selectable, popup.getType() != 0);
        }
        this.showItems();
    }

    @Override
    public synchronized void selectAll() {
        this.clearSelectedItems();
        for (FilePopupObject obj : this.iItems) {
            File file = new File(obj.getName());
            if (!this.iFilter.matchesExts(file)) continue;
            this.addSelection(obj);
        }
        this.iChooser.enableAcceptButton(true);
    }

    private class SelectionListener
    implements PopupPanel.Listener {
        private SelectionListener() {
        }

        @Override
        public void selected(PopupPanel.Event event) {
            PopupItem item = event.getSelection();
            FilePopupObject popup = (FilePopupObject)item.getPopupObject();
            if (FilePanel.this.iChooser.hasStatusBox()) {
                StatusBox.singleton().showMsg("Selected: " + popup.getName(), false);
            }
            if (popup.getType() == 0 || popup.getType() == 2) {
                FilePanel.this.showCount(popup.getName());
            }
            if (item.isSelectable()) {
                if (popup.getType() == 1) {
                    FilePanel.this.iChooser.enableAcceptButton(true);
                } else if (popup.getType() == 0 && FilePanel.this.iChooser.canSelectDir()) {
                    FilePanel.this.iChooser.enableAcceptButton(true);
                }
            }
        }
    }

    private class ShowThumb
    extends Thread {
        private ShowThumb() {
        }

        @Override
        public void run() {
            FilePanel.this.showItems();
        }
    }

    private class ThumbsDisplay
    extends Thread {
        private ThumbsDisplay() {
        }

        @Override
        public void run() {
            try {
                int numFiles = FilePanel.this.iItems.size();
                int fileNum = 0;
                Iterator iter = FilePanel.this.iItems.iterator();
                while (iter.hasNext() && FilePanel.this.iContinue && !Thread.interrupted()) {
                    FilePopupObject obj;
                    ++fileNum;
                    FilePanel.this.add(obj, (obj = (FilePopupObject)iter.next()).getType() == 1, obj.getType() != 0);
                    if (!FilePanel.this.iContinue) continue;
                    FilePanel.this.iPercent = (int)(100.0 * (double)fileNum / (double)numFiles + 0.5);
                    ShowThumb update = new ShowThumb();
                    EventQueue.invokeAndWait(update);
                }
                if (FilePanel.this.iPercent < 100) {
                    FilePanel.this.iPercent = 100;
                    ShowThumb update = new ShowThumb();
                    EventQueue.invokeAndWait(update);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            FilePanel.this.iChooser.enableButtons(true);
        }
    }
}

