/*
 * Decompiled with CFR 0.152.
 */
package filedialog;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import filedialog.FileChooserFilter;
import filedialog.FilePanel;
import filedialog.FilePopupObject;
import filedialog.NewFolderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import mswing.Preferences;
import popup.PopupObject;
import swing.ColorPanel;
import swing.ControlButton;
import swing.PanelLabel;
import swing.StatusBox;
import utilt.GifIconMgr;
import utilt.ImageIOUtil;
import utilt.Utility;

public class FileChooser
extends CenteredDialog {
    private JPanel iButtonPanel = null;
    private ControlButton iUpButton = null;
    private ControlButton iThumbButton = null;
    private ControlButton iNewFolderButton = null;
    private PanelLabel iMsgLabel = new PanelLabel("");
    private FilePanel iFilePanel = null;
    private LinkedList<Listener> iLis = new LinkedList();
    private Preferences iPref = null;
    private NewFolderPanel iNewFolderPanel = null;
    private boolean iShowThumbs = false;
    private boolean iCanSelectDir = true;
    private boolean iShowSelectAll = true;
    private boolean iDisposeOnAccept = true;
    private boolean iHasStatusBox = false;
    private int iThumbSize = 64;
    private Dimension iCurSize = null;
    private String iCurDir = null;
    public static final String DOSDRIVES = "System drives";
    public static final String DIRFILTERDESC = "SelectDir";
    private static ImageIcon DirIcon = null;
    private static ImageIcon FileIcon = null;
    private static ImageIcon DriveIcon = null;
    private static ImageIcon UpButtonIcon = null;
    private static ImageIcon ThumbOnButtonIcon = null;
    private static ImageIcon ThumbOffButtonIcon = null;
    private static ImageIcon NewFolderIcon = null;

    static {
        GifIconMgr mgr = new GifIconMgr(FileChooser.class, "");
        UpButtonIcon = mgr.icon("up");
        ThumbOnButtonIcon = mgr.icon("thumbson");
        ThumbOffButtonIcon = mgr.icon("thumbsoff");
        DirIcon = mgr.icon("folder");
        FileIcon = mgr.icon("file");
        DriveIcon = mgr.icon("drive");
        NewFolderIcon = mgr.icon("plus");
    }

    public static ImageIcon dirIcon() {
        return DirIcon;
    }

    public static ImageIcon driveIcon() {
        return DriveIcon;
    }

    public static ImageIcon fileIcon() {
        return FileIcon;
    }

    public static BufferedImage loadImage(String path) {
        BufferedImage image = null;
        try {
            image = ImageIOUtil.load(path);
        }
        catch (Exception xcp) {
            image = null;
        }
        return image;
    }

    public FileChooser(Preferences pref, FileChooserFilter fileFilter, boolean enableThumbs, boolean enableNewFolder, boolean enableSelectAll, Frame owner, String title, boolean modal, boolean addStatusBox) {
        super(owner, title, modal);
        this.initialize(pref, fileFilter, enableThumbs, enableNewFolder, enableSelectAll, addStatusBox);
    }

    public FileChooser(Preferences pref, FileChooserFilter fileFilter, boolean enableThumbs, boolean enableNewFolder, boolean enableSelectAll, Frame owner, boolean modal) {
        super(owner, modal);
        this.setModal(modal);
        this.initialize(pref, fileFilter, enableThumbs, enableNewFolder, enableSelectAll, false);
    }

    public String curDir() {
        return this.iCurDir;
    }

    public void setCurDir(String curDir) {
        this.iCurDir = curDir;
    }

    public int thumbSize() {
        return this.iThumbSize;
    }

    public void setThumbSize(int size) {
        this.iThumbSize = size;
    }

    public void setDisposeOnAccept(boolean dispose) {
        this.iDisposeOnAccept = dispose;
    }

    @Override
    public void accept(DialogEvent event) {
        LinkedList<FilePopupObject> selections = new LinkedList<FilePopupObject>();
        for (PopupObject obj : this.iFilePanel.selections()) {
            selections.add((FilePopupObject)obj);
        }
        if (this.iDisposeOnAccept) {
            this.dispose();
        }
        this.fireSelection(selections);
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public synchronized void removeListener(Listener lis) {
        this.iLis.remove(lis);
    }

    @Override
    public void cancel(DialogEvent event) {
        this.dispose();
        this.fireSelection(new LinkedList<FilePopupObject>());
    }

    @Override
    public void enableButtons(boolean enable) {
        super.enableButtons(enable);
        this.enableUpButton(enable);
        this.enableThumbButton(enable);
    }

    public void enableUpButton(boolean enable) {
        if (this.iUpButton != null) {
            this.iUpButton.setEnabled(enable);
        }
    }

    public void enableFolderButton(boolean enable) {
        if (this.iNewFolderButton != null) {
            this.iNewFolderButton.setEnabled(enable);
        }
    }

    public void enableThumbButton(boolean enable) {
        if (this.iThumbButton != null) {
            this.iThumbButton.setEnabled(enable);
        }
    }

    public void enableSelectAllButton(boolean enable) {
        if (this.iShowSelectAll) {
            this.enableCustomButton(0, enable);
        }
    }

    public boolean atTop(String dirPath) {
        return dirPath.equals(DOSDRIVES) || dirPath.equals(File.separator);
    }

    public boolean createFolder(String name) {
        File dir;
        boolean result = false;
        if (name.length() > 0 && !(dir = new File(String.valueOf(this.iCurDir) + File.separatorChar + name)).exists()) {
            dir.mkdir();
            this.iFilePanel.showDir(this.iCurDir);
            result = true;
        }
        return result;
    }

    public void sendMsg(String msg) {
        Event event = new Event(this, this.iCurDir, null);
        event.setMsg(msg);
        for (Listener lis : this.iLis) {
            lis.message(event);
        }
    }

    public boolean isShowThumbs() {
        return this.iShowThumbs;
    }

    public boolean hasStatusBox() {
        return this.iHasStatusBox;
    }

    void putMsg(String dirPath, String msg) {
        String message = null;
        if (dirPath.equals(DOSDRIVES)) {
            message = dirPath;
        } else {
            message = dirPath;
            if (msg != null) {
                message = String.valueOf(message) + " has " + msg;
            }
        }
        this.iMsgLabel.setText(" " + message);
    }

    public void emptyMsg() {
        this.iMsgLabel.setBackground(this.iPref.headerBackColor());
        this.iMsgLabel.setForeground(SystemColor.controlText);
        this.iMsgLabel.setText("");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.iMsgLabel.setFont(font);
        this.iFilePanel.setMenuFont(font);
        this.iFilePanel.setLabelFont(font);
    }

    public void removeNewFolder() {
        this.iButtonPanel.remove(this.iNewFolderPanel);
        this.iButtonPanel.add(this.iMsgLabel);
        this.validate();
        this.repaint();
    }

    @Override
    public void custom(int index, DialogEvent event) {
        this.iFilePanel.selectAll();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.iFilePanel.showDir(this.iCurDir);
            if (this.iCurSize != null) {
                Toolkit tKit = Toolkit.getDefaultToolkit();
                Dimension screen = tKit.getScreenSize();
                double horzFrac = (double)this.iCurSize.width / (double)screen.width;
                double vertFrac = (double)this.iCurSize.height / (double)screen.height;
                this.center(horzFrac, vertFrac);
            }
        }
        super.setVisible(visible);
    }

    public void setMultipleSelect(boolean multiple) {
        this.iFilePanel.setMultipleSelect(multiple);
    }

    public boolean canSelectDir() {
        return this.iCanSelectDir;
    }

    public void setCanSelectDir(boolean can) {
        this.iCanSelectDir = can;
    }

    private void initialize(Preferences pref, FileChooserFilter fileFilter, boolean enableThumbs, boolean enableNewFolder, boolean enableSelectAll, boolean addStatusBox) {
        if (this.iCurDir == null) {
            this.iCurDir = Utility.isUnixFilesystem() ? "/" : DOSDRIVES;
        }
        this.iPref = pref;
        this.iFilePanel = new FilePanel(this, fileFilter);
        this.iButtonPanel = new ButtonPanel(enableThumbs, enableNewFolder);
        ColorPanel panel = new ColorPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.iButtonPanel, "North");
        panel.add((Component)this.iFilePanel, "Center");
        this.iHasStatusBox = addStatusBox;
        if (addStatusBox) {
            panel.add((Component)StatusBox.singleton(), "South");
        }
        this.getContentPane().add((Component)panel, "Center");
        this.addWindowListener(new WindowHandler());
        this.iFilePanel.setMultipleSelect(true);
        this.setFont(Utility.stdFont());
        this.iShowSelectAll = enableSelectAll;
        if (enableSelectAll) {
            this.addCustomButton("Select all", 's', null, "Select all");
        }
    }

    private void fireSelection(LinkedList<FilePopupObject> selections) {
        Event event = new Event(this, this.iCurDir, selections);
        for (Listener lis : this.iLis) {
            lis.selected(event);
        }
    }

    private class ButtonPanel
    extends ColorPanel {
        ButtonPanel(boolean enableThumbs, boolean enableNewFolder) {
            this.setLayout(new BoxLayout(this, 0));
            this.setBackground(FileChooser.this.iPref.headerBackColor());
            FileChooser.this.emptyMsg();
            FileChooser.this.iUpButton = new ControlButton("Go to parent", UpButtonIcon, 'p');
            FileChooser.this.iUpButton.addActionListener(new UpHandler());
            this.add(FileChooser.this.iUpButton);
            if (enableThumbs) {
                FileChooser.this.iThumbButton = new ControlButton("Show thumbnails", ThumbOffButtonIcon, 't');
                FileChooser.this.iThumbButton.addActionListener(new ThumbHandler());
                this.add(FileChooser.this.iThumbButton);
            }
            if (enableNewFolder) {
                FileChooser.this.iNewFolderButton = new ControlButton("Create folder", NewFolderIcon, 'f');
                FileChooser.this.iNewFolderButton.addActionListener(new NewFolderClickHandler());
                this.add(FileChooser.this.iNewFolderButton);
                FileChooser.this.iNewFolderPanel = new NewFolderPanel(FileChooser.this);
            }
            this.add(FileChooser.this.iMsgLabel);
        }

        @Override
        public boolean isFocusable() {
            return true;
        }
    }

    public static class Event
    extends EventObject {
        private LinkedList<FilePopupObject> iSelections = null;
        private String iCurDir = null;
        private String iMsg = null;

        public Event(Object source, String curDir, LinkedList<FilePopupObject> selections) {
            super(source);
            this.iSelections = selections;
            this.iCurDir = curDir;
        }

        public LinkedList<FilePopupObject> selections() {
            return this.iSelections;
        }

        public String curDir() {
            return this.iCurDir;
        }

        public String msg() {
            return this.iMsg;
        }

        public void setMsg(String msg) {
            this.iMsg = msg;
        }
    }

    public static interface Listener
    extends EventListener {
        public void selected(Event var1);

        public void message(Event var1);
    }

    private class NewFolderClickHandler
    implements ActionListener {
        private NewFolderClickHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FileChooser.this.iButtonPanel.remove(FileChooser.this.iMsgLabel);
            FileChooser.this.iButtonPanel.add(FileChooser.this.iNewFolderPanel);
            FileChooser.this.iButtonPanel.validate();
            FileChooser.this.iButtonPanel.repaint();
            FileChooser.this.iNewFolderPanel.setEnabled(true);
            FileChooser.this.iNewFolderPanel.putFocus();
            FileChooser.this.iNewFolderButton.setEnabled(false);
        }
    }

    private class ThumbHandler
    implements ActionListener {
        private ThumbHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FileChooser.this.iShowThumbs = !FileChooser.this.iShowThumbs;
            if (FileChooser.this.iShowThumbs) {
                FileChooser.this.iThumbButton.setIcon(ThumbOnButtonIcon);
            } else {
                FileChooser.this.iThumbButton.setIcon(ThumbOffButtonIcon);
            }
            FileChooser.this.iFilePanel.showDir(FileChooser.this.iCurDir);
        }
    }

    private class UpHandler
    implements ActionListener {
        private UpHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FileChooser.this.emptyMsg();
            if (Utility.isUnixFilesystem()) {
                this.upUnix();
            } else {
                this.upDOS();
            }
        }

        void upDOS() {
            int lastDelim = FileChooser.this.iCurDir.lastIndexOf(File.separatorChar);
            if (lastDelim >= 0) {
                String parentName = FileChooser.this.iCurDir.substring(lastDelim + 1);
                if (parentName.length() > 0) {
                    String parent = FileChooser.this.iCurDir.substring(0, lastDelim);
                    if (parent.endsWith(":")) {
                        parent = String.valueOf(parent) + File.separatorChar;
                    }
                    FileChooser.this.iFilePanel.showDir(parent);
                } else {
                    FileChooser.this.iFilePanel.showDir(FileChooser.DOSDRIVES);
                }
            }
        }

        void upUnix() {
            int lastDelim = FileChooser.this.iCurDir.lastIndexOf(File.separatorChar);
            if (lastDelim > 0) {
                FileChooser.this.iCurDir = FileChooser.this.iCurDir.substring(0, lastDelim);
            } else if (lastDelim == 0) {
                if (Utility.isUnixFilesystem()) {
                    FileChooser.this.iCurDir = "/";
                } else {
                    FileChooser.this.iCurDir = FileChooser.DOSDRIVES;
                }
            }
            FileChooser.this.iFilePanel.showDir(FileChooser.this.iCurDir);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent event) {
            FileChooser.this.iFilePanel.stopShow();
            FileChooser.this.iCurSize = FileChooser.this.getSize();
            FileChooser.this.fireSelection(new LinkedList());
        }

        @Override
        public void windowOpened(WindowEvent event) {
            FileChooser.this.iButtonPanel.requestFocus();
        }
    }
}

