/*
 * Decompiled with CFR 0.152.
 */
package cmdproc;

import clp.ClpCmd;
import cmdproc.BpmClp;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import files.FileInfo;
import files.Filesystem;
import files.FilesystemCopier;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JProgressBar;
import mlib.MAppMsg;
import mlib.MEncStr;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MReport;
import mlib.MString;
import mlib.MWildcard;
import mswing.ThumbnailImage;
import mswing.WheelComboBoxDb;
import oroma.db.BpmExifTag;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgInstallation;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.db.Website;
import oroma.gui.BpmMsgs;
import oroma.website.WebMgr;
import unoofc.ODrawArea;
import unoofc.ODrawDoc;
import unoofc.OFileFilter;
import unoofc.OImpressDoc;
import unoofc.ORootDoc;
import unoofc.OShape;
import unoofc.OUtil;
import utilt.BinnedDb;
import utilt.DoneCounter;
import utilt.ImageIOUtil;
import utilt.Utility;

public class OtherCmds {
    private static final int INTERVAL = 100;

    private OtherCmds() {
    }

    public static class BuildComboDbsCmd
    extends ClpCmd {
        private static void doPicInfos(Database db, MLogging logger) throws Exception {
            Collection<PicInfo> picInfos = db.picInfosByPathname().values();
            String[] stringArray = PicInfo.COMBOBOXFLDS;
            int n = PicInfo.COMBOBOXFLDS.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                WheelComboBoxDb boxDb = db.comboDb(name);
                boxDb.clear(null);
                for (PicInfo picInfo : picInfos) {
                    PicInfo.ComboField field = picInfo.comboField(name);
                    boxDb.addItem(field.value().toString(), null);
                }
                boxDb.save();
                MAppMsg msg = BpmMsgs.get("database");
                logger.writeln(msg.format(boxDb.toString()));
                ++n2;
            }
        }

        private static void doCategories(Database db, MLogging logger) throws Exception {
            WheelComboBoxDb comboDb = db.comboDb("category");
            comboDb.clear(null);
            Collection<BinnedDb.Binnable> albums = db.albumsDb().retrieveAll();
            for (BinnedDb.Binnable binnable : albums) {
                Query album = (Query)binnable;
                comboDb.addItem(album.category(), null);
            }
            comboDb.save();
            MAppMsg msg = BpmMsgs.get("database");
            logger.writeln(msg.format(comboDb.toString()));
        }

        public BuildComboDbsCmd() throws Exception {
            super("Build ComboDbs from PicInfos");
            this.add(new ClpCmd.Arg("build", false));
            this.add(new ClpCmd.Arg("combodbs", false));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MLogging logger = this.clp().logger();
            Database db = Database.singleton();
            MAppMsg msg = BpmMsgs.get("database");
            logger.writeln(msg.format(db.toString()));
            Database database = db;
            synchronized (database) {
                BuildComboDbsCmd.doPicInfos(db, logger);
                BuildComboDbsCmd.doCategories(db, logger);
            }
        }
    }

    public static class BuildSlidesCmd
    extends ClpCmd {
        private OImpressDoc iDoc = null;

        public BuildSlidesCmd() throws Exception {
            super("build libreoffice slide presentation from album");
            this.add(new ClpCmd.Arg("build", false));
            this.add(new ClpCmd.Arg("album", false));
            ClpCmd.Arg arg = this.arg("album");
            arg.add(new ClpCmd.Option("*album"));
            this.add(new ClpCmd.Arg("ASSLIDES", false));
            this.add(new ClpCmd.Arg("template", false));
            arg = this.arg("template");
            arg.add(new ClpCmd.Option("*template path"));
            this.add(new ClpCmd.Arg("charsize", false));
            arg = this.arg("charsize");
            arg.add(new ClpCmd.Option("#annotation char height"));
            this.add(new ClpCmd.Arg("annotfields", false));
            arg = this.arg("annotfields");
            arg.add(new ClpCmd.Option("*annot field tags in order"));
            this.add(new ClpCmd.Arg("slidesdir", false));
            arg = this.arg("slidesdir");
            arg.add(new ClpCmd.Option("*slides folder"));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MLogging logger = this.clp().logger();
            String url = OUtil.urlFromPath((String)(String.valueOf(ProgInstallation.singleton().dir()) + "slides-template.otp"));
            this.iDoc = new OImpressDoc(url);
            String slidesDir = this.arg("slidesdir").firstOptionValue();
            if (!slidesDir.endsWith(File.separator)) {
                slidesDir = String.valueOf(slidesDir) + File.separatorChar;
            }
            Database database = Database.singleton();
            synchronized (database) {
                Query query = Database.singleton().query(this.arg("album").firstOptionValue(), true);
                TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(query);
                Integer count = pics.size();
                int num = 0;
                for (PicInfo info : pics) {
                    this.addSlide(num++, info, slidesDir);
                }
                this.iDoc.removeSlide(0);
                String name = this.arg("album").firstOptionValue();
                name = name.replace(' ', '-');
                String path = String.valueOf(slidesDir) + name + OFileFilter.ODP.extension();
                url = OUtil.urlFromPath((String)path);
                this.iDoc.writeOdp(url);
                this.clp().state().putParm("result", count);
                MAppMsg msg = BpmMsgs.get("built_slides");
                String text = msg.format(count.toString());
                logger.writeln(text, false);
            }
        }

        private void addSlide(int number, PicInfo picInfo, String slidesDir) throws Exception {
            String quality = ProgPreferences.singleton().otherJpegQual();
            File file = new File(picInfo.picPathname());
            if (file.exists()) {
                BufferedImage bufImage = ImageIOUtil.load(file.getAbsolutePath());
                int maxSize = ProgPreferences.singleton().extractMaxSize();
                bufImage = ImageIOUtil.resize(bufImage, maxSize);
                String path = String.valueOf(slidesDir) + picInfo.id() + ".jpg";
                ImageIOUtil.writeJpeg(bufImage, path, Integer.parseInt(quality));
                String url = OUtil.urlFromPath((String)path);
                OImpressDoc.Slide slide = this.iDoc.insertSlide(number, OImpressDoc.SlideLayout.BLANK);
                ArrayList masters = this.iDoc.masterSlides();
                OImpressDoc.Slide master = (OImpressDoc.Slide)masters.get(0);
                ODrawArea masterArea = master.area();
                ODrawArea bitmapArea = (ODrawArea)masterArea.clone();
                bitmapArea.reshape(0.95f, 0.9f);
                int yPos = bitmapArea.yPos();
                bitmapArea.changeY(-1 * (2 * yPos / 3));
                ODrawDoc.PageLayer layer = slide.backgroundLayer();
                ODrawDoc.BitmapShape shape = new ODrawDoc.BitmapShape((ORootDoc)this.iDoc, bitmapArea, true, url);
                layer.add((OShape)shape);
                int charSize = Integer.parseInt(this.arg("charsize").firstOptionValue());
                int annotHeight = 2 * charSize;
                Size size = new Size(bitmapArea.width(), 2 * annotHeight);
                Point annotPos = bitmapArea.position();
                annotPos.Y = bitmapArea.yPos() + bitmapArea.height() + size.Height;
                ODrawArea annotArea = new ODrawArea(annotPos, size);
                shape = new ODrawDoc.TextShape((ORootDoc)this.iDoc, annotArea);
                layer.add((OShape)shape);
                shape.setText(picInfo.webLabel(this.arg("annotfields").firstOptionValue(), 999));
            }
        }
    }

    public static class CheckFieldsCmd
    extends ClpCmd {
        private static final String RULESFILE = "rules.txt";
        private static final String TAG = "+rule";
        private static final char TERM = ':';
        private static final char RULE = '>';
        final MAppMsg NoParse = BpmMsgs.get("unable_parse_rule");
        final MAppMsg NoField = BpmMsgs.get("no_field");
        final MAppMsg PhotoPath = BpmMsgs.get("photo_path");
        final MAppMsg Violations = BpmMsgs.get("violations");

        public CheckFieldsCmd() throws Exception {
            super("check PicInfo fields consistency");
            this.add(new ClpCmd.Arg("check", false));
            this.add(new ClpCmd.Arg("field", false));
            this.add(new ClpCmd.Arg("rules", false));
            this.add(new ClpCmd.Arg("save", true));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MLogging logger = this.clp().logger();
            Database db = Database.singleton();
            MAppMsg msg = BpmMsgs.get("database");
            logger.writeln(msg.format(db.toString()));
            Database database = db;
            synchronized (database) {
                int count = 0;
                String dirPath = ProgInstallation.singleton().dir();
                Collection<PicInfo> allPics = db.picInfosByPathname().values();
                for (PicInfo info : allPics) {
                    PicInfo.ComboField identifier = info.comboField("identifier");
                    MString idValue = identifier.mValue();
                    int num = idValue.remove(TAG, 99, 0);
                    if (num <= 0) continue;
                    identifier.setValue(idValue.trimWhitespace().toString());
                }
                LinkedList<String> lines = Utility.readTextFile(String.valueOf(dirPath) + File.separator + RULESFILE);
                for (String line : lines) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("//")) continue;
                    msg = BpmMsgs.get("rule");
                    Rule rule = new Rule(line);
                    logger.writeln(msg.format(rule.toString()));
                    rule.parse();
                    int errors = 0;
                    for (PicInfo info : allPics) {
                        boolean result = rule.check(info);
                        if (result) continue;
                        ++errors;
                    }
                    logger.writeln(this.Violations.format("   " + errors));
                    count += errors;
                }
                logger.writeln(this.Violations.format("   " + count));
                if (this.supplied("save")) {
                    db.save();
                }
            }
        }

        private class Rule {
            private String iLine = null;
            private String iField1Name = null;
            private String iField1Value = null;
            private String iField2Name = null;
            private String iField2Value = null;
            private MWildcard iField2Wc = null;

            Rule(String line) {
                this.iLine = line.toLowerCase();
            }

            void parse() throws Exception {
                int index = this.iLine.indexOf(62);
                if (index <= 0) {
                    Utility.throwError(CheckFieldsCmd.this.NoParse.format(this.iLine));
                } else {
                    String leftSide = this.iLine.substring(0, index).trim();
                    index = this.iLine.indexOf(58);
                    this.iField1Name = leftSide.substring(0, index).trim();
                    if (this.iField1Name.length() == 0) {
                        Utility.throwError(CheckFieldsCmd.this.NoParse.format(this.iLine));
                    } else {
                        int fieldPos = PicInfo.comboFieldPos(this.iField1Name);
                        if (fieldPos < 0) {
                            Utility.throwError(CheckFieldsCmd.this.NoField.format(this.iField1Name));
                        } else {
                            this.iField1Value = leftSide.substring(index + 1);
                            if (this.iField1Value.length() == 0) {
                                Utility.throwError(CheckFieldsCmd.this.NoParse.format(this.iLine));
                            } else {
                                index = this.iLine.indexOf(62);
                                String rightSide = this.iLine.substring(index + 1).trim();
                                index = rightSide.indexOf(58);
                                this.iField2Name = rightSide.substring(0, index).trim();
                                if (this.iField2Name.length() == 0) {
                                    Utility.throwError(CheckFieldsCmd.this.NoParse.format(this.iLine));
                                } else {
                                    fieldPos = PicInfo.comboFieldPos(this.iField2Name);
                                    if (fieldPos < 0) {
                                        Utility.throwError(CheckFieldsCmd.this.NoField.format(this.iField2Name));
                                    } else {
                                        this.iField2Value = rightSide.substring(index + 1);
                                        if (this.iField2Value.length() == 0) {
                                            Utility.throwError(CheckFieldsCmd.this.NoParse.format(this.iLine));
                                        } else {
                                            this.iField2Value = this.iField2Value.replace(',', '|');
                                            this.iField2Wc = new MWildcard(this.iField2Value);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            boolean check(PicInfo info) throws Exception {
                boolean result = true;
                PicInfo.ComboField field1 = info.comboField(this.iField1Name);
                String infoValue1 = field1.compareValue().toString();
                PicInfo.ComboField field2 = info.comboField(this.iField2Name);
                String infoValue2 = field2.compareValue().toString();
                if (infoValue1.equalsIgnoreCase(this.iField1Value) && !this.iField2Wc.matchesAny(infoValue2)) {
                    result = false;
                    if (CheckFieldsCmd.this.supplied("save")) {
                        PicInfo.ComboField identifier = info.comboField("identifier");
                        String newValue = String.valueOf(identifier.value().toString()) + CheckFieldsCmd.TAG;
                        identifier.setValue(newValue);
                    }
                }
                return result;
            }

            public String toString() {
                return this.iLine;
            }
        }
    }

    public static class CopyDbCmd
    extends ClpCmd {
        private static String PICTURESDIR = "pictures";

        public CopyDbCmd() throws Exception {
            super("copy database except TIFs");
            this.add(new ClpCmd.Arg("copy", false));
            this.add(new ClpCmd.Arg("db", false));
            this.add(new ClpCmd.Arg("from", false));
            ClpCmd.Arg arg = this.arg("from");
            arg.add(new ClpCmd.Option("*from folder path"));
            this.add(new ClpCmd.Arg("to", false));
            arg = this.arg("to");
            arg.add(new ClpCmd.Option("*to folder path"));
            this.add(new ClpCmd.Arg("delete", false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MLogging logger = this.clp().logger();
            Database database = Database.singleton();
            synchronized (database) {
                String fromPath = this.arg("from").firstOptionValue();
                String toPath = this.arg("to").firstOptionValue();
                if (this.supplied("delete")) {
                    Utility.deleteFile(toPath);
                }
                File file = new File(toPath);
                file.mkdir();
                CopyDbCmd.copyDb(fromPath, toPath, logger);
                String picPath = String.valueOf(toPath) + File.separator + PICTURESDIR;
                if (this.supplied("delete")) {
                    Utility.deleteFile(picPath);
                }
                file = new File(picPath);
                file.mkdir();
                String photosRootPath = CopyDbCmd.photosRoot(toPath, logger);
                CopyDbCmd.copyPics(photosRootPath, picPath, logger);
                CopyDbCmd.resetPhotoLinks(toPath, photosRootPath, logger);
            }
        }

        private static void resetPhotoLinks(String toPath, String photosRootPath, MLogging logger) throws Exception {
            Filesystem.Local fs = new Filesystem.Local(toPath, false);
            FileInfo.Local infosInfo = new FileInfo.Local((Filesystem)fs, "infosdb");
            BinnedDb infosDb = BinnedDb.open(infosInfo, logger);
            Collection<BinnedDb.Binnable> infos = infosDb.retrieveAll();
            toPath = String.valueOf(toPath.replace('\\', '/')) + '/' + PICTURESDIR;
            photosRootPath = photosRootPath.replace('\\', '/');
            for (BinnedDb.Binnable obj : infos) {
                PicInfo info = (PicInfo)obj;
                MString path = new MString(info.picPathname());
                path.replace(photosRootPath, toPath);
            }
            infosDb.save(true);
            logger.writeln("Reset " + infos.size() + " photo links");
        }

        private static void copyDb(String fromPath, String toPath, MLogging logger) throws Exception {
            Filesystem.Local dbFs = new Filesystem.Local(fromPath, false);
            Filesystem.Local toFs = new Filesystem.Local(toPath, true);
            FilesystemCopier copier = new FilesystemCopier(dbFs, toFs, logger);
            LinkedList<MWildcard> excludes = new LinkedList<MWildcard>();
            excludes.add(new MWildcard("*.html"));
            excludes.add(new MWildcard("*t.jpg"));
            copier.copy(excludes, false, 0);
        }

        private static void copyPics(String fromPath, String toPath, MLogging logger) throws Exception {
            Filesystem.Local dbFs = new Filesystem.Local(fromPath, false);
            Filesystem.Local toFs = new Filesystem.Local(toPath, true);
            FilesystemCopier copier = new FilesystemCopier(dbFs, toFs, logger);
            LinkedList<MWildcard> excludes = new LinkedList<MWildcard>();
            excludes.add(new MWildcard("*.tif"));
            copier.copy(excludes, false, 0);
        }

        /*
         * WARNING - void declaration
         */
        private static String photosRoot(String toPath, MLogging logger) throws Exception {
            void var8_11;
            Filesystem.Local fs = new Filesystem.Local(toPath, false);
            FileInfo.Local infosInfo = new FileInfo.Local((Filesystem)fs, "infosdb");
            BinnedDb infosDb = BinnedDb.open(infosInfo, logger);
            Collection<BinnedDb.Binnable> infos = infosDb.retrieveAll();
            LinkedList<Object> picInfos = new LinkedList<Object>();
            for (BinnedDb.Binnable obj : infos) {
                PicInfo info = (PicInfo)obj;
                picInfos.add(info);
            }
            TreeMap<String, Integer> counters = new TreeMap<String, Integer>();
            for (PicInfo picInfo : picInfos) {
                MString picPath = new MString(picInfo.picPathname());
                LinkedList<MString> tokens = picPath.tokenize("/", false);
                int position = 0;
                for (MString aToken : tokens) {
                    String key;
                    Integer count;
                    if ((count = (Integer)counters.get(key = ++position + "-" + aToken.toString())) == null) {
                        counters.put(key, 1);
                        continue;
                    }
                    counters.put(key, count + 1);
                }
            }
            String string = "";
            Set mappings = counters.entrySet();
            int maxValue = 0;
            for (Map.Entry entry : mappings) {
                String token;
                if (maxValue == 0) {
                    token = (String)entry.getKey();
                    int index = token.indexOf(45);
                    token = token.substring(index + 1);
                    String string2 = String.valueOf(var8_11) + token;
                    maxValue = (Integer)entry.getValue();
                    if (maxValue == picInfos.size()) continue;
                    Utility.throwError("Common root folder for photos does not exist");
                    continue;
                }
                if ((Integer)entry.getValue() != maxValue) continue;
                token = (String)entry.getKey();
                int index = token.indexOf(45);
                token = token.substring(index + 1);
                String string3 = String.valueOf(var8_11) + File.separatorChar + token;
            }
            return var8_11;
        }
    }

    public static class EditPicInfoFieldsCmd
    extends ClpCmd {
        public EditPicInfoFieldsCmd() throws Exception {
            super("Change the value of one or all ComboFields in an album");
            this.add(new ClpCmd.Arg("edit", false));
            this.add(new ClpCmd.Arg("picinfos", false));
            this.add(new ClpCmd.Arg("album", false));
            ClpCmd.Arg arg = this.arg("album");
            arg.add(new ClpCmd.Option("*album"));
            this.add(new ClpCmd.Arg("field", false));
            arg = this.arg("field");
            arg.add(new ClpCmd.Option("*field"));
            arg.add(new ClpCmd.Option(">all"));
            this.add(new ClpCmd.Arg("from", false));
            arg = this.arg("from");
            arg.add(new ClpCmd.Option("*from"));
            this.add(new ClpCmd.Arg("to", false));
            arg = this.arg("to");
            arg.add(new ClpCmd.Option("*to"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            Database db;
            MLogging logger = this.clp().logger();
            Database database = db = Database.singleton();
            synchronized (database) {
                TreeSet<Query> queries = null;
                String queryName = this.arg("album").firstOptionValue();
                if (queryName.equals("*")) {
                    queries = db.queriesByCat("*");
                } else {
                    Query query = db.query(this.arg("album").firstOptionValue(), true);
                    queries = new TreeSet();
                    queries.add(query);
                }
                String[] fieldNames = null;
                String fieldName = this.arg("field").firstOptionValue();
                fieldNames = fieldName.equals("all") ? PicInfo.COMBOBOXFLDS : new String[]{fieldName};
                String from = this.arg("from").firstOptionValue();
                String to = this.arg("to").firstOptionValue();
                int albumCount = 0;
                int fieldCount = 0;
                for (Query query : queries) {
                    Iterator<PicInfo> pics = db.selectPicInfos(query).iterator();
                    int startFieldCount = fieldCount;
                    while (pics.hasNext()) {
                        PicInfo picInfo = pics.next();
                        String[] stringArray = fieldNames;
                        int n = fieldNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            PicInfo.ComboField field = picInfo.comboField(name);
                            if (field == null) {
                                MAppMsg msg = BpmMsgs.get("no_field");
                                Utility.throwError(msg.format(fieldName));
                            } else {
                                MString value = field.mValue();
                                int index = value.indexOf(from);
                                if (index >= 0) {
                                    value.replace(from, to);
                                    field.setValue(value.toString());
                                    ++fieldCount;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (fieldCount <= startFieldCount) continue;
                    ++albumCount;
                }
                if (fieldCount > 0) {
                    db.infosDb().save(true);
                }
                MAppMsg msg = BpmMsgs.get("edited_fields");
                logger.writeln(msg.format(fieldCount, albumCount));
            }
        }
    }

    public static class ExtractImagesCmd
    extends ClpCmd {
        public ExtractImagesCmd() throws Exception {
            super("extract album images to folder");
            this.add(new ClpCmd.Arg("extract", false));
            this.add(new ClpCmd.Arg("album", false));
            ClpCmd.Arg arg = this.arg("album");
            arg.add(new ClpCmd.Option("*album"));
            this.add(new ClpCmd.Arg("folder", false));
            arg = this.arg("folder");
            arg.add(new ClpCmd.Option("*folder"));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            JProgressBar bar;
            File dir;
            MLogging logger = this.clp().logger();
            String dirName = this.arg("folder").firstOptionValue();
            if (!dirName.endsWith(File.separator)) {
                dirName = String.valueOf(dirName) + File.separatorChar;
            }
            if (!(dir = new File(dirName)).exists()) {
                dir.mkdir();
            }
            if ((bar = (JProgressBar)this.clp().state().parm("progressbar")) != null) {
                bar.setValue(0);
            }
            ProgPreferences pref = ProgPreferences.singleton();
            int maxSize = pref.extractMaxSize();
            Database database = Database.singleton();
            synchronized (database) {
                Query query = Database.singleton().query(this.arg("album").firstOptionValue(), true);
                TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(query);
                Integer count = pics.size();
                DoneCounter counter = new DoneCounter(pics.size());
                boolean more = true;
                Iterator iter = pics.iterator();
                while (more && iter.hasNext()) {
                    if (Thread.interrupted()) {
                        more = false;
                        continue;
                    }
                    PicInfo info = (PicInfo)iter.next();
                    Database database2 = Database.singleton();
                    synchronized (database2) {
                        String source = info.picPathname();
                        File file = new File(source);
                        if (file.exists()) {
                            String target = String.valueOf(dir.getAbsolutePath()) + '/' + file.getName();
                            if (pref.extractRename().equals("Yes")) {
                                String number = String.format("%04d", counter.done() + 1);
                                target = String.valueOf(dir.getAbsolutePath()) + '/' + "bpm" + number + ".jpg";
                            }
                            if (maxSize == -1) {
                                Utility.copyFile(source, target);
                            } else {
                                BufferedImage bufImage = ImageIOUtil.load(source);
                                double height = bufImage.getHeight();
                                double width = bufImage.getWidth();
                                if (height <= (double)maxSize && width <= (double)maxSize) {
                                    Utility.copyFile(source, target);
                                } else {
                                    bufImage = ImageIOUtil.resize(bufImage, maxSize);
                                    String quality = ProgPreferences.singleton().otherJpegQual();
                                    ImageIOUtil.writeJpeg(bufImage, target, Integer.parseInt(quality));
                                }
                            }
                            counter.add(1);
                        }
                        if (bar != null) {
                            bar.setValue(counter.percent());
                        }
                    }
                }
                this.clp().state().putParm("result", count);
                MAppMsg msg = BpmMsgs.get("extracted_album");
                String text = msg.format(count.toString());
                logger.writeln(text, false);
            }
        }
    }

    public static class OpenDbCmd
    extends ClpCmd {
        public OpenDbCmd() throws Exception {
            super("open database");
            this.add(new ClpCmd.Arg("open", false));
        }

        @Override
        public void execute() throws Exception {
            MLogging logger = this.clp().logger();
            ProgInstallation.read();
            Filesystem.Local fs = new Filesystem.Local(ProgInstallation.singleton().dir(), true);
            FileInfo.Local bpmDir = new FileInfo.Local((Filesystem)fs, "");
            Database.Parms parms = new Database.Parms(bpmDir, null);
            Database.open(parms, true, logger);
        }
    }

    public static class RebuildExifCmd
    extends ClpCmd {
        public RebuildExifCmd() throws Exception {
            super("rebuild exif tags");
            this.add(new ClpCmd.Arg("rebuild", false));
            this.add(new ClpCmd.Arg("exif", false));
            this.add(new ClpCmd.Arg("save", true));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MReport report = new MReport("Rebuild EXIF Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                if (!this.supplied("save")) {
                    report.addLine("EXIFs that would be rebuilt:");
                } else {
                    report.addLine("EXIFs rebuilt:");
                }
                int count = 0;
                Collection<PicInfo> allPics = db.picInfosByPathname().values();
                MLogger.Empty logger = new MLogger.Empty();
                for (PicInfo info : allPics) {
                    if (info.needsExifUpdate()) {
                        ++count;
                        if (!this.supplied("save")) {
                            report.addLine("Would rebuild " + info.picPathname());
                        } else {
                            try {
                                BpmExifTag tag = new BpmExifTag(info, false);
                                tag.write(logger);
                                report.addLine("Rebuilt " + info.picPathname());
                            }
                            catch (Exception xcp) {
                                MAppMsg msg = BpmMsgs.get("unable_write_exif");
                                report.addLine(msg.format(info.picPathname()));
                            }
                        }
                    }
                    if (count % 100 != 0) continue;
                    this.clp().logger().writeln("" + count);
                }
                report.addLine(count + " files");
                report.writeTo(this.clp().logger());
                MLogger rptLogger = BpmClp.reportLogger(this, report);
                report.writeTo(rptLogger);
                MAppMsg appMsg = BpmMsgs.get("saved");
                this.clp().logger().writeln(appMsg.format(report.title()));
            }
        }
    }

    public static class RebuildThumbsCmd
    extends ClpCmd {
        public RebuildThumbsCmd() throws Exception {
            super("rebuild thumbnails as required");
            this.add(new ClpCmd.Arg("rebuild", false));
            this.add(new ClpCmd.Arg("thumbnails", false));
            this.add(new ClpCmd.Arg("save", true));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            Database db;
            MLogging logger = this.clp().logger();
            Database database = db = Database.singleton();
            synchronized (database) {
                int count = 0;
                Collection<PicInfo> allPics = db.picInfosByPathname().values();
                for (PicInfo info : allPics) {
                    String imagePath = info.picPathname();
                    try {
                        BinnedDb.Path path = db.infosDb().filePath(info.thumbObjNum(), ".jpg");
                        long thumbDate = new File(path.path()).lastModified();
                        long picDate = new File(imagePath).lastModified();
                        if (picDate > thumbDate) {
                            if (!this.supplied("save")) {
                                MAppMsg msg = BpmMsgs.get("would_rebuild_thumb");
                                logger.writeln(msg.format(imagePath));
                            } else {
                                BufferedImage image = ImageIOUtil.load(imagePath);
                                if (image == null) {
                                    MAppMsg msg = BpmMsgs.get("unable_read_photo");
                                    logger.writeln(msg.format(imagePath));
                                } else {
                                    ThumbnailImage thumb = new ThumbnailImage();
                                    ProgPreferences pref = ProgPreferences.singleton();
                                    int thumbSize = pref.thumbnailSize();
                                    thumb.setup(image, thumbSize);
                                    thumb.write(path.path());
                                    MAppMsg msg = BpmMsgs.get("built_thumbnail");
                                    logger.writeln(msg.format(imagePath));
                                }
                            }
                        }
                    }
                    catch (Exception xcp) {
                        logger.writeln(Utility.xcpMsg(xcp), true);
                    }
                    if (++count % 100 != 0) continue;
                    this.clp().logger().writeln("" + count);
                }
            }
        }
    }

    public static class RenameFileCmd
    extends ClpCmd {
        public RenameFileCmd() throws Exception {
            super("rename photo file");
            this.add(new ClpCmd.Arg("rename", false));
            this.add(new ClpCmd.Arg("photofile", false));
            this.add(new ClpCmd.Arg("oldname", false));
            ClpCmd.Arg arg = this.arg("oldname");
            arg.add(new ClpCmd.Option("*oldname"));
            this.add(new ClpCmd.Arg("newname", false));
            arg = this.arg("newname");
            arg.add(new ClpCmd.Option("*newname"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            Database db;
            MLogging logger = this.clp().logger();
            Database database = db = Database.singleton();
            synchronized (database) {
                String oldName = this.arg("oldname").firstOptionValue();
                String newName = this.arg("newname").firstOptionValue();
                Iterator<PicInfo> iter = db.picInfosByPathname().values().iterator();
                boolean done = false;
                while (!done && iter.hasNext()) {
                    PicInfo info = iter.next();
                    MString oldPath = new MString(info.picPathname());
                    if (oldPath.indexOf(oldName) < 0) continue;
                    MAppMsg msg = BpmMsgs.get("renamed_file");
                    File picFile = new File(info.picPathname());
                    if (picFile.exists()) {
                        File[] files;
                        MString newPath = (MString)oldPath.clone();
                        newPath.replace(oldName, newName);
                        File dir = new File(picFile.getParent());
                        File[] fileArray = files = dir.listFiles();
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            String path = file.getAbsolutePath();
                            if (path.indexOf(oldName) >= 0) {
                                newPath = new MString(path);
                                newPath.replace(oldName, newName);
                                File newFile = new File(newPath.toString());
                                file.renameTo(newFile);
                                if (picFile.getName().equals(file.getName())) {
                                    info.setPicPathname(newPath.toString());
                                }
                                logger.writeln(msg.format(file.getName(), newFile.getName()));
                            }
                            ++n2;
                        }
                        continue;
                    }
                    msg = BpmMsgs.get("photo_not_found");
                    logger.writeln(msg.format(oldName));
                }
                db.infosDb().save(true);
            }
        }
    }

    public static class SetAlbumIdsCmd
    extends ClpCmd {
        public SetAlbumIdsCmd() throws Exception {
            super("Set sequential identifiers for all pictures in an album");
            this.add(new ClpCmd.Arg("set", false));
            this.add(new ClpCmd.Arg("album", false));
            ClpCmd.Arg arg = this.arg("album");
            arg.add(new ClpCmd.Option("*album"));
            this.add(new ClpCmd.Arg("format", false));
            arg = this.arg("format");
            arg.add(new ClpCmd.Option("*DecimalFormat"));
            this.add(new ClpCmd.Arg("clear", true));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            Database db;
            MLogging logger = this.clp().logger();
            DecimalFormat format = new DecimalFormat(this.arg("format").firstOptionValue());
            int id = 1;
            Database database = db = Database.singleton();
            synchronized (database) {
                Query query = db.query(this.arg("album").firstOptionValue(), true);
                TreeSet<PicInfo> pics = Database.singleton().selectPicInfos(query);
                for (PicInfo info : pics) {
                    PicInfo.ComboField field = info.comboField("identifier");
                    if (this.supplied("clear")) {
                        field.setValue("");
                        continue;
                    }
                    String number = format.format(id);
                    field.setValue(number);
                    db.putPic(info, false);
                    ++id;
                }
                db.save();
                MAppMsg msg = BpmMsgs.get("database");
                logger.writeln(msg.format(pics.size()));
            }
        }
    }

    public static class UploadWebsiteCmd
    extends ClpCmd {
        public UploadWebsiteCmd() throws Exception {
            super("upload website");
            this.add(new ClpCmd.Arg("upload", false));
            this.add(new ClpCmd.Arg("website", false));
            ClpCmd.Arg arg = this.arg("website");
            arg.add(new ClpCmd.Option("*website"));
            this.add(new BpmClp.DbOpened());
        }

        @Override
        public void execute() throws Exception {
            MLogging logger = this.clp().logger();
            String siteName = this.arg("website").firstOptionValue();
            Website site = Database.singleton().webDb().find(siteName);
            if (site != null) {
                WebMgr mgr = new WebMgr(site, false);
                mgr.start();
                mgr.join();
            } else {
                MAppMsg msg = BpmMsgs.get("website_not_found");
                logger.writeln(msg.format(siteName));
            }
        }
    }

    public static class WriteVersionFileCmd
    extends ClpCmd {
        public WriteVersionFileCmd() throws Exception {
            super("write version file");
            this.add(new ClpCmd.Arg("write", false));
            this.add(new ClpCmd.Arg("versionfile", false));
            ClpCmd.Arg arg = this.arg("versionfile");
            arg.add(new ClpCmd.Option("*version date dd/month/yyy"));
        }

        @Override
        public void execute() throws Exception {
            MLogging logger = this.clp().logger();
            String date = this.arg("versionfile").firstOptionValue();
            MEncStr version = new MEncStr(date);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("version.dat"));
            out.writeObject(version);
            out.close();
            logger.writeln("Wrote version file: " + version.toString());
        }
    }
}

