/*
 * Decompiled with CFR 0.152.
 */
package cmdproc;

import clp.Clp;
import clp.ClpCmd;
import cmdproc.CleanCmds;
import cmdproc.ListCmds;
import cmdproc.OtherCmds;
import java.io.File;
import mlib.MLogger;
import mlib.MReport;
import oroma.db.Database;

public class BpmClp
extends Clp {
    public static final String VERSION = "11-Jan-2026";
    public static final String ALBUMARG = "album";
    public static final String ALBUMSARG = "albums";
    public static final String CATEGORYARG = "category";
    public static final String CHECKARG = "check";
    public static final String CLEANARG = "clean";
    public static final String CLEARARG = "clear";
    public static final String COMBOBOXESARG = "comboboxes";
    public static final String COMBODBSARG = "combodbs";
    public static final String COPYARG = "copy";
    public static final String CREATEARG = "create";
    public static final String DBARG = "db";
    public static final String DELETEARG = "delete";
    public static final String EDITARG = "edit";
    public static final String EXIFARG = "exif";
    public static final String EXTRACTARG = "extract";
    public static final String BUILDARG = "build";
    public static final String WEBSITESARG = "websites";
    public static final String FIELDARG = "field";
    public static final String FIELDSARG = "fields";
    public static final String FILEINFOSARG = "fileinfos";
    public static final String FOLDERARG = "folder";
    public static final String FORMATARG = "format";
    public static final String FROMARG = "from";
    public static final String LISTARG = "list";
    public static final String SAVEARG = "save";
    public static final String OPENARG = "open";
    public static final String PICINFOSARG = "picinfos";
    public static final String PICSARG = "pics";
    public static final String REPORTARG = "report";
    public static final String REREADARG = "reread";
    public static final String RULESARG = "rules";
    public static final String RUNNABLEARG = "runnable";
    public static final String SETARG = "set";
    public static final String TOARG = "to";
    public static final String UPLOADARG = "upload";
    public static final String WEBSITEARG = "website";
    public static final String XMLARG = "xml";
    public static final String REBUILDARG = "rebuild";
    public static final String THUMBNAILSARG = "thumbnails";
    public static final String RENAMEARG = "rename";
    public static final String PHOTOFILEARG = "photofile";
    public static final String OLDNAMEARG = "oldname";
    public static final String NEWNAMEARG = "newname";
    public static final String LISTONLYARG = "listonly";
    public static final String ASSLIDESARG = "ASSLIDES";
    public static final String SLIDESDIRARG = "slidesdir";
    public static final String TEMPLATEARG = "template";
    public static final String CHARSIZEARG = "charsize";
    public static final String ANNOTFIELDSARG = "annotfields";
    public static final String WRITEARG = "write";
    public static final String VERSIONFILEARG = "versionfile";
    public static final String RESOLUTIONPARM = "resolution";
    public static final String PROGRESSBARPARM = "progressbar";
    public static final String RESULTPARM = "result";

    public static MLogger reportLogger(ClpCmd cmd, MReport report) throws Exception {
        String path = Database.singleton().parms().bpmPath().path();
        if (cmd.supplied(REPORTARG)) {
            path = cmd.arg(REPORTARG).firstOptionValue();
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(path) + File.separator;
            }
        } else {
            File file = new File(String.valueOf(path) + "reports");
            if (!file.exists()) {
                file.mkdir();
            }
            path = String.valueOf(file.getAbsolutePath()) + File.separator;
        }
        String fileName = report.title().toLowerCase();
        fileName = fileName.replace(' ', '-');
        path = String.valueOf(path) + fileName + ".txt";
        MLogger.File logger = new MLogger.File(path, false);
        return logger;
    }

    public BpmClp(Clp.State state, boolean logStart) throws Exception {
        super(state, logStart);
        this.addCmd(new OtherCmds.OpenDbCmd());
        this.addCmd(new OtherCmds.ExtractImagesCmd());
        this.addCmd(new OtherCmds.BuildSlidesCmd());
        this.addCmd(new OtherCmds.UploadWebsiteCmd());
        this.addCmd(new OtherCmds.CheckFieldsCmd());
        this.addCmd(new OtherCmds.BuildComboDbsCmd());
        this.addCmd(new OtherCmds.SetAlbumIdsCmd());
        this.addCmd(new OtherCmds.EditPicInfoFieldsCmd());
        this.addCmd(new OtherCmds.RebuildThumbsCmd());
        this.addCmd(new OtherCmds.RebuildExifCmd());
        this.addCmd(new OtherCmds.RenameFileCmd());
        this.addCmd(new OtherCmds.CopyDbCmd());
        this.addCmd(new OtherCmds.WriteVersionFileCmd());
        this.addCmd(new ListCmds.PicInfosCmd());
        this.addCmd(new ListCmds.PicInfosExifCmd());
        this.addCmd(new ListCmds.PicInfosXmlCmd());
        this.addCmd(new ListCmds.AlbumsCmd());
        this.addCmd(new ListCmds.AlbumFieldDistCmd());
        this.addCmd(new CleanCmds.PicInfosCmd());
        this.addCmd(new CleanCmds.ComboBoxesCmd());
        this.addCmd(new CleanCmds.PicsCmd());
        this.addCmd(new CleanCmds.FileInfosCmd());
    }

    public static class DbOpened
    extends ClpCmd.PreCondition {
        @Override
        public String result() throws Exception {
            String result = null;
            if (Database.singleton() == null) {
                result = this.toString();
            }
            return result;
        }

        public String toString() {
            return "database must be opened";
        }
    }

    public static class State
    extends Clp.State {
    }
}

