/*
 * Decompiled with CFR 0.152.
 */
package clp;

import clp.Clp;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.ToolTipManager;
import mswing.StdColor;
import swing.ColorButton;
import swing.ColorPanel;
import swing.StatusBox;

class ScriptButton
extends ColorButton {
    private String iScript = null;
    private Clp iCmdProc = null;
    private String iHoverText = null;
    private ActionListener iActionHandler = new ActionHandler();
    private static ScriptButton CurButton = null;
    private static TreeMap<String, ScriptButton> Buttons = new TreeMap();
    private static final Color ACTIVEFORECOLOR = Color.white;
    private static final Color ACTIVEBACKCOLOR = StdColor.LIGHTBLUE.color();

    public static String click(String label) {
        String name = null;
        ScriptButton button = Buttons.get(label);
        if (button != null) {
            button.iActionHandler.actionPerformed(null);
            name = button.getText();
        } else {
            String msg = "Button not found: " + label;
            StatusBox.singleton().showMsg(msg, true);
            Iterator<ScriptButton> iter = Buttons.values().iterator();
            button = iter.next();
            button.getCmdProc().logger().writeln(msg, true);
        }
        return name;
    }

    public static void endCurButton() {
        if (CurButton != null) {
            CurButton.setBackground(ColorPanel.backColorAll());
            CurButton.setForeground(ColorPanel.foreColorAll());
            CurButton.setFont(ColorButton.fontAll());
        }
        for (ScriptButton button : Buttons.values()) {
            button.setEnabled(true);
            button.setCursor(Cursor.getPredefinedCursor(0));
        }
        CurButton = null;
    }

    public ScriptButton(String label, String script, String hoverText, Clp cmdProc) {
        super(label);
        this.iScript = script;
        this.iCmdProc = cmdProc;
        this.iHoverText = hoverText;
        Buttons.put(script, this);
        this.addActionListener(this.iActionHandler);
        this.addMouseListener(new MouseHandler());
    }

    public Clp getCmdProc() {
        return this.iCmdProc;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                CurButton = ScriptButton.this;
                for (ScriptButton button : Buttons.values()) {
                    if (button == CurButton) continue;
                    button.setEnabled(false);
                }
                ScriptButton.this.setBackground(ACTIVEBACKCOLOR);
                ScriptButton.this.setForeground(ACTIVEFORECOLOR);
                ScriptButton.this.setCursor(Cursor.getPredefinedCursor(3));
                ScriptButton.this.iCmdProc.execFile(ScriptButton.this.iScript);
                String msg = "Did " + CurButton.iScript;
                StatusBox.singleton().queueShowMsg(msg, false);
                ScriptButton.endCurButton();
            }
            catch (Exception xcp) {
                ScriptButton.endCurButton();
                StatusBox.singleton().queueShowMsg(xcp.getClass().getName(), true);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            ToolTipManager.sharedInstance().setEnabled(true);
            if (ScriptButton.this.iHoverText != null) {
                ScriptButton.this.setToolTipText(ScriptButton.this.iHoverText);
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            ToolTipManager.sharedInstance().setEnabled(false);
        }
    }
}

