/*
 * Decompiled with CFR 0.152.
 */
package clp;

import clp.ClpCmd;
import clp.ColorMap;
import clp.ScriptButton;
import java.util.LinkedList;
import java.util.StringTokenizer;
import mlib.MString;
import utilt.Utility;

class GuiCmds {
    public static final String STRINGPARMDELIM = "%";
    public static final String $COLORMAPPARM = "$colormap";
    public static final String $BUTTONARG = "$button";
    public static final String $BUTTONROWARG = "$buttonrow";
    public static final String $CLICKBUTTONARG = "$clickbutton";
    public static final String $COLORMAPARG = "$colormap";
    public static final String NAMEARG = "name";
    public static final String HOVERARG = "hover";

    private static LinkedList<String> parseDelimStr(String str) {
        LinkedList<String> strs = new LinkedList<String>();
        StringTokenizer tken = new StringTokenizer(str, STRINGPARMDELIM);
        while (tken.hasMoreTokens()) {
            strs.add(tken.nextToken());
        }
        return strs;
    }

    private GuiCmds() {
    }

    private static class ButtonsPanelExists
    extends ClpCmd.PreCondition {
        private ButtonsPanelExists() {
        }

        @Override
        public String result() {
            String result = null;
            LinkedList panels = (LinkedList)this.clp().state().parm("buttonspanel");
            if (panels == null) {
                result = this.toString();
            }
            return result;
        }

        public String toString() {
            return "no button panel found";
        }
    }

    public static class ClickButtonCmd
    extends ClpCmd {
        public ClickButtonCmd() throws Exception {
            super("click scriptbutton");
            this.add(new ClpCmd.Arg(GuiCmds.$CLICKBUTTONARG, false));
            ClpCmd.Arg arg = this.arg(GuiCmds.$CLICKBUTTONARG);
            arg.add(new ClpCmd.Option("*script"));
            this.add(new ButtonsPanelExists());
        }

        @Override
        public void execute() throws Exception {
            String name = this.arg(GuiCmds.$CLICKBUTTONARG).firstOptionValue();
            ScriptButton.click(name);
        }
    }

    public static class CreateButtonCmd
    extends ClpCmd {
        public CreateButtonCmd() throws Exception {
            super("define control button");
            this.add(new ClpCmd.Arg(GuiCmds.$BUTTONARG, false));
            ClpCmd.Arg arg = this.arg(GuiCmds.$BUTTONARG);
            this.add(new ClpCmd.Arg(GuiCmds.NAMEARG, false));
            arg = this.arg(GuiCmds.NAMEARG);
            arg.add(new ClpCmd.Option("*name"));
            this.add(new ClpCmd.Arg("script", false));
            arg = this.arg("script");
            arg.add(new ClpCmd.Option("*scriptname"));
            this.add(new ClpCmd.Arg(GuiCmds.HOVERARG, true));
            arg = this.arg(GuiCmds.HOVERARG);
            arg.add(new ClpCmd.Option("*hover"));
            this.add(new ButtonsPanelExists());
        }

        @Override
        public void execute() throws Exception {
            LinkedList panels = (LinkedList)this.clp().state().parm("buttonspanel");
            MString curPanel = (MString)panels.getLast();
            String name = this.arg(GuiCmds.NAMEARG).firstOptionValue();
            String script = this.arg("script").firstOptionValue();
            String hover = "";
            if (this.supplied(GuiCmds.HOVERARG)) {
                MString work = new MString(this.arg(GuiCmds.HOVERARG).firstOptionValue());
                work.trim('\"');
                hover = work.toString();
            }
            curPanel.concat(String.valueOf(name) + "=" + script + "=" + hover);
            this.clp().state().putParm("buttonspanel", panels);
        }
    }

    public static class CreateButtonPanelCmd
    extends ClpCmd {
        public CreateButtonPanelCmd() throws Exception {
            super("define button panel");
            this.add(new ClpCmd.Arg(GuiCmds.$BUTTONROWARG, false));
            this.add(new ClpCmd.Arg(GuiCmds.NAMEARG, true));
            ClpCmd.Arg arg = this.arg(GuiCmds.NAMEARG);
            arg.add(new ClpCmd.Option("*name"));
        }

        @Override
        public void execute() throws Exception {
            LinkedList<MString> panels;
            String name = "";
            if (this.supplied(GuiCmds.NAMEARG)) {
                MString work = new MString(this.arg(GuiCmds.NAMEARG).firstOptionValue());
                work.trim('\"');
                name = work.toString();
            }
            if ((panels = (LinkedList<MString>)this.clp().state().parm("buttonspanel")) == null) {
                panels = new LinkedList<MString>();
            }
            MString panelStr = new MString(String.valueOf(name) + ";");
            panels.add(panelStr);
            this.clp().state().putParm("buttonspanel", panels);
        }
    }

    public static class SetColorMapCmd
    extends ClpCmd {
        public SetColorMapCmd() throws Exception {
            super("set color map");
            this.add(new ClpCmd.Arg("$colormap", false));
            ClpCmd.Arg arg = this.arg("$colormap");
            arg.add(new ClpCmd.Option("*key-color[%...]"));
        }

        @Override
        public void execute() throws Exception {
            String avails = this.arg("$colormap").firstOptionValue();
            LinkedList strs = GuiCmds.parseDelimStr(avails);
            ColorMap colors = new ColorMap();
            for (String str : strs) {
                StringTokenizer tken1 = new StringTokenizer(str, "-");
                if (tken1.countTokens() != 2) {
                    Utility.throwError("invalid color " + str);
                }
                String key = tken1.nextToken();
                String colorStr = tken1.nextToken();
                colors.add(key, colorStr);
            }
            this.clp().state().putParm("$colormap", colors);
        }
    }
}

