/*
 * Decompiled with CFR 0.152.
 */
package clp;

import clp.Clp;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import mlib.MAppMsg;
import mlib.MCharColl;
import mlib.MSignature;
import mlib.MString;
import utilt.Utility;

public abstract class ClpCmd {
    private Clp iClp = null;
    private MString iDesc = new MString();
    private MSignature iReqdSignature = new MSignature();
    private MSignature iOptSignature = new MSignature();
    private LinkedList<Arg> iArgs = new LinkedList();
    private LinkedList<PreCondition> iPreConds = new LinkedList();

    private static void parseComment(MCharColl.Queue line) throws Exception {
        boolean done = false;
        while (line.hasMore() && !done) {
            boolean bl = done = line.pop() == ']';
        }
    }

    public ClpCmd(String desc) throws Exception {
        this.iClp = Clp.CurClp;
        if (desc.length() == 0) {
            MAppMsg msg = Clp.msg("cmd-desc-empty");
            Clp.clpThrowError(msg.format(this.iClp.name()));
        }
        this.iDesc = new MString(desc);
        Clp.CurCmd = this;
    }

    public String desc() {
        return this.iDesc.toString();
    }

    public Clp clp() {
        return this.iClp;
    }

    public void add(PreCondition preCond) throws Exception {
        if (preCond == null) {
            MAppMsg msg = Clp.msg("null-precond");
            Clp.clpThrowError(msg.format(this.getClass().getName()));
        }
        this.iPreConds.add(preCond);
    }

    public void add(Arg arg) throws Exception {
        int result = 1;
        Iterator iter = this.iArgs.iterator();
        while (result != 0 && iter.hasNext()) {
            Arg anArg = (Arg)iter.next();
            result = Clp.ArgComparator.compare(anArg, arg);
        }
        if (result == 0) {
            MAppMsg msg = Clp.msg("duplicate-arg");
            Clp.clpThrowError(msg.format(arg.name(), this.desc()));
        }
        arg.setCmd(this);
        this.iArgs.add(arg);
        if (arg.isOptional()) {
            this.iOptSignature.add(arg.name());
        } else {
            this.iReqdSignature.add(arg.name());
        }
    }

    public Arg arg(String name) {
        Arg arg = null;
        for (Arg anArg : this.iArgs) {
            if (!anArg.name().equalsIgnoreCase(name)) continue;
            arg = anArg;
        }
        return arg;
    }

    public void init() {
    }

    public abstract void execute() throws Exception;

    public String toString() {
        MString str = new MString();
        int count = 0;
        for (Arg arg : this.iArgs) {
            if (arg.isOptional()) continue;
            if (count++ > 0) {
                str.concat(" ");
            }
            str.concat(arg.toString());
        }
        for (Arg arg : this.iArgs) {
            if (!arg.isOptional()) continue;
            if (count++ > 0) {
                str.concat(" ");
            }
            str.concat(arg.toString());
        }
        str.concat(" --> " + this.iDesc);
        if (this.iPreConds.size() > 0) {
            str.concat(", " + this.iPreConds.size() + " precondition(s)");
        }
        return str.toString().trim();
    }

    public boolean supplied(String argName) {
        Arg arg = this.arg(argName);
        boolean supplied = arg != null && arg.wasSupplied();
        return supplied;
    }

    MSignature reqdSignature() {
        return this.iReqdSignature;
    }

    MSignature optSignature() {
        return this.iOptSignature;
    }

    LinkedList<Arg> args() {
        return this.iArgs;
    }

    void setClp(Clp clp) throws Exception {
        if (this.iClp == null) {
            this.iClp = clp;
        }
        for (PreCondition cond : this.iPreConds) {
            cond.setClp(this.iClp);
        }
    }

    void doPreConds() throws Exception {
        for (PreCondition preCond : this.iPreConds) {
            String result = preCond.result();
            if (result == null) continue;
            MAppMsg msg = Clp.msg("failed-precond");
            throw new Clp.PreConditionXcp(msg.format(result));
        }
    }

    public static class Arg {
        private ClpCmd iCmd = null;
        private MString iName = new MString();
        private boolean iOptional = false;
        private LinkedList<Option> iOptions = new LinkedList();
        private boolean iSupplied = false;

        static Arg parse(MCharColl.Queue line) throws Exception {
            Arg arg = new Arg();
            line.popWhitespace();
            boolean done = false;
            while (line.hasMore() && !done) {
                char next = line.peek();
                if (next == '[') {
                    ClpCmd.parseComment(line);
                    continue;
                }
                if (next == ':') {
                    Option option = Option.parse(line);
                    if (option == null) continue;
                    arg.iOptions.add(option);
                    continue;
                }
                if (!Character.isWhitespace(next)) {
                    arg.iName.concat(next);
                    line.pop();
                    continue;
                }
                done = true;
            }
            if (arg.iName.length() == 0) {
                arg = null;
            }
            return arg;
        }

        public Arg(String name, boolean optional) throws Exception {
            boolean hasType;
            if (name.length() < 2) {
                MAppMsg msg = Clp.msg("invalid-arg");
                Clp.clpThrowError(msg.format(name, Clp.CurCmd.desc()));
            }
            this.iName = new MString(name).toLowerCase();
            char type = this.iName.charAt(0);
            boolean bl = hasType = type == '*' || type == '#' || type == '>' || type == '@';
            if (hasType) {
                MAppMsg msg = Clp.msg("invalid-arg-name");
                Clp.clpThrowError(msg.format(this.iName.toString(), Clp.CurCmd.desc()));
            }
            this.iOptional = optional;
        }

        public ClpCmd cmd() {
            return this.iCmd;
        }

        public String name() {
            return this.iName.toString();
        }

        public boolean isOptional() {
            return this.iOptional;
        }

        public void add(Option option) throws Exception {
            LinkedList<MString> items = option.items();
            for (MString item : items) {
                boolean hasType;
                char type = item.charAt(0);
                boolean bl = hasType = type == '*' || type == '#' || type == '>' || type == '@';
                if (hasType) continue;
                MAppMsg msg = Clp.msg("no-typeindicator");
                Clp.clpThrowError(msg.format(item.toString(), this.iCmd.desc()));
            }
            boolean added = this.iOptions.add(option);
            if (!added) {
                MAppMsg msg = Clp.msg("duplicate-option");
                Clp.clpThrowError(msg.format(this.name(), option.toString()));
            }
        }

        public String[] optionValues() throws Exception {
            String[] values = null;
            boolean done = false;
            Iterator optionIter = this.iOptions.iterator();
            while (!done && optionIter.hasNext()) {
                Option option = (Option)optionIter.next();
                LinkedList<MString> oValues = option.values();
                if (oValues.size() <= 0) continue;
                values = new String[oValues.size()];
                Iterator valuesIter = oValues.iterator();
                int index = 0;
                while (valuesIter.hasNext()) {
                    MString work = (MString)valuesIter.next();
                    work.trim('\"');
                    values[index++] = work.toString();
                }
                done = true;
            }
            return values;
        }

        public String firstOptionValue() throws Exception {
            String value = null;
            String[] values = this.optionValues();
            if (values != null) {
                value = values[0];
            }
            return value;
        }

        public String toString() {
            String str = "";
            if (this.iOptional) {
                str = String.valueOf(str) + '[';
            }
            str = String.valueOf(str) + this.iName;
            if (this.iOptions.size() > 0) {
                str = String.valueOf(str) + ':';
                if (this.iOptions.size() == 1) {
                    str = String.valueOf(str) + this.iOptions.getFirst();
                } else {
                    str = String.valueOf(str) + '|';
                    for (Option option : this.iOptions) {
                        str = String.valueOf(str) + option.toString();
                        str = String.valueOf(str) + '|';
                    }
                }
            }
            if (this.iOptional) {
                str = String.valueOf(str) + ']';
            }
            return str;
        }

        Arg() {
        }

        LinkedList<Option> options() {
            return this.iOptions;
        }

        MSignature optionsSignature() {
            MSignature sig = new MSignature();
            for (Option option : this.iOptions) {
                sig.add(option.signature());
            }
            return sig;
        }

        void setCmd(ClpCmd cmd) {
            this.iCmd = cmd;
        }

        void setSupplied(boolean supplied) {
            this.iSupplied = supplied;
        }

        boolean wasSupplied() {
            return this.iSupplied;
        }

        String[] optionValuesWithQuotes() throws Exception {
            String[] values = null;
            boolean done = false;
            Iterator optionIter = this.iOptions.iterator();
            while (!done && optionIter.hasNext()) {
                Option option = (Option)optionIter.next();
                LinkedList<MString> oValues = option.values();
                if (oValues.size() <= 0) continue;
                values = new String[oValues.size()];
                Iterator valuesIter = oValues.iterator();
                Iterator quotesIter = option.iQuotes.iterator();
                int index = 0;
                while (valuesIter.hasNext()) {
                    String value = ((MString)valuesIter.next()).toString();
                    boolean quotes = (Boolean)quotesIter.next();
                    if (quotes) {
                        value = "\"" + value + "\"";
                    }
                    values[index++] = value;
                }
                done = true;
            }
            return values;
        }
    }

    static class CmdOrderer
    implements Comparator<ClpCmd> {
        CmdOrderer() {
        }

        @Override
        public int compare(ClpCmd cmd1, ClpCmd cmd2) {
            int result = -1;
            result = cmd1.iReqdSignature.toString().compareTo(cmd2.iReqdSignature.toString());
            return result;
        }
    }

    public static class Option {
        private MSignature iSignature = new MSignature();
        private LinkedList<MString> iItems = new LinkedList();
        private LinkedList<MString> iValues = null;
        private LinkedList<Boolean> iQuotes = null;

        static Option parse(MCharColl.Queue line) throws Exception {
            line.pop();
            Option option = new Option();
            boolean done = false;
            option.iValues = new LinkedList();
            option.iQuotes = new LinkedList();
            MString value = new MString();
            boolean quotes = false;
            line.popWhitespace();
            while (line.hasMore() && !done) {
                char next = line.peek();
                if (next == '[') {
                    ClpCmd.parseComment(line);
                    continue;
                }
                if (next == '\"') {
                    value = Option.parseQuote(line);
                    quotes = true;
                    continue;
                }
                if (next == ',') {
                    MString work = (MString)value.clone();
                    option.iValues.add(work);
                    option.iQuotes.add(quotes);
                    value.clear();
                    line.pop();
                    continue;
                }
                if (!Character.isWhitespace(next)) {
                    value.concat(next);
                    line.pop();
                    continue;
                }
                done = true;
            }
            if (value.length() > 0) {
                option.iValues.add(value);
                option.iQuotes.add(quotes);
            }
            if (option.iValues.size() == 0) {
                MAppMsg msg = Clp.msg("empty-option");
                Clp.clpThrowError(msg.format());
            }
            return option;
        }

        public Option() {
        }

        public Option(String items) throws Exception {
            items = items.toLowerCase();
            String[] tokens = Utility.strTokens(items, ',');
            MString work = new MString();
            int count = 0;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                char indicator;
                String token = stringArray[n2];
                if (token.length() < 1) {
                    MAppMsg msg = Clp.msg("invalid-item");
                    Clp.clpThrowError(msg.format(token));
                }
                if ((indicator = token.charAt(0)) == '*') {
                    if (count++ > 0) {
                        work.concat(',');
                    }
                    work.concat(indicator);
                } else if (indicator == '#') {
                    if (count++ > 0) {
                        work.concat(',');
                    }
                    work.concat(indicator);
                } else if (indicator == '@') {
                    if (count++ > 0) {
                        work.concat(',');
                    }
                    work.concat(indicator);
                } else if (indicator == '>') {
                    if (tokens.length > 1) {
                        MAppMsg msg = Clp.msg("invalid-disc-option");
                        Clp.clpThrowError(msg.format(items));
                    }
                    if (count++ > 0) {
                        work.concat(',');
                    }
                    work.concat(token);
                }
                this.iItems.add(new MString(token));
                ++n2;
            }
            this.iSignature.add(work.toString());
        }

        public String toString() {
            return this.iSignature.toString();
        }

        MSignature signature() {
            return this.iSignature;
        }

        LinkedList<MString> values() {
            return this.iValues;
        }

        void setValues(LinkedList<MString> values) {
            this.iValues = values;
        }

        void setQuotes(LinkedList<Boolean> quotes) {
            this.iQuotes = quotes;
        }

        LinkedList<Boolean> quotes() {
            return this.iQuotes;
        }

        LinkedList<MString> items() {
            return this.iItems;
        }

        private static MString parseQuote(MCharColl.Queue line) throws Exception {
            boolean done = false;
            MString quote = new MString();
            line.pop();
            while (line.hasMore() && !done) {
                char chr = line.pop();
                boolean bl = done = chr == '\"';
                if (done) continue;
                quote.concat(chr);
            }
            return quote.trimWhitespace();
        }
    }

    static class ParsingResult {
        private LinkedList<Arg> iParsedArgs = new LinkedList();
        private MSignature iSig = null;

        ParsingResult() {
        }

        static ParsingResult parseLine(String cmdLine) throws Exception {
            ParsingResult pResult = new ParsingResult();
            MCharColl.Queue line = new MCharColl.Queue(cmdLine, false);
            line.popWhitespace();
            while (line.hasMore()) {
                char next = line.peek();
                if (next == '[') {
                    ClpCmd.parseComment(line);
                    continue;
                }
                Arg anArg = null;
                do {
                    if ((anArg = Arg.parse(line)) == null) continue;
                    pResult.iParsedArgs.add(anArg);
                } while (anArg != null);
            }
            pResult.iSig = new MSignature(pResult.toString());
            return pResult;
        }

        boolean matches(ClpCmd aCmd) {
            boolean matches = true;
            MSignature copy = (MSignature)this.iSig.clone();
            String[] args = aCmd.reqdSignature().tokens();
            int i = 0;
            while (i < args.length && matches) {
                boolean removed = copy.remove(args[i]);
                if (!removed) {
                    matches = false;
                }
                ++i;
            }
            if (matches && copy.numTokens() > 0) {
                String[] tokens = copy.tokens();
                int i2 = 0;
                while (i2 < tokens.length && matches) {
                    if (!aCmd.optSignature().hasToken(tokens[i2])) {
                        matches = false;
                    }
                    ++i2;
                }
            }
            return matches;
        }

        void fill(ClpCmd cmd) {
            LinkedList<Arg> args = cmd.args();
            for (Arg arg : args) {
                arg.setSupplied(false);
            }
            for (Arg parsedArg : this.iParsedArgs) {
                Iterator parsedIter = parsedArg.options().iterator();
                Arg definedArg = cmd.arg(parsedArg.name());
                definedArg.setSupplied(true);
                Iterator definedIter = definedArg.options().iterator();
                while (parsedIter.hasNext()) {
                    Option parsedOption = (Option)parsedIter.next();
                    Option definedOption = (Option)definedIter.next();
                    definedOption.setValues(parsedOption.values());
                    definedOption.setQuotes(parsedOption.quotes());
                }
            }
        }

        boolean has(Arg arg) {
            boolean has = false;
            Iterator iter = this.iParsedArgs.iterator();
            while (!has && iter.hasNext()) {
                Arg anArg = (Arg)iter.next();
                has = arg.name().equalsIgnoreCase(anArg.name());
            }
            return has;
        }

        MString parsedString() throws Exception {
            int i;
            String[] values;
            MString str = new MString();
            for (Arg arg : this.iParsedArgs) {
                if (arg.isOptional()) continue;
                str.concat(arg.name());
                values = arg.optionValuesWithQuotes();
                if (values != null) {
                    str.concat(':');
                    i = 0;
                    while (i < values.length) {
                        if (i > 0) {
                            str.concat(',');
                        }
                        str.concat(values[i]);
                        ++i;
                    }
                }
                str.concat(' ');
            }
            for (Arg arg : this.iParsedArgs) {
                if (!arg.isOptional() || !arg.wasSupplied()) continue;
                str.concat(arg.name());
                values = arg.optionValuesWithQuotes();
                str.concat(':');
                i = 0;
                while (i < values.length) {
                    if (i > 0) {
                        str.concat(',');
                    }
                    str.concat(values[i]);
                    ++i;
                }
                str.concat(' ');
            }
            str.trimWhitespace();
            return str;
        }

        public String toString() {
            String text = "";
            int count = 0;
            for (Arg arg : this.iParsedArgs) {
                if (count++ > 0) {
                    text = String.valueOf(text) + " ";
                }
                text = String.valueOf(text) + arg.name();
            }
            return text.trim();
        }
    }

    public static abstract class PreCondition {
        private Clp iClp = null;

        public abstract String result() throws Exception;

        public Clp clp() {
            return this.iClp;
        }

        void setClp(Clp clp) {
            this.iClp = clp;
        }
    }
}

