/*
 * Decompiled with CFR 0.152.
 */
package clp;

import clp.ClpCmd;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import mlib.MAppMsg;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MSignature;
import mlib.MString;
import utilt.Utility;

public class Clp {
    private State iState = new State();
    private MLogging iLogger = new MLogger.System();
    private LinkedList<ClpCmd> iCmds = new LinkedList();
    private LinkedList<Instruction> iCmdQueue = new LinkedList();
    private String iCmdFilesRoot = "";
    private Stack<String> iNoEnds = new Stack();
    private static MAppMsg.Database AppMsgs = null;
    static Clp CurClp = null;
    static ClpCmd CurCmd = null;
    private static final String VERSION = "14-Jan-2026";
    public static final String PROGTITLE = "CLP version 14-Jan-2026";
    static final CmdUniquenessComparator CmdComparator = new CmdUniquenessComparator();
    static final ArgUniquenessComparator ArgComparator = new ArgUniquenessComparator();
    public static final char ANYVALUE = '*';
    public static final char NUMVALUE = '#';
    public static final char DISCRETEVALUE = '>';
    public static final char PARMVALUE = '@';
    public static final char ITEMDELIM = ',';
    public static final String TRUEOPT = "true";
    public static final String FALSEOPT = "false";
    public static final String ALLOPT = "all";
    public static final String ONOPT = "on";
    public static final String OFFOPT = "off";
    public static final String NONEOPT = "none";
    public static final String LOGFILENAME = "clplog.txt";
    static final char SYSTEMCMDPREFIX = '$';
    static final char HIDDENCMDPREFIX = '#';
    static final String SCRIPTARG = "script";
    static final String ALLARG = "all";
    static final char OPTIONPREFIX = ':';
    static final char COMMENTSTART = '[';
    static final char COMMENTEND = ']';
    static final int MINNAMELEN = 2;
    static final int MINITEMLEN = 1;
    static final String FILENAMEOPT = "filename";
    static final String FILEPATHOPT = "filepath";
    private static final String FILEEXT = ".clp";
    private static final String INITCMDFILE = "clpinit.clp";
    private static final String $PARMARG = "$parm";
    private static final String $STATEARG = "$state";
    private static final String $RESETARG = "$reset";
    private static final String $HELPARG = "$help";
    private static final String $ENDARG = "$end";
    private static final String $PUSHNOENDARG = "$pushnoend";
    private static final String $POPNOENDARG = "$popnoend";
    private static final String $DATEARG = "$date";
    private static final String $PREFIXARG = "$prefix";
    private static final String $VERSIONARG = "$version";
    private static final String REMOVEARG = "remove";
    private static final String PROMPT = "> ";
    private static final String SYSTEMPPROMPT = "$> ";
    private static final String CUSTOMOPT = "custom";

    static {
        try {
            Msgs.create();
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    static MAppMsg msg(String name) {
        return AppMsgs.get(name);
    }

    static void clpThrowError(String msg) throws Exception {
        MString work = new MString(msg);
        work.capFirstChar();
        throw new Exception(work.toString());
    }

    private static void substituteStateParms(ClpCmd matchingCmd) throws Exception {
        for (ClpCmd.Arg anArg : matchingCmd.args()) {
            LinkedList<ClpCmd.Option> options = anArg.options();
            for (ClpCmd.Option option : options) {
                LinkedList<MString> values = option.values();
                if (values == null) continue;
                for (MString value : values) {
                    MAppMsg msg;
                    if (value.charAt(0) != '@') continue;
                    value.trimHead('@');
                    Object stateParm = matchingCmd.clp().state().parm(value.toString());
                    if (stateParm == null) {
                        msg = Clp.msg("parm-not-found");
                        Clp.clpThrowError(msg.format(value.toString()));
                        continue;
                    }
                    if (stateParm instanceof String) {
                        value.assign((String)stateParm);
                        continue;
                    }
                    msg = Clp.msg("invalid-stateparm");
                    Clp.clpThrowError(msg.format(value.toString()));
                }
            }
        }
    }

    public Clp(State state, boolean logStart) throws Exception {
        CurClp = this;
        this.iState = state;
        if (!logStart) {
            this.iLogger = new MLogger.Empty();
        }
        this.iLogger.setLinked(new MLogger.File(LOGFILENAME, false));
        this.iLogger.writeln(PROGTITLE);
        this.iLogger.writeln("Loading basic commands:");
        this.addCmd(new EndCmd());
        this.addCmd(new ShowHelpCmd());
        this.addCmd(new SetParmCmd());
        this.addCmd(new PushNoEndCmd());
        this.addCmd(new PopNoEndCmd());
        this.addCmd(new ResetStateCmd());
        this.addCmd(new ShowStateCmd());
        this.addCmd(new ShowDateCmd());
        this.addCmd(new SetPrefixCmd());
        this.addCmd(new ShowVersionCmd());
        this.iLogger.writeln("Adding custom commands:");
    }

    public String name() {
        return this.getClass().getName();
    }

    public State state() {
        return this.iState;
    }

    public MLogging logger() {
        return this.iLogger;
    }

    public void setLogger(MLogging logger) throws Exception {
        this.iLogger = logger;
    }

    public void addCmd(ClpCmd cmd) throws Exception {
        String prefix = this.logger().prefix();
        this.logger().setPrefix("   " + prefix);
        this.logger().writeln(cmd.toString());
        this.logger().setPrefix(prefix);
        int result = 1;
        Iterator iter = this.iCmds.iterator();
        while (result != 0 && iter.hasNext()) {
            ClpCmd aCmd = (ClpCmd)iter.next();
            result = CmdComparator.compare(aCmd, cmd);
        }
        if (result == 0) {
            MAppMsg msg = AppMsgs.get("duplicate-cmd");
            Clp.clpThrowError(msg.format(cmd.desc()));
        }
        cmd.setClp(this);
        this.iCmds.add(cmd);
    }

    public void addCmds(Clp clp) throws Exception {
        for (ClpCmd aCmd : clp.iCmds) {
            this.addCmd(aCmd);
        }
    }

    public ClpCmd cmd(String desc) throws Exception {
        ClpCmd result = null;
        Iterator iter = this.iCmds.iterator();
        while (result == null && iter.hasNext()) {
            ClpCmd cmd = (ClpCmd)iter.next();
            if (!cmd.desc().equalsIgnoreCase(desc)) continue;
            result = cmd;
        }
        if (result == null) {
            MAppMsg msg = AppMsgs.get("cmd-not-found");
            Clp.clpThrowError(msg.format(desc));
        }
        return result;
    }

    public String cmdFilesRoot() {
        return this.iCmdFilesRoot;
    }

    public void processConsole(boolean startupHelp) throws Exception {
        int count = 0;
        this.check();
        BufferedReader stdio = new BufferedReader(new InputStreamReader(System.in));
        String[] block = new String[1];
        while (true) {
            if (startupHelp) {
                this.execLine($HELPARG);
                startupHelp = false;
            } else if (count == 0) {
                System.out.println("Enter $help for command list");
            } else {
                System.out.print("");
            }
            try {
                try {
                    System.out.print(SYSTEMPPROMPT);
                    block[0] = stdio.readLine();
                    this.execBlock("", block);
                }
                catch (Exception xcp) {
                    this.iLogger.writeln(Utility.xcpMsg(xcp));
                    ++count;
                    continue;
                }
            }
            catch (Throwable throwable) {
                ++count;
                throw throwable;
            }
            ++count;
        }
    }

    public void execLine(String line) throws Exception {
        String[] block = new String[]{line};
        this.execBlock("", block);
    }

    public void execBlock(String name, String[] lines) throws Exception {
        this.addToQueue(name, lines);
        String msg = this.doCmdQueue();
        if (msg != null) {
            this.iLogger.writeln(msg);
        }
    }

    public void execFile(String relPath) throws Exception {
        InputStream stream = this.scriptStream(relPath);
        if (stream == null) {
            MAppMsg msg = AppMsgs.get("cmdfile-not-found");
            throw new Exception(msg.format(relPath));
        }
        LinkedList<String> list = Utility.readTextFileFromStream(stream);
        stream.close();
        String[] lines = list.toArray(new String[list.size()]);
        this.execBlock(relPath, lines);
    }

    public String toString() {
        String str = String.valueOf(this.name()) + ": " + this.iCmds.size() + " commands, scripts root:" + this.iCmdFilesRoot;
        return str;
    }

    void setState(State state) {
        this.iState = state;
    }

    void setScriptsRoot(File file) throws Exception {
        if (!file.isDirectory()) {
            MAppMsg msg = AppMsgs.get("invalid-root");
            Clp.clpThrowError(msg.format(file.getAbsolutePath()));
        } else {
            this.iCmdFilesRoot = file.getAbsolutePath();
            if (!this.iCmdFilesRoot.endsWith(File.separator)) {
                this.iCmdFilesRoot = String.valueOf(this.iCmdFilesRoot) + File.separator;
            }
            this.iState.putSysParm("$rootfolder", this.iCmdFilesRoot);
        }
    }

    void runInitScript() throws Exception {
        InputStream stream = this.scriptStream(INITCMDFILE);
        if (stream != null) {
            LinkedList<String> list = Utility.readTextFileFromStream(stream);
            stream.close();
            String[] lines = list.toArray(new String[list.size()]);
            this.execBlock(INITCMDFILE, lines);
        }
    }

    void runStartScript(String name) throws Exception {
        InputStream stream = this.scriptStream(name);
        if (stream != null) {
            LinkedList<String> list = Utility.readTextFileFromStream(stream);
            stream.close();
            String[] lines = list.toArray(new String[list.size()]);
            this.execBlock(name, lines);
        } else {
            MAppMsg msg = AppMsgs.get("cmdfile-not-found");
            Clp.clpThrowError(msg.format(name));
        }
    }

    protected void check() throws Exception {
        Clp clp = null;
        for (ClpCmd cmd : this.iCmds) {
            if (clp == null) {
                clp = cmd.clp();
                continue;
            }
            if (clp == cmd.clp()) continue;
            MAppMsg msg = AppMsgs.get("diff-clps");
            Clp.clpThrowError(msg.format(clp.name(), cmd.clp().name()));
        }
    }

    private InputStream scriptStream(String path) {
        FileInputStream stream = null;
        try {
            if (!path.endsWith(FILEEXT)) {
                path = String.valueOf(path) + FILEEXT;
            }
            if (!path.startsWith(File.separator)) {
                path = String.valueOf(this.iCmdFilesRoot) + path;
            }
            stream = new FileInputStream(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stream;
    }

    private String doCmdQueue() throws Exception {
        String errMsg = null;
        while (this.iCmdQueue.size() > 0 && errMsg == null) {
            Instruction instr = this.iCmdQueue.getFirst();
            String prefix = String.valueOf(instr.block()) + PROMPT;
            if (!prefix.equals(PROMPT)) {
                int index;
                String parm = (String)this.state().parm($PREFIXARG);
                if (parm.equals(NONEOPT)) {
                    prefix = "";
                } else if (parm.equals(FILENAMEOPT) && (index = prefix.lastIndexOf(File.separator)) > 0) {
                    prefix = prefix.substring(index + 1);
                }
            }
            this.iLogger.setPrefix(prefix);
            if (instr.line().length() == 0 || instr.line().charAt(0) == '[') {
                this.iCmdQueue.removeFirst();
                continue;
            }
            this.iCmdQueue.removeFirst();
            try {
                ClpCmd.ParsingResult pResult = ClpCmd.ParsingResult.parseLine(instr.line());
                this.logger().writeln(pResult.parsedString().toString());
                ClpCmd matchingCmd = null;
                Iterator cmds = this.iCmds.iterator();
                while (matchingCmd == null && cmds.hasNext()) {
                    ClpCmd aCmd = (ClpCmd)cmds.next();
                    if (!pResult.matches(aCmd)) continue;
                    matchingCmd = aCmd;
                    pResult.fill(matchingCmd);
                }
                if (matchingCmd != null) {
                    instr.setCmd(matchingCmd);
                    Clp.substituteStateParms(matchingCmd);
                    matchingCmd.doPreConds();
                    instr.execute();
                    continue;
                }
                errMsg = this.tryFile(pResult.parsedString().toString());
            }
            catch (PreConditionXcp xcp) {
                errMsg = Utility.xcpMsg(xcp);
            }
            catch (Exception xcp) {
                MAppMsg msg = AppMsgs.get("runtime-error");
                errMsg = msg.format(Utility.xcpMsg(xcp));
            }
        }
        if (errMsg != null) {
            this.iCmdQueue.clear();
        }
        return errMsg;
    }

    private String tryFile(String line) throws Exception {
        String errMsg = null;
        InputStream stream = null;
        stream = this.scriptStream(line);
        if (stream != null) {
            line = String.valueOf(line) + FILEEXT;
            LinkedList<String> list = Utility.readTextFileFromStream(stream);
            stream.close();
            String[] lines = list.toArray(new String[list.size()]);
            this.addToQueue(line, lines);
        } else {
            MAppMsg msg = AppMsgs.get("invalid-cmd");
            errMsg = msg.format(line);
        }
        return errMsg;
    }

    void addToQueue(String name, String[] lines) {
        int i = lines.length - 1;
        while (i >= 0) {
            String line = lines[i].trim();
            if (line.length() > 0) {
                this.iCmdQueue.addFirst(new Instruction(line, name));
            }
            --i;
        }
    }

    static class ArgUniquenessComparator
    implements Comparator<ClpCmd.Arg> {
        ArgUniquenessComparator() {
        }

        @Override
        public int compare(ClpCmd.Arg arg1, ClpCmd.Arg arg2) {
            return arg1.name().compareTo(arg2.name());
        }

        public boolean equals(ClpCmd.Arg arg1, ClpCmd.Arg arg2) {
            return this.compare(arg1, arg2) == 0;
        }
    }

    static class CmdUniquenessComparator
    implements Comparator<ClpCmd> {
        CmdUniquenessComparator() {
        }

        @Override
        public int compare(ClpCmd cmd1, ClpCmd cmd2) {
            int result = 1;
            boolean equals = cmd1.reqdSignature().equals(cmd2.reqdSignature());
            if (equals) {
                result = 0;
            }
            if (result == 0) {
                result = CmdUniquenessComparator.compareArgOptions(cmd1, cmd2);
            }
            return result;
        }

        public boolean equals(ClpCmd cmd1, ClpCmd cmd2) {
            return this.compare(cmd1, cmd2) == 0;
        }

        private static int compareArgOptions(ClpCmd cmd1, ClpCmd cmd2) {
            int sameCount = 0;
            String[] argNames = cmd1.reqdSignature().tokens();
            int i = 0;
            while (i < argNames.length) {
                MSignature options2;
                ClpCmd.Arg arg1 = cmd1.arg(argNames[i]);
                ClpCmd.Arg arg2 = cmd2.arg(argNames[i]);
                MSignature options1 = arg1.optionsSignature();
                if (options1.equals(options2 = arg2.optionsSignature())) {
                    ++sameCount;
                }
                ++i;
            }
            int result = argNames.length - sameCount;
            return result;
        }
    }

    public static class DynamicCmd {
        private Clp iClp = null;
        private String iName = "";
        private MString iCmdStr = new MString();
        private LinkedList<String> iArgNames = new LinkedList();

        public DynamicCmd(Clp clp, String name) throws Exception {
            this.iClp = clp;
            this.iName = name;
        }

        public String name() {
            return this.iName;
        }

        public void addArg(String argName, String value, boolean isDelimitedValue) throws Exception {
            boolean added = this.iArgNames.add(argName);
            if (!added) {
                MAppMsg msg = AppMsgs.get("duplicate-arg");
                Clp.clpThrowError(msg.format(argName));
            }
            if (this.iCmdStr.length() > 0 && !this.iCmdStr.endsWith(' ')) {
                this.iCmdStr.concat(' ');
            }
            this.iCmdStr.concat(argName);
            if (value != null) {
                this.iCmdStr.concat(':');
                if (isDelimitedValue) {
                    this.iCmdStr.concat("\"" + value + "\"" + ' ');
                } else {
                    this.iCmdStr.concat(String.valueOf(value) + ' ');
                }
            }
        }

        public void execute() throws Exception {
            this.iClp.execLine(this.iCmdStr.trimWhitespace().toString());
        }

        public String toString() {
            return this.iCmdStr.toString();
        }
    }

    private class EndCmd
    extends ClpCmd {
        public EndCmd() throws Exception {
            super("end CLP");
            this.add(new ClpCmd.Arg(Clp.$ENDARG, false));
            this.add(new ClpCmd.Arg("all", true));
        }

        @Override
        public void execute() throws Exception {
            if (Clp.this.iNoEnds.size() == 0) {
                System.exit(0);
            } else if (this.supplied("all")) {
                Clp.this.iNoEnds.clear();
                System.exit(0);
            }
        }
    }

    private class Instruction {
        private String iLine = null;
        private String iBlock = "";
        private ClpCmd iCmd = null;

        Instruction(String line, String block) {
            this.iLine = line;
            this.iBlock = block;
        }

        String line() {
            return this.iLine;
        }

        void setCmd(ClpCmd cmd) {
            this.iCmd = cmd;
        }

        String block() {
            return this.iBlock;
        }

        void execute() throws Exception {
            String prefix = Clp.this.iLogger.prefix();
            try {
                this.iCmd.execute();
            }
            finally {
                Clp.this.iLogger.setPrefix(prefix);
            }
        }

        public String toString() {
            return String.valueOf(this.iBlock) + ": " + this.iLine;
        }
    }

    static class Msgs {
        static final String INVALID_CMD = "invalid-cmd";
        static final String INVALID_ARG = "invalid-arg";
        static final String INVALID_ARG_NAME = "invalid-arg-name";
        static final String DUPLICATE_CMD = "duplicate-cmd";
        static final String DUPLICATE_CMD_DESC = "duplicate-cmd-desc";
        static final String DUPLICATE_OPTION = "duplicate-option";
        static final String DUPLICATE_ITEM = "duplicate-item";
        static final String DUPLICATE_ARG = "duplicate-arg";
        static final String INVALID_ITEM = "invalid-item";
        static final String OPTION_NOT_STATEPARM = "option-not-parm";
        static final String INVALID_ROOT = "invalid-root";
        static final String INVALID_DISCRETE_OPTION = "invalid-disc-option";
        static final String INVALID_OPTION = "invalid-option";
        static final String INVALID_STATEPARM = "invalid-stateparm";
        static final String CMD_DESC_EMPTY = "cmd-desc-empty";
        static final String CMD_NOT_FOUND = "cmd-not-found";
        static final String STATEPARM_NOT_FOUND = "parm-not-found";
        static final String FAILED_PRECOND = "failed-precond";
        static final String INVALID_STATE_OPERATION = "invalid-state-operation";
        static final String DIFF_CLPS = "diff-clps";
        static final String EMPTY_OPTION = "empty-option";
        static final String ARG_NOT_FOUND = "arg-not-found";
        static final String NO_TYPEINDICATOR = "no-typeindicator";
        static final String NULL_PRECOND = "null-precond";
        static final String CMDFILE_NOT_FOUND = "cmdfile-not-found";
        static final String RUNTIME_ERROR = "runtime-error";

        Msgs() {
        }

        static void create() throws Exception {
            AppMsgs = new MAppMsg.Database();
            AppMsgs.add(new MAppMsg(INVALID_CMD, "Command not recognized and command file not found: %1", true));
            AppMsgs.add(new MAppMsg(DUPLICATE_CMD, "Duplicate command: %1", true));
            AppMsgs.add(new MAppMsg(DUPLICATE_CMD_DESC, "Duplicate command description: %1", true));
            AppMsgs.add(new MAppMsg(DUPLICATE_OPTION, "Duplicate option: argument %1, option %2", true));
            AppMsgs.add(new MAppMsg(DUPLICATE_ITEM, "Duplicate option item: %1", true));
            AppMsgs.add(new MAppMsg(DUPLICATE_ARG, "Duplicate argument: %1, %2", true));
            AppMsgs.add(new MAppMsg(INVALID_ARG_NAME, "Argument name must not begin with type indicator: %1, %2", true));
            AppMsgs.add(new MAppMsg(INVALID_ARG, "Argument length must >= 2: %1, %2", true));
            AppMsgs.add(new MAppMsg(INVALID_ITEM, "Item length must >= 1: %1", true));
            AppMsgs.add(new MAppMsg(INVALID_DISCRETE_OPTION, "Discrete option must have only one item: %1", true));
            AppMsgs.add(new MAppMsg(INVALID_OPTION, "Invalid argument option %1: %2", true));
            AppMsgs.add(new MAppMsg(INVALID_STATEPARM, "State parameter accessed by @ option must be a string: %1", true));
            AppMsgs.add(new MAppMsg(NO_TYPEINDICATOR, "Missing type indicator for option %1 for command: %2", true));
            AppMsgs.add(new MAppMsg(CMD_DESC_EMPTY, "Command description empty: %1", true));
            AppMsgs.add(new MAppMsg(CMD_NOT_FOUND, "Command not found: %1", true));
            AppMsgs.add(new MAppMsg(STATEPARM_NOT_FOUND, "State parameter not found: %1", true));
            AppMsgs.add(new MAppMsg(FAILED_PRECOND, "Failed pre-condition: %1", true));
            AppMsgs.add(new MAppMsg(INVALID_ROOT, "Invalid scripts root: %1", true));
            AppMsgs.add(new MAppMsg(INVALID_STATE_OPERATION, "Can not change system state parameter: %1", true));
            AppMsgs.add(new MAppMsg(DIFF_CLPS, "CLP must be the same for all commands: %1, %2", true));
            AppMsgs.add(new MAppMsg(EMPTY_OPTION, "No option found", true));
            AppMsgs.add(new MAppMsg(NULL_PRECOND, "Attempt to add null precondition: %1", true));
            AppMsgs.add(new MAppMsg(CMDFILE_NOT_FOUND, "Command file not found: %1", true));
            AppMsgs.add(new MAppMsg(RUNTIME_ERROR, "Runtime error: %1", true));
        }
    }

    private class PopNoEndCmd
    extends ClpCmd {
        public PopNoEndCmd() throws Exception {
            super("pop ignore $end");
            this.add(new ClpCmd.Arg(Clp.$POPNOENDARG, false));
        }

        @Override
        public void execute() throws Exception {
            Clp.this.iNoEnds.pop();
            String prefix = Clp.this.logger().prefix();
            Clp.this.logger().setPrefix(String.valueOf(prefix) + "   ");
            Clp.this.logger().writeln("Stack size: " + Clp.this.iNoEnds.size());
            Clp.this.logger().setPrefix(prefix);
            Clp.this.iState.putSysParm("$noends", Clp.this.iNoEnds.size());
        }
    }

    static class PreConditionXcp
    extends Exception {
        PreConditionXcp(String msg) {
            super(msg);
        }
    }

    private class PushNoEndCmd
    extends ClpCmd {
        public PushNoEndCmd() throws Exception {
            super("push ignore $end");
            this.add(new ClpCmd.Arg(Clp.$PUSHNOENDARG, false));
        }

        @Override
        public void execute() throws Exception {
            Clp.this.iNoEnds.push("noend");
            String prefix = Clp.this.logger().prefix();
            Clp.this.logger().setPrefix(String.valueOf(prefix) + "   ");
            Clp.this.logger().writeln("Stack size: " + Clp.this.iNoEnds.size());
            Clp.this.logger().setPrefix(prefix);
            Clp.this.iState.putSysParm("$noends", Clp.this.iNoEnds.size());
        }
    }

    private class ResetStateCmd
    extends ClpCmd {
        public ResetStateCmd() throws Exception {
            super("reset state parameters");
            this.add(new ClpCmd.Arg(Clp.$RESETARG, false));
            ClpCmd.Arg arg = this.arg(Clp.$RESETARG);
            arg.add(new ClpCmd.Option(">all"));
            arg.add(new ClpCmd.Option(">custom"));
        }

        @Override
        public void execute() throws Exception {
            String option = this.arg(Clp.$RESETARG).firstOptionValue();
            if (option.equalsIgnoreCase("all")) {
                this.clp().state().resetParms();
            } else {
                this.clp().state().resetCustomParms();
            }
        }
    }

    private class SetParmCmd
    extends ClpCmd {
        public SetParmCmd() throws Exception {
            super("set or remove state parameter");
            this.add(new ClpCmd.Arg(Clp.$PARMARG, false));
            ClpCmd.Arg arg = this.arg(Clp.$PARMARG);
            arg.add(new ClpCmd.Option("*parm name,*parm value"));
            arg.add(new ClpCmd.Option("*parm name"));
            this.add(new ClpCmd.Arg(Clp.REMOVEARG, true));
        }

        @Override
        public void execute() throws Exception {
            String[] values = this.arg(Clp.$PARMARG).optionValues();
            String value2 = "";
            if (values.length == 2) {
                value2 = values[1];
            }
            if (this.supplied(Clp.REMOVEARG)) {
                String parm = this.arg(Clp.$PARMARG).firstOptionValue();
                this.clp().state().removeParm(parm);
            } else {
                this.clp().state().putParm(values[0], value2);
            }
        }
    }

    private class SetPrefixCmd
    extends ClpCmd {
        private SetPrefixCmd() throws Exception {
            super("set command file prefix for logger");
            this.add(new ClpCmd.Arg(Clp.$PREFIXARG, false));
            ClpCmd.Arg arg = this.arg(Clp.$PREFIXARG);
            arg.add(new ClpCmd.Option(">none"));
            arg.add(new ClpCmd.Option(">filename"));
            arg.add(new ClpCmd.Option(">filepath"));
        }

        @Override
        public void execute() throws Exception {
            String option = this.arg(Clp.$PREFIXARG).firstOptionValue();
            this.clp().state().putSysParm(Clp.$PREFIXARG, option);
        }
    }

    private class ShowDateCmd
    extends ClpCmd {
        public ShowDateCmd() throws Exception {
            super("show date/time");
            this.add(new ClpCmd.Arg(Clp.$DATEARG, false));
        }

        @Override
        public void execute() throws Exception {
            GregorianCalendar now = new GregorianCalendar();
            Clp.this.logger().writeln(now.getTime().toString(), false);
        }
    }

    private class ShowHelpCmd
    extends ClpCmd {
        private ShowHelpCmd() throws Exception {
            super("list commands");
            this.add(new ClpCmd.Arg(Clp.$HELPARG, false));
        }

        @Override
        public void execute() throws Exception {
            String prefix = Clp.this.iLogger.prefix();
            Clp.this.iLogger.setPrefix(String.valueOf(prefix) + "   ");
            TreeSet<ClpCmd> ordered = new TreeSet<ClpCmd>(new ClpCmd.CmdOrderer());
            ordered.addAll(Clp.this.iCmds);
            Clp.this.iLogger.writeln("Commands:", false);
            for (ClpCmd cmd : ordered) {
                Clp.this.iLogger.writeln(cmd.toString(), false);
            }
            Clp.this.iLogger.setPrefix(prefix);
        }
    }

    private class ShowStateCmd
    extends ClpCmd {
        public ShowStateCmd() throws Exception {
            super("list state parameters");
            this.add(new ClpCmd.Arg(Clp.$STATEARG, false));
        }

        @Override
        public void execute() throws Exception {
            String prefix = Clp.this.iLogger.prefix();
            Clp.this.iLogger.setPrefix(String.valueOf(prefix) + "   ");
            TreeMap<String, Object> parms = this.clp().state().parms();
            Set<Map.Entry<String, Object>> mappings = parms.entrySet();
            for (Map.Entry<String, Object> entry : mappings) {
                Object obj = entry.getValue();
                if (obj instanceof String || obj instanceof MString) {
                    Clp.this.logger().writeln(String.valueOf(entry.getKey()) + ":" + entry.getValue(), false);
                    continue;
                }
                Clp.this.iLogger.writeln(String.valueOf(entry.getKey()) + ":" + obj.toString(), false);
            }
            Clp.this.iLogger.setPrefix(prefix);
        }
    }

    private class ShowVersionCmd
    extends ClpCmd {
        public ShowVersionCmd() throws Exception {
            super("show CLP version");
            this.add(new ClpCmd.Arg(Clp.$VERSIONARG, false));
        }

        @Override
        public void execute() throws Exception {
            Clp.this.logger().writeln(Clp.PROGTITLE);
        }
    }

    public static class State {
        private TreeMap<String, Object> iParms = new TreeMap();
        public static final String PREFIXPARM = "$prefix";
        public static final String ROOTPARM = "$rootfolder";
        public static final String NOENDSPARM = "$noends";

        public State() {
            this.resetParms();
        }

        public void putParm(String name, Object parm) throws Exception {
            if ((name = name.trim()).charAt(0) == '$') {
                MAppMsg msg = AppMsgs.get("invalid-state-operation");
                Clp.clpThrowError(msg.format(name));
            } else {
                this.iParms.put(name.toLowerCase(), parm);
            }
        }

        public Object parm(String name) {
            return this.iParms.get(name.toLowerCase());
        }

        public void removeParm(String name) throws Exception {
            if (name.trim().charAt(0) == '$') {
                MAppMsg msg = AppMsgs.get("invalid-state-operation");
                Clp.clpThrowError(msg.format(name));
            } else {
                this.iParms.remove(name.toLowerCase());
            }
        }

        public void resetParms() {
            this.iParms.clear();
            this.iParms.put("$prefix", Clp.FILENAMEOPT);
            this.iParms.put(ROOTPARM, System.getProperty("user.dir"));
            if (CurClp == null) {
                this.iParms.put(NOENDSPARM, 0);
            } else {
                this.iParms.put(NOENDSPARM, CurClp.iNoEnds.size());
            }
            this.resetCustomParms();
        }

        public void resetCustomParms() {
        }

        public String toString() {
            MString str = new MString("parms:\r\n");
            Set<Map.Entry<String, Object>> mappings = this.iParms.entrySet();
            int count = 0;
            for (Map.Entry<String, Object> entry : mappings) {
                Object obj;
                if (count++ == 0) {
                    str.concat("\r\n");
                }
                if ((obj = entry.getValue()) instanceof String || obj instanceof MString) {
                    str.concat("   " + entry.getKey() + ":" + entry.getValue());
                    continue;
                }
                String name = obj.getClass().getName();
                str.concat("   " + entry.getKey() + ":" + name);
            }
            return str.toString();
        }

        void putSysParm(String name, Object parm) throws Exception {
            name = name.trim();
            this.iParms.put(name, parm);
        }

        TreeMap<String, Object> parms() {
            return this.iParms;
        }
    }
}

