/*
 * Decompiled with CFR 0.152.
 */
package clp;

import clp.Clp;
import java.io.File;
import mlib.MConsoleApp;

public abstract class AbstractClpConsole
extends MConsoleApp {
    private Clp iClp = null;
    static final String CMDFILESROOTARG = "rootdir";
    static final String STARTCMDFILEARG = "startfile";
    static final String HELPARG = "showhelp";

    public AbstractClpConsole(String progTitle, Clp clp) throws Exception {
        super(progTitle);
        this.iClp = clp;
        this.progArgs().removeAllArgs();
        String root = System.getProperty("user.dir");
        this.progArgs().addArg(CMDFILESROOTARG, "Path of root folder for command files", root, false, 1, 1);
        this.progArgs().addArg(STARTCMDFILEARG, "Startup command file", null, false, 1, 1);
        this.progArgs().addArg(HELPARG, "Show help at startup", null, false, 0, 0);
    }

    public Clp clp() {
        return this.iClp;
    }

    public void setup() throws Exception {
    }

    @Override
    protected void process() throws Exception {
        super.process();
        String root = this.progArgs().argValue(CMDFILESROOTARG, 0);
        if (root == null) {
            root = System.getProperty("user.dir");
        }
        this.iClp.setScriptsRoot(new File(root));
        this.logger().writeln(this.iClp.toString(), false);
        this.iClp.runInitScript();
        if (this.progArgs().argSupplied(STARTCMDFILEARG)) {
            String name = this.progArgs().argValue(STARTCMDFILEARG, 0);
            this.iClp.runStartScript(name);
        }
        boolean startupHelp = this.progArgs().argSupplied(HELPARG);
        this.iClp.processConsole(startupHelp);
    }
}

