/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.AppearancePanel;
import chart.Chart;
import chart.ChartPanel;
import filedialog.FileChooser;
import filedialog.FileChooserFilter;
import filedialog.FilePopupObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mlib.MWildcard;
import mswing.Preferences;
import swing.ColorButton;
import swing.ColorPanel;
import swing.StatusBox;
import swing.StdScrollPane;
import swing.SwingProgram;
import utilt.Utility;

public class Viewer
extends SwingProgram {
    private JTabbedPane iTabbedPane = new JTabbedPane();
    private FileChooser iChooser = null;
    private ColorButton iEditButton = null;
    private LinkedList<TabPanel> iPanels = new LinkedList();
    private static Viewer Singleton = null;
    public static final String PROGNAME = "Chart Viewer Program";
    public static final String VERSION = "5-Apr-2022";
    private static final String PROGTITLE = "Chart Viewer Program version 5-Apr-2022";
    private static final String DIRARG = "d";
    private static final String RECURSEARG = "r";
    private static final String[] CHARTEXTS = new String[]{".cht"};

    public static Viewer singleton() {
        return Singleton;
    }

    public static void main(String[] args) {
        try {
            Viewer viewer = new Viewer();
            if (viewer.parseArgs(args)) {
                viewer.start();
            }
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public void close(AppearancePanel panel) {
        boolean found = false;
        Iterator iter = this.iPanels.iterator();
        while (!found && iter.hasNext()) {
            TabPanel tabPanel = (TabPanel)iter.next();
            boolean bl = found = tabPanel.iAppearancePanel == panel;
            if (!found) continue;
            tabPanel.reset();
        }
    }

    private ColorPanel mainPanel() {
        ColorPanel main = new ColorPanel();
        main.setLayout(new BorderLayout());
        main.add((Component)this.iTabbedPane, "Center");
        ColorPanel top = new ColorPanel();
        top.setLayout(new BoxLayout(top, 0));
        ColorButton openButton = new ColorButton(" Open ");
        openButton.addActionListener(new FileHandler());
        top.add(openButton);
        this.iEditButton = new ColorButton(" Edit ");
        this.iEditButton.setEnabled(false);
        this.iEditButton.addActionListener(new EditHandler());
        top.add(this.iEditButton);
        ColorButton closeButton = new ColorButton(" Close ");
        closeButton.addActionListener(new CloseHandler());
        top.add(closeButton);
        top.add(StatusBox.singleton());
        top.setBorder(SwingProgram.STDBORDER);
        main.add((Component)top, "North");
        return main;
    }

    private void start() throws Exception {
        this.setVisible(true);
        if (this.progArgs().argSupplied(DIRARG)) {
            Chart chart;
            File dir = new File(this.progArgs().argValue(DIRARG, 0).trim());
            LinkedList<File> files = new LinkedList<File>();
            boolean recurse = this.progArgs().argSupplied(RECURSEARG);
            Utility.obtainFiles(files, new MWildcard("*.cht"), dir, recurse);
            TreeMap ordered = new TreeMap(Collections.reverseOrder());
            for (File file : files) {
                chart = Chart.read(file.getAbsolutePath());
                ordered.put(chart.title(), chart);
                StatusBox.singleton().showMsg("Opened: " + file.getAbsolutePath(), false);
            }
            for (Map.Entry entry : ordered.entrySet()) {
                chart = (Chart)entry.getValue();
                this.showChart(chart);
            }
            this.iTabbedPane.addChangeListener(new TabbedHandler());
        }
    }

    private void showChart(Chart chart) throws Exception {
        ChartPanel chartPanel = new ChartPanel(chart);
        TabPanel tabPanel = new TabPanel(chartPanel);
        this.iTabbedPane.addTab(chart.title(), null, tabPanel, null);
        this.iPanels.add(tabPanel);
        chartPanel.repaint();
        this.iEditButton.setEnabled(true);
    }

    private Viewer() throws Exception {
        super(PROGTITLE);
        this.setTitle(PROGNAME);
        this.addWindowListener(new WindowHandler());
        this.setExtendedState(6);
        StatusBox.singleton().showMsg(Utility.javaEnv(), false);
        StatusBox.singleton().showMsg(PROGTITLE, false);
        String curDir = System.getProperty("user.dir");
        this.progArgs().addArg(DIRARG, "Charts directory", curDir, false, 1, 1);
        this.progArgs().addArg(RECURSEARG, "Recurse to child directories", curDir, false, 1, 1);
        this.getContentPane().add(this.mainPanel());
        Singleton = this;
    }

    private class ChooserHandler
    implements FileChooser.Listener {
        private ChooserHandler() {
        }

        @Override
        public void selected(FileChooser.Event event) {
            LinkedList<FilePopupObject> selections = event.selections();
            if (selections != null && selections.size() > 0) {
                FilePopupObject obj = selections.getFirst();
                try {
                    Chart chart = Chart.read(obj.getName());
                    StatusBox.singleton().showMsg("Read chart: " + obj.getName(), false);
                    Viewer.this.showChart(chart);
                }
                catch (Exception xcp) {
                    StatusBox.singleton().showMsg(xcp.toString(), true);
                }
            }
        }

        @Override
        public void message(FileChooser.Event event) {
            StatusBox.singleton().showMsg(event.msg(), false);
        }
    }

    private class CloseHandler
    implements ActionListener {
        private CloseHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabPanel tabPanel = (TabPanel)Viewer.this.iTabbedPane.getSelectedComponent();
            Viewer.this.iTabbedPane.remove(tabPanel);
        }
    }

    private class EditHandler
    implements ActionListener {
        private EditHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabPanel tabPanel = (TabPanel)Viewer.this.iTabbedPane.getSelectedComponent();
            tabPanel.showAppearance();
        }
    }

    private class FileHandler
    implements ActionListener {
        private FileHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FileChooserFilter filter = new FileChooserFilter(CHARTEXTS, false, true, "chart files");
            Preferences pref = new Preferences();
            Viewer.this.iChooser = new FileChooser(new Preferences(), filter, false, false, false, Viewer.this, false);
            Viewer.this.iChooser.center(0.7, 0.7);
            Viewer.this.iChooser.setFont(pref.menuFont());
            Viewer.this.iChooser.addListener(new ChooserHandler());
            Viewer.this.iChooser.setTitle("Select chart");
            Viewer.this.iChooser.setVisible(true);
        }
    }

    private class TabPanel
    extends ColorPanel {
        private ChartPanel iChartPanel = null;
        private AppearancePanel iAppearancePanel = null;

        public TabPanel(ChartPanel chartPanel) {
            this.iChartPanel = chartPanel;
            this.setLayout(new BorderLayout());
            this.add((Component)chartPanel, "Center");
        }

        public void showAppearance() {
            if (this.iAppearancePanel == null) {
                this.iAppearancePanel = new AppearancePanel(Viewer.this, this.iChartPanel);
            }
            this.removeAll();
            this.add((Component)this.iChartPanel, "Center");
            this.add((Component)new StdScrollPane(this.iAppearancePanel), "East");
            this.validate();
        }

        public void reset() {
            this.removeAll();
            this.add((Component)this.iChartPanel, "Center");
            this.iChartPanel.repaint();
            this.validate();
        }
    }

    private class TabbedHandler
    implements ChangeListener {
        private TabbedHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            TabPanel tabPanel = (TabPanel)Viewer.this.iTabbedPane.getSelectedComponent();
            tabPanel.reset();
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }
    }
}

