/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Chart;
import chart.ChartPanel;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import math.Dataset;
import math.XYpoint;
import mswing.StdColor;

public class ScatterDrawer
extends ChartPanel.Drawer {
    private static ScatterDrawer Singleton = new ScatterDrawer();
    public static final int MAXPOINTSIZE = 30;
    private static final int MINPOINTSIZE = 3;

    public static ScatterDrawer singleton() {
        return Singleton;
    }

    private static int pointSize(Chart chart, ChartPanel panel, Collection<Dataset.List<XYpoint.Float>> sets) {
        Chart.ScatterAppearance app = (Chart.ScatterAppearance)chart.appearance();
        int size = app.getMinPointSize();
        if (size == 0) {
            int width = panel.getWidth();
            int count = 0;
            for (Dataset.List<XYpoint.Float> set : sets) {
                count += set.size();
            }
            size = 2 * width / count;
            if (size < 3) {
                size = 3;
            } else if (size > 30) {
                size = 30;
            }
            int rem = size % 2;
            if (rem > 0) {
                ++size;
            }
        }
        return size;
    }

    @Override
    public void draw(Chart chart, ChartPanel panel, Graphics2D g2) throws Exception {
        g2.setStroke(new BasicStroke(1.0f));
        Chart.ScatterAppearance app = (Chart.ScatterAppearance)chart.appearance();
        DecimalFormat xFormat = new DecimalFormat(app.xScalesFormat());
        DecimalFormat yFormat = new DecimalFormat(app.yScalesFormat());
        Collection<Dataset.List<XYpoint.Float>> sets = chart.sets();
        int pointSize = ScatterDrawer.pointSize(chart, panel, sets);
        int pointOffset = pointSize / 2;
        boolean showDot = app.isShowCenterDot();
        for (Dataset.List<XYpoint.Float> set : sets) {
            Iterator<XYpoint.Float> iter = set.iterator();
            while (iter.hasNext()) {
                Rectangle2D.Float dot;
                XYpoint.Float point = iter.next();
                StdColor color = point.stdColor();
                if (color == null) {
                    color = app.defaultItemColor();
                }
                g2.setPaint(color.color());
                float drawX = panel.xPos(point) - (float)pointOffset;
                float drawY = panel.yPos(point) - (float)pointOffset;
                Chart.ScatterAppearance.Type type = point.getChartType();
                if (type == null) {
                    type = app.type();
                }
                if (point.getChartType() != null) {
                    type = point.getChartType();
                }
                RectangularShape fullShape = null;
                if (type.equals(Chart.ScatterAppearance.Type.SOLIDSQUARE)) {
                    fullShape = new Rectangle2D.Float(drawX, drawY, pointSize, pointSize);
                    g2.fill(fullShape);
                    g2.setPaint(app.chartColor().color());
                    if (showDot) {
                        dot = new Rectangle2D.Float(drawX + (float)pointOffset, drawY + (float)pointOffset, 1.0f, 1.0f);
                        g2.draw(dot);
                    }
                } else if (type.equals(Chart.ScatterAppearance.Type.OPENSQUARE)) {
                    fullShape = new Rectangle2D.Float(drawX, drawY, pointSize, pointSize);
                    g2.draw(fullShape);
                    if (showDot) {
                        dot = new Rectangle2D.Float(drawX + (float)pointOffset, drawY + (float)pointOffset, 1.0f, 1.0f);
                        g2.draw(dot);
                    }
                } else if (type.equals(Chart.ScatterAppearance.Type.SOLIDCIRCLE)) {
                    fullShape = new Ellipse2D.Float(drawX, drawY, pointSize, pointSize);
                    g2.fill(fullShape);
                    g2.setPaint(chart.appearance().chartColor().color());
                    if (showDot) {
                        dot = new Rectangle2D.Float(drawX + (float)pointOffset, drawY + (float)pointOffset, 1.0f, 1.0f);
                        g2.draw(dot);
                    }
                } else {
                    fullShape = new Ellipse2D.Float(drawX, drawY, pointSize, pointSize);
                    g2.draw(fullShape);
                    if (showDot) {
                        dot = new Rectangle2D.Float(drawX + (float)pointOffset, drawY + (float)pointOffset, 1.0f, 1.0f);
                        g2.draw(dot);
                    }
                }
                if (point.getHover() == null) {
                    point.setHover(String.valueOf(point.label()) + ": " + xFormat.format(point.x()) + " , " + yFormat.format(point.y()));
                }
                if (point.yUncer() > 0.0) {
                    XYpoint.Float diff = new XYpoint.Float((float)point.x(), (float)point.y() + (float)point.yUncer(), null);
                    float uncerHeight = Math.abs((drawY += (float)pointOffset) - panel.yPos(diff));
                    g2.drawLine((int)(drawX += (float)pointOffset), (int)drawY + (int)uncerHeight, (int)drawX, (int)(drawY - uncerHeight));
                    point.setHover(String.valueOf(point.getHover()) + "\u00b1" + xFormat.format(point.yUncer()));
                }
                panel.hoverMgr().add(set.name(), point.getHover(), fullShape);
            }
        }
    }

    @Override
    public boolean yMinAlwaysZero() {
        return false;
    }

    private ScatterDrawer() {
    }
}

