/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.DisplayFiller;
import bpv.Main;
import bpv.SelectionPanel;
import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import mlib.MString;
import oroma.db.PicInfo;
import oroma.db.Query;
import oroma.website.WebImg;
import swing.ColorPanel;
import swing.DatePanel;
import swing.PanelLabel;
import swing.StatusBox;
import swing.WheelComboBox;

class SearchDialog
extends CenteredDialog {
    private DatePanel jDatePanel = new DatePanel(false, true);
    private SearchFields iFields = null;
    private static WheelComboBox[] ComboBoxes = null;

    private static void setupComboBoxes() {
        ComboBoxes = new WheelComboBox[Main.SearchFields.length];
        int i = 0;
        while (i < Main.SearchFields.length) {
            WheelComboBox box = new WheelComboBox();
            box.setEditable(true);
            box.setEnabled(true);
            box.setWheelEnabled(true);
            box.setKeepOrder(true);
            SearchDialog.ComboBoxes[i] = box;
            ++i;
        }
        for (WebImg img : Main.singleton().allImages()) {
            PicInfo info = img.picInfo();
            int i2 = 0;
            while (i2 < Main.SearchFields.length) {
                PicInfo.ComboField field = info.comboField(Main.SearchFields[i2]);
                String value = field.value().toString();
                if (value.length() > 0) {
                    ComboBoxes[i2].addItem(value);
                }
                ++i2;
            }
        }
    }

    SearchDialog() {
        if (ComboBoxes == null) {
            SearchDialog.setupComboBoxes();
        }
        this.iFields = new SearchFields();
        this.setModal(true);
        this.center(0.4, 0.35);
        this.setTitle("Search");
        ColorPanel panel = new ColorPanel();
        SearchPrompts prompts = new SearchPrompts();
        prompts.setBackground(new Color(235, 235, 235));
        panel.setLayout(new BorderLayout());
        panel.add((Component)prompts, "West");
        panel.add((Component)this.iFields, "Center");
        panel.add((Component)this.jDatePanel, "South");
        this.addClientPanel(panel);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void custom(int index, DialogEvent event) {
    }

    @Override
    public void accept(DialogEvent event) {
        String msg = this.jDatePanel.testIfValid();
        if (msg == null) {
            SelectionPanel.singleton().enableControls(false);
            Query query = this.iFields.query(this.jDatePanel);
            String orderBy = SelectionPanel.singleton().orderBy();
            DisplayFiller filler = new DisplayFiller(true);
            filler.doSearch(query, orderBy);
            this.dispose();
        } else {
            StatusBox.singleton().queueShowMsg(msg, true);
        }
    }

    class SearchFields
    extends ColorPanel {
        private Query iQuery = new Query();

        SearchFields() {
            this.setLayout(new GridLayout(0, 1));
            int i = 0;
            while (i < Main.SearchFields.length) {
                this.add(ComboBoxes[i]);
                ++i;
            }
            this.iQuery.setOrdering("By date");
        }

        Query query(DatePanel datePanel) {
            PicInfo info = this.iQuery.picInfo();
            int i = 0;
            while (i < Main.SearchFields.length) {
                PicInfo.ComboField field = info.comboField(Main.SearchFields[i]);
                String value = (String)ComboBoxes[i].getSelectedItem();
                if (value != null) {
                    field.setValue(value.trim());
                }
                ++i;
            }
            info.setYear(datePanel.obtainYear());
            info.setUncer(datePanel.obtainUncer());
            info.setMonth(datePanel.obtainMonth());
            info.setDay(datePanel.obtainDay());
            this.iQuery.resetMatching();
            return this.iQuery;
        }
    }

    private class SearchPrompts
    extends ColorPanel {
        SearchPrompts() {
            this.setLayout(new GridLayout(0, 1));
            int i = 0;
            while (i < Main.SearchFields.length) {
                MString label = new MString(Main.SearchFields[i]);
                label.capFirstChar();
                this.add(new PanelLabel(label.toString(), ':'));
                ++i;
            }
        }
    }
}

