/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.Album;
import bpv.BpvMsgs;
import bpv.ImageLoader;
import bpv.Main;
import bpv.Thumbnail;
import java.awt.GridLayout;
import java.awt.Image;
import mlib.MAppMsg;
import oroma.website.WebImg;
import swing.ColorPanel;
import utilt.Utility;

class DisplayPage
extends ColorPanel {
    private Album iAlbum = null;
    private WebImg[] iWebImgs = null;

    DisplayPage(Album album, WebImg[] webImgs) {
        this.iAlbum = album;
        this.iWebImgs = webImgs;
        int numCols = Main.singleton().numCols();
        this.setLayout(new GridLayout(0, numCols));
    }

    Album album() {
        return this.iAlbum;
    }

    Thumbnail fill(int firstPic, int lastPic, Thumbnail prev) {
        int remainder;
        Thumbnail thumb = null;
        int count = 0;
        int i = firstPic;
        Thread loader = null;
        while (i <= lastPic) {
            if (loader == null) {
                WebImg cur = this.iWebImgs[i];
                Image image = cur.image();
                if (image == null) {
                    loader = new ImageLoader(cur, true);
                    loader.start();
                    continue;
                }
                thumb = new Thumbnail(i, cur, image, prev);
                this.add(thumb);
                if (prev != null) {
                    prev.setNext(thumb);
                }
                prev = thumb;
                ++count;
                ++i;
                continue;
            }
            try {
                loader.join();
                Image image = ((ImageLoader)loader).image();
                if (image != null) {
                    ((ImageLoader)loader).webImg().setImage(image);
                    thumb = new Thumbnail(i + 1, ((ImageLoader)loader).webImg(), image, prev);
                    this.add(thumb);
                    if (prev != null) {
                        prev.setNext(thumb);
                    }
                    prev = thumb;
                    ++count;
                    ++i;
                }
                loader = null;
            }
            catch (Exception xcp) {
                MAppMsg msg = BpvMsgs.get("runtime_error");
                Main.singleton().logger().writeln(msg.format("ThumbNail", Utility.xcpMsg(xcp)));
            }
        }
        if (lastPic + 1 == this.iWebImgs.length && (remainder = count % Main.singleton().numCols()) != 0) {
            int left = Main.singleton().numCols() - count % Main.singleton().numCols();
            while (left > 0) {
                ColorPanel panel = new ColorPanel();
                this.add(panel);
                --left;
            }
        }
        return thumb;
    }
}

