/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.AlbumGroup;
import files.FileInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import mlib.MEncrypter;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;
import oroma.db.Database;
import oroma.db.ProgInstallation;
import oroma.db.Query;
import oroma.db.Website;
import utilt.Utility;

public class AlbumGroupBuilder {
    public static final String SUBTITLEDELIM = ", ";
    public static final String GROUPFILEEXT = ".grp";

    public static void main(String[] args) {
        try {
            MLogger.System logger = new MLogger.System();
            ProgInstallation.read();
            File file = new File(args[0]);
            Database.Parms parms = new Database.Parms(new FileInfo.Local(file), null);
            Database.open(parms, true, logger);
            File xmlFile = new File(args[1]);
            AlbumGroup group = AlbumGroupBuilder.build(xmlFile, logger);
            logger.writeln(group.toString());
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    private static void verify(AlbumGroup group, MLogging logger) throws Exception {
        MEncrypter encrypter = new MEncrypter(group.date() + 1001L);
        int numImgs = 0;
        LinkedList<AlbumGroup.ViewerAlbum> vAlbums = group.albums();
        for (AlbumGroup.ViewerAlbum vAlbum : vAlbums) {
            String albumName = vAlbum.name().trim();
            Query query = Database.singleton().query(albumName, true);
            if (query == null) {
                Utility.throwError("Album not found: " + albumName);
                continue;
            }
            Website site = Database.singleton().webDb().find(albumName);
            if (site == null) {
                Utility.throwError("Website not found: " + albumName);
                continue;
            }
            vAlbum.setAnnot(site.def().annot());
            if (site.def().ftpDir().length() <= 0) {
                Utility.throwError("No FTP folder: " + site.def().title());
            }
            numImgs += site.numImgs();
            Query clone = (Query)query.clone();
            clone.setOrdering(site.def().imageOrder());
            String dateStr = Utility.DMY.format(site.lastBuild());
            MString title = new MString(site.def().title());
            MString folder = new MString(String.valueOf(site.def().ftpDir()) + '#' + title + '#' + dateStr);
            logger.writeln("Build viewer album: " + folder.toString());
            folder.cipher(encrypter);
            String desc = folder.toString();
            clone.setDesc(desc);
            vAlbum.setQuery(clone);
        }
        logger.writeln(vAlbums.size() + " albums and " + numImgs + " photos");
    }

    private static void writeGroupFile(AlbumGroup group, MLogging logger) throws Exception {
        String fileName = String.valueOf(group.name()) + GROUPFILEEXT;
        String groupPath = String.valueOf(Database.singleton().webDb().path()) + File.separatorChar + fileName;
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(groupPath));
        out.writeObject(group);
        out.close();
        logger.writeln("Wrote AlbumGroup file: " + groupPath, false);
    }

    public static AlbumGroup build(File xml, MLogging logger) throws Exception {
        AlbumGroup group = AlbumGroup.parse(xml);
        logger.writeln("Parsed AlbumGroup: " + group.name(), false);
        AlbumGroupBuilder.verify(group, logger);
        AlbumGroupBuilder.writeGroupFile(group, logger);
        return group;
    }

    private AlbumGroupBuilder() {
    }
}

