/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import java.util.StringTokenizer;
import mlib.MEncrypter;
import mlib.MString;
import oroma.db.Query;

public class Album
implements Comparable<Album> {
    private Query iQuery = null;
    private boolean iUseMark = true;
    private boolean iZoomable = true;
    private String iTitle = "";
    private int iPageSize = 0;
    private String iServerFolder = null;
    private static final String PHOTOS = " Photos";

    public Album(Query query, MEncrypter encrypter, boolean useMark, boolean zoomable) {
        this.iQuery = query;
        this.iUseMark = useMark;
        this.iZoomable = zoomable;
        MString desc = new MString(this.iQuery.desc());
        desc.cipher(encrypter);
        String delim = "#";
        StringTokenizer tken = new StringTokenizer(desc.toString(), delim);
        this.iServerFolder = tken.nextToken();
        this.iTitle = tken.nextToken().trim();
        MString title = new MString(this.iTitle);
        if (title.endsWith(PHOTOS)) {
            int index = title.lastIndexOf(PHOTOS);
            try {
                this.iTitle = this.iTitle.substring(0, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Album(Query query, String title) {
        this.iQuery = query;
        this.iTitle = title;
    }

    public Query query() {
        return this.iQuery;
    }

    public boolean isUseMark() {
        return this.iUseMark;
    }

    public boolean isZoomable() {
        return this.iZoomable;
    }

    public String serverFolder() {
        return this.iServerFolder;
    }

    public int pageSize() {
        return this.iPageSize;
    }

    public String title() {
        return this.iTitle;
    }

    @Override
    public int compareTo(Album album) {
        int result = 0;
        if (album != this) {
            result = -1;
            if (album != null) {
                result = this.title().compareToIgnoreCase(album.title());
            }
        }
        return result;
    }

    public boolean equals(Album obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.title().toLowerCase().hashCode();
    }
}

