/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import swing.StatusBox;

public class TextPrinter
implements Printable,
Runnable {
    private String[] iLines = null;
    private PageFormat iPageFormat = null;
    private HashPrintRequestAttributeSet iAttrs = new HashPrintRequestAttributeSet();
    private int iStartIndex = 0;
    private int iEndIndex = 0;
    private int iBaseline = 0;
    private static final int TOPMARGINPOINTS = 25;
    private static final int HEIGHTOFFSETPOINTS = 100;
    private static final int LINESPACING = 0;
    private static final int PRINTFONTSIZE = 10;
    private static final int PRINTINC = 10;
    private static final int NUMHEADERLINES = 3;
    private static final Font PRINTFONT = new Font("Monospaced", 0, 10);

    public TextPrinter(String[] lines) {
        this.iLines = lines;
    }

    @Override
    public void run() {
        PrinterJob job = PrinterJob.getPrinterJob();
        this.setupPage(job);
        job.setPrintable(this, this.iPageFormat);
        if (job.printDialog(this.iAttrs)) {
            try {
                StatusBox.singleton().showMsg("Print started", false);
                job.print();
            }
            catch (PrinterException xcp) {
                StatusBox.singleton().showMsg("Unable to print", true);
            }
        }
    }

    private void setupPage(PrinterJob job) {
        this.iPageFormat = job.defaultPage();
        this.iPageFormat.setOrientation(1);
        Paper paper = this.iPageFormat.getPaper();
        double x = paper.getImageableX();
        double y = paper.getImageableY() - 25.0;
        double width = paper.getImageableWidth();
        double height = paper.getImageableHeight() + 100.0;
        paper.setImageableArea(x, y, width, height);
        this.iPageFormat.setPaper(paper);
    }

    @Override
    public int print(Graphics g, PageFormat format, int page) {
        int status = 1;
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(Color.black);
        g2.setFont(PRINTFONT);
        g2.translate(format.getImageableX(), format.getImageableY());
        this.calcPageIndexes(format, page);
        if (this.iStartIndex <= this.iLines.length) {
            this.iBaseline = 10;
            int i = this.iStartIndex;
            while (i <= this.iEndIndex) {
                if (i >= this.iLines.length) break;
                if (i == this.iStartIndex) {
                    this.printHeader(g2, format, page);
                }
                g2.drawString(this.iLines[i], 0, this.iBaseline);
                this.iBaseline += 10;
                ++i;
            }
            status = 0;
        }
        if (status == 1) {
            StatusBox.singleton().showMsg("Print done", false);
        }
        return status;
    }

    private void printHeader(Graphics2D g2, PageFormat format, int page) {
        String pageNum = "Page " + (page + 1);
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = PRINTFONT.getStringBounds(pageNum, context);
        double strX = format.getImageableWidth() - bounds.getWidth();
        g2.drawString(pageNum, (int)strX, this.iBaseline);
        this.iBaseline += 5;
        Line2D.Double horzLine = new Line2D.Double(0.0, this.iBaseline, format.getImageableWidth(), this.iBaseline);
        g2.draw(horzLine);
        this.iBaseline += 5;
        g2.drawString(" ", 0, this.iBaseline);
        this.iBaseline += 20;
    }

    private void calcPageIndexes(PageFormat format, int page) {
        double pageHeight = format.getImageableHeight();
        int pageLines = (int)(pageHeight / 11.0);
        this.iStartIndex = page * (pageLines -= 3);
        this.iEndIndex = this.iStartIndex + pageLines - 1;
    }
}

