/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import utilt.GenericServer;

public abstract class GenericServerClient
implements Runnable {
    private Socket iSocket = null;
    private GenericServer iServer = null;
    private ObjectOutputStream iOutStream = null;
    private ObjectInputStream iInStream = null;

    protected GenericServerClient(GenericServer server, Socket client) {
        this.iSocket = client;
        this.iServer = server;
    }

    protected ObjectOutputStream outStream() {
        return this.iOutStream;
    }

    protected ObjectInputStream inStream() {
        return this.iInStream;
    }

    @Override
    public void run() {
        this.clientStarted(this.iSocket);
        try {
            try {
                this.iOutStream = new ObjectOutputStream(this.iSocket.getOutputStream());
                this.iInStream = new ObjectInputStream(this.iSocket.getInputStream());
                this.process();
            }
            catch (Exception xcp) {
                System.out.println(xcp);
                this.iServer.clientEnding();
                this.clientEnded(this.iSocket);
                try {
                    if (this.iOutStream != null) {
                        this.iOutStream.close();
                    }
                    if (this.iInStream != null) {
                        this.iInStream.close();
                    }
                    if (this.iSocket != null) {
                        this.iSocket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            this.iServer.clientEnding();
            this.clientEnded(this.iSocket);
            try {
                if (this.iOutStream != null) {
                    this.iOutStream.close();
                }
                if (this.iInStream != null) {
                    this.iInStream.close();
                }
                if (this.iSocket != null) {
                    this.iSocket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected abstract void clientEnded(Socket var1);

    protected abstract void clientStarted(Socket var1);

    protected abstract void process() throws IOException, ClassNotFoundException;
}

