/*
 * Decompiled with CFR 0.152.
 */
package utilt;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import utilt.GenericServerClient;

public abstract class GenericServer {
    private int iNumClients = 0;

    public int numClients() {
        return this.iNumClients;
    }

    protected void process(int port) throws IOException {
        ServerSocket socket = null;
        Socket clientSocket = null;
        try {
            socket = new ServerSocket(port);
            this.serverStarted(socket, port);
            while (true) {
                clientSocket = socket.accept();
                ++this.iNumClients;
                this.clientAccepted(clientSocket, this.iNumClients);
                GenericServerClient client = this.newClient(this, clientSocket, this.iNumClients);
                Thread thread = new Thread(client);
                thread.start();
            }
        }
        catch (Throwable throwable) {
            if (socket != null) {
                socket.close();
            }
            if (clientSocket != null) {
                clientSocket.close();
            }
            throw throwable;
        }
    }

    protected synchronized void clientEnding() {
        --this.iNumClients;
    }

    protected abstract GenericServerClient newClient(GenericServer var1, Socket var2, int var3);

    protected abstract void serverStarted(ServerSocket var1, int var2);

    protected abstract void clientAccepted(Socket var1, int var2);
}

