/*
 * Decompiled with CFR 0.152.
 */
package userkey;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import swing.PanelLabel;
import swing.StdScrollPane;
import userkey.KeyPanel;
import userkey.UserKey;

public class UserKeyDialog
extends CenteredDialog {
    private KeyPanel iKeyPanel = new KeyPanel();
    private LinkedList<Listener> iLis = new LinkedList();
    private int[] iNumPos = null;
    private int[] iSqrtPos = null;

    public static float horzFrac() {
        return 0.5f;
    }

    public static float vertFrac() {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        int height = 6 * PanelLabel.fontAll().getSize() + 50;
        float vertFrac = (float)height / (float)screen.height;
        return vertFrac;
    }

    public UserKeyDialog(Frame owner, int[] numPos, int[] sqrtPos) {
        super(owner);
        this.iNumPos = numPos;
        this.iSqrtPos = sqrtPos;
        this.setModal(false);
        this.getContentPane().add((Component)new StdScrollPane(this.iKeyPanel), "Center");
        this.addWindowListener(new WindowHandler());
        this.setTitle("Enter license key");
    }

    @Override
    public void accept(DialogEvent event) {
        String entry = this.iKeyPanel.userEntry();
        if (UserKey.isKey(entry, this.iNumPos, this.iSqrtPos)) {
            this.dispose();
            this.fireUserKeyEvent(this, true);
        } else {
            this.iKeyPanel.showMsg("Invalid key");
            this.iKeyPanel.requestFocus();
        }
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public synchronized void removeListener(Listener lis) {
        this.iLis.remove(lis);
    }

    @Override
    public void cancel(DialogEvent event) {
        this.dispose();
        this.fireUserKeyEvent(this, false);
    }

    @Override
    public void custom(int index, DialogEvent event) {
    }

    private void fireUserKeyEvent(Object source, boolean validKey) {
        Event evnt = new Event(source, validKey);
        for (Listener lis : this.iLis) {
            lis.keyEntered(evnt);
        }
    }

    public static class Event
    extends EventObject {
        private boolean iValid = false;

        public Event(Object source, boolean valid) {
            super(source);
            this.iValid = valid;
        }

        public boolean isValid() {
            return this.iValid;
        }
    }

    public static interface Listener
    extends EventListener {
        public void keyEntered(Event var1);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent event) {
            UserKeyDialog.this.fireUserKeyEvent(UserKeyDialog.this, false);
        }
    }
}

