/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.GridLayout;
import java.util.Stack;
import mlib.MString;
import swing.ColorPanel;
import swing.WheelComboBox;

public class WheelSelectionPanel
extends ColorPanel {
    private WheelComboBox[] iBoxes = null;
    public static final char DELIM = ',';
    private static final String EMPTY = " ";

    public WheelSelectionPanel(int numBoxes, int numCols, String[] wheelOptions) {
        this.setLayout(new GridLayout(0, numCols));
        this.iBoxes = new WheelComboBox[numBoxes];
        int i = 0;
        while (i < numBoxes) {
            this.iBoxes[i] = new WheelComboBox();
            this.iBoxes[i].setEditable(false);
            this.iBoxes[i].setWheelEnabled(true);
            this.iBoxes[i].setKeepOrder(true);
            try {
                this.iBoxes[i].setItems(wheelOptions);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.add(this.iBoxes[i]);
            ++i;
        }
    }

    public void putSelections(Stack<String> selections) {
        int i = 0;
        while (i < this.iBoxes.length) {
            this.iBoxes[i].setSelectedItem(EMPTY);
            ++i;
        }
        int box = 0;
        while (!selections.empty() && box < this.iBoxes.length) {
            MString work = new MString(selections.pop());
            work.capFirstChar();
            this.iBoxes[box].setSelectedItem(work.toString());
            ++box;
        }
    }

    public MString selections() {
        MString selections = new MString();
        int i = 0;
        while (i < this.iBoxes.length) {
            String sel = (String)this.iBoxes[i].getSelectedItem();
            if (!sel.equals(EMPTY) && selections.indexOf(sel) < 0) {
                selections.concat(String.valueOf(sel) + ',');
            }
            ++i;
        }
        return selections.trimTail(',');
    }

    @Override
    public void enable(boolean enable) {
        int i = 0;
        while (i < this.iBoxes.length) {
            this.iBoxes[i].setEnabled(enable);
            ++i;
        }
    }
}

