/*
 * Decompiled with CFR 0.152.
 */
package swing;

import combo.FifoComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import mlib.MLogging;
import mlib.MString;

public class StatusBox
extends FifoComboBox {
    private Color iBackColor = SystemColor.control;
    private Color iForeColor = Color.blue;
    private Color iErrorColor = Color.red;
    private ImageIcon iIcon = null;
    private String iPrevMsg = "";
    private String iLastNoErrorMsg = null;
    private boolean iLastWasError = false;
    private boolean iShowHadPrevError = true;
    private MLogging iLogger = null;
    private static final String ERRORPREFIX = "***";
    private static StatusBox Singleton = new StatusBox();

    public static StatusBox singleton() {
        if (Singleton == null) {
            Singleton = new StatusBox();
        }
        return Singleton;
    }

    private StatusBox() {
        this.setEditable(false);
        this.setRenderer(new MsgRenderer());
        this.setToolTipText("Messages Display");
        super.setBackground(SystemColor.control);
        super.setForeground(SystemColor.controlText);
        Singleton = this;
    }

    public void setLogger(MLogging logger) {
        this.iLogger = logger;
    }

    public synchronized void showMsg(String text, boolean error) {
        if (error) {
            this.showMsg(text, error, this.iErrorColor);
            if (this.iLogger != null) {
                this.iLogger.writeln(text, true);
            }
        } else {
            this.showMsg(text, error, this.iForeColor);
        }
    }

    public synchronized void showMsg(String text, boolean error, Color foreColor) {
        if (text != null) {
            MString work = new MString(text);
            work.capFirstChar();
            text = work.toString();
            super.setBackground(this.iBackColor);
            String msg = "";
            if (error) {
                msg = String.valueOf(msg) + ERRORPREFIX;
                super.setForeground(this.iErrorColor);
            } else {
                msg = String.valueOf(msg) + " ";
            }
            super.setForeground(foreColor);
            msg = String.valueOf(msg) + text;
            if (!msg.equals(this.iPrevMsg)) {
                int count = this.fifoErrorMsgs();
                if (this.iShowHadPrevError) {
                    if (count == 1) {
                        msg = String.valueOf(msg) + " (" + count + " error)";
                    } else if (count > 1) {
                        msg = String.valueOf(msg) + " (" + count + " errors)";
                    }
                }
                this.putItem(msg, true, false);
                this.iPrevMsg = msg;
                Rectangle rec = new Rectangle();
                this.computeVisibleRect(rec);
                this.paintImmediately(rec);
            }
            this.iLastWasError = error;
            if (!error) {
                this.iLastNoErrorMsg = text;
            }
            if (this.iLogger != null) {
                this.iLogger.writeln(text, error);
            }
        }
    }

    public synchronized void queueShowMsg(String text, boolean error) {
        StatusUpdate update = new StatusUpdate(text, error);
        EventQueue.invokeLater(update);
    }

    public synchronized void queueShowMsg(String text, boolean error, MLogging logger) {
        StatusUpdate update = new StatusUpdate(text, error);
        EventQueue.invokeLater(update);
        logger.writeln(text, error);
    }

    public void setIcon(ImageIcon icon) {
        this.iIcon = icon;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.iBackColor = color;
    }

    public Color getForegroundColor() {
        return this.iForeColor;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.iForeColor = color;
    }

    public void setErrorColor(Color color) {
        this.iErrorColor = color;
    }

    public Color getErrorColor() {
        return this.iErrorColor;
    }

    public void setShowHadPrevError(boolean show) {
        this.iShowHadPrevError = show;
    }

    public void clearError() {
        if (this.iLastWasError) {
            if (this.iLastNoErrorMsg != null) {
                this.showMsg(this.iLastNoErrorMsg, false);
            } else {
                this.showMsg("", false);
            }
            this.iLastWasError = false;
        }
    }

    private int fifoErrorMsgs() {
        int count = 0;
        int i = 0;
        while (i < this.getMaxItems()) {
            String msg = (String)this.getItemAt(i);
            if (msg != null && msg.indexOf(ERRORPREFIX) >= 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private class MsgRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private MsgRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.setOpaque(true);
                super.setBackground(StatusBox.this.iBackColor);
                String msg = (String)value;
                if (msg.startsWith(StatusBox.ERRORPREFIX)) {
                    msg = " " + msg.substring(StatusBox.ERRORPREFIX.length());
                    this.setText(msg);
                    super.setForeground(StatusBox.this.iErrorColor);
                } else {
                    this.setText(msg);
                    super.setForeground(StatusBox.this.iForeColor);
                }
                int height = this.getFont().getSize() + 4;
                if (StatusBox.this.iIcon != null) {
                    this.setIcon(StatusBox.this.iIcon);
                    if (StatusBox.this.iIcon.getIconHeight() > height) {
                        height = StatusBox.this.iIcon.getIconHeight();
                    }
                }
                list.setFixedCellHeight(height);
            }
            return this;
        }
    }

    private class StatusUpdate
    extends Thread {
        private String iMsg = null;
        private boolean iError = false;

        StatusUpdate(String msg, boolean error) {
            this.iMsg = msg;
            this.iError = error;
        }

        @Override
        public void run() {
            StatusBox.this.showMsg(this.iMsg, this.iError);
        }
    }
}

