/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import swing.SwingProgram;
import utilt.Utility;

public class Selector
extends JPanel {
    private int iSelection = -1;
    private String[] iOptions = null;
    private JLabel iSelector = new JLabel();
    private JLabel iLabel = new JLabel();
    private MouseHandler iMouseHandler = new MouseHandler();
    private LinkedList<Listener> iLis = new LinkedList();
    private boolean iLocked = false;
    private int iId = -1;
    private static final int NOVALUE = -1;
    private static LinkedList<Selector> Instances = new LinkedList();
    private static Color AllFore = SystemColor.controlText;
    private static Color AllBack = SystemColor.control;
    private static Color AllHilight = SystemColor.control;
    private static Font AllFont = Utility.stdFont();

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (Selector sel : Instances) {
            sel.setBackground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (Selector sel : Instances) {
            sel.setFont(AllFont);
        }
    }

    public static Font fontAll() {
        return AllFont;
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (Selector sel : Instances) {
            sel.setForeground(AllFore);
        }
    }

    public static void putHilightColorAll(Color color) {
        AllHilight = color;
    }

    public Selector(String label, String[] options) {
        this(label, options, 4, 2);
    }

    public Selector(String label, String[] options, int optionAlign) {
        this.iOptions = options;
        this.initialize(label, 2, optionAlign);
    }

    public Selector(String label, String[] options, int labelAlign, int optionAlign) {
        this.iOptions = options;
        this.initialize(label, labelAlign, optionAlign);
    }

    public Selector(String label, int labelAlign, int optionAlign) {
        this.initialize(label, labelAlign, optionAlign);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.iLocked = !enable;
        this.iSelector.setEnabled(enable);
        this.iLabel.setEnabled(enable);
    }

    public void setOptions(String[] options) {
        this.iOptions = options;
        if (this.iOptions.length > 0) {
            this.setSelection(this.iOptions[0], false);
        } else {
            this.iSelector.setText("");
            this.iSelection = -1;
        }
    }

    private void initialize(String label, int labelAlign, int optionAlign) {
        this.setLayout(new GridLayout(1, 0));
        this.setOpaque(true);
        if (label != null) {
            this.iLabel = new JLabel(label);
            this.iLabel.setHorizontalAlignment(labelAlign);
            this.add(this.iLabel);
            this.iLabel.setOpaque(true);
            this.iSelector.setHorizontalAlignment(optionAlign);
        } else {
            this.iSelector.setHorizontalAlignment(optionAlign);
        }
        this.add(this.iSelector);
        if (this.iOptions != null) {
            this.setOptions(this.iOptions);
        }
        this.iSelector.addMouseListener(this.iMouseHandler);
        this.iSelector.addMouseWheelListener(this.iMouseHandler);
        this.iSelector.setBorder(SwingProgram.EMPTYBORDER);
        this.iSelector.setOpaque(true);
        this.setBackground(AllBack);
        this.setForeground(AllFore);
        this.setFont(AllFont);
        Instances.add(this);
    }

    public boolean setSelection(String text, boolean doCallbacks) {
        boolean put = false;
        if (text != null) {
            int i = 0;
            while (i < this.iOptions.length) {
                if (text.equals(this.iOptions[i])) {
                    this.iSelection = i;
                    this.handleSelection(doCallbacks);
                    put = true;
                    break;
                }
                ++i;
            }
        }
        return put;
    }

    public String getSelection() {
        String sel = null;
        if (this.iSelection != -1) {
            sel = this.iOptions[this.iSelection];
        }
        return sel;
    }

    public int getId() {
        return this.iId;
    }

    public void setId(int id) {
        this.iId = id;
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    private void handleSelection(boolean doCallbacks) {
        this.iSelector.setText(this.iOptions[this.iSelection]);
        if (doCallbacks) {
            Event event = new Event(this, this.iOptions[this.iSelection], this.iId);
            for (Listener lis : this.iLis) {
                lis.selected(event);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.iSelector != null) {
            this.iSelector.setFont(font);
        }
        if (this.iLabel != null) {
            this.iLabel.setFont(font);
        }
    }

    @Override
    public void setBackground(Color back) {
        super.setBackground(back);
        if (this.iSelector != null) {
            this.iSelector.setBackground(back);
        }
        if (this.iLabel != null) {
            this.iLabel.setBackground(back);
        }
    }

    @Override
    public void setForeground(Color fore) {
        super.setForeground(fore);
        if (this.iSelector != null) {
            this.iSelector.setForeground(fore);
        }
        if (this.iLabel != null) {
            this.iLabel.setForeground(fore);
        }
    }

    public static class Event
    extends EventObject {
        private String iSelection = null;
        private int iSelectorId = -1;

        public Event(Object source, String selection, int selectorId) {
            super(source);
            this.iSelection = selection;
            this.iSelectorId = selectorId;
        }

        public String getSelection() {
            return this.iSelection;
        }

        public void setSelection(String selection) {
            this.iSelection = selection;
        }

        public int getSelectorId() {
            return this.iSelectorId;
        }
    }

    public static interface Listener {
        public void selected(Event var1);
    }

    private class MouseHandler
    extends MouseAdapter {
        private Color iBackColor = null;

        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (!Selector.this.iLocked) {
                if ((event.getModifiers() & 0x10) > 0) {
                    if (Selector.this.iSelection - 1 >= 0) {
                        Selector selector = Selector.this;
                        selector.iSelection = selector.iSelection - 1;
                        Selector.this.handleSelection(true);
                    }
                } else if ((event.getModifiers() & 4) > 0 && Selector.this.iSelection + 1 < Selector.this.iOptions.length) {
                    Selector selector = Selector.this;
                    selector.iSelection = selector.iSelection + 1;
                    Selector.this.handleSelection(true);
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            if (!Selector.this.iLocked) {
                int curSel = Selector.this.iSelection;
                Selector selector = Selector.this;
                selector.iSelection = selector.iSelection - event.getWheelRotation();
                if (event.getWheelRotation() > 0) {
                    if (Selector.this.iSelection < 0) {
                        Selector.this.iSelection = 0;
                    }
                    if (Selector.this.iSelection != curSel) {
                        Selector.this.handleSelection(true);
                    }
                } else if (event.getWheelRotation() < 0) {
                    if (Selector.this.iSelection >= Selector.this.iOptions.length) {
                        Selector.this.iSelection = Selector.this.iOptions.length - 1;
                    }
                    if (Selector.this.iSelection != curSel) {
                        Selector.this.handleSelection(true);
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            if (!Selector.this.iLocked) {
                this.iBackColor = Selector.this.getBackground();
                Selector.this.iSelector.setBorder(SwingProgram.STDBORDER);
                Selector.this.iSelector.setBackground(AllHilight);
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (!Selector.this.iLocked) {
                Selector.this.iSelector.setBorder(SwingProgram.EMPTYBORDER);
                Selector.this.iSelector.setBackground(this.iBackColor);
            }
        }
    }

    public static class StdColor
    extends Selector {
        public StdColor(String label) {
            super(label, 4, 2);
            this.setOptions(mswing.StdColor.names());
        }

        public mswing.StdColor selected() {
            mswing.StdColor color = mswing.StdColor.forName(this.getSelection());
            return color;
        }

        public boolean setSelection(mswing.StdColor color, boolean doCallbacks) {
            boolean result;
            String name = mswing.StdColor.nameForStdColor(color);
            boolean bl = result = name != null;
            if (result) {
                super.setSelection(name, doCallbacks);
            }
            return result;
        }
    }

    public static class TrueFalse
    extends Selector {
        private static final String[] OPTIONS = new String[]{"true", "false"};

        public TrueFalse(String label) {
            super(label, OPTIONS);
        }

        public boolean selected() {
            Boolean value = Boolean.valueOf(this.getSelection());
            return value;
        }
    }
}

