/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import swing.SwingProgram;
import utilt.Utility;

public class NumberSpinner
extends JSpinner {
    private static LinkedList<NumberSpinner> Instances = new LinkedList();
    private static Color AllFore = SystemColor.textText;
    private static Color AllBack = SystemColor.text;
    private static Color AllHilight = SystemColor.control;
    private static Font AllFont = Utility.stdFont();

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (NumberSpinner spinner : Instances) {
            spinner.getEditor().getComponent(0).setForeground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (NumberSpinner spinner : Instances) {
            spinner.getEditor().getComponent(0).setFont(AllFont);
        }
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (NumberSpinner spinner : Instances) {
            spinner.getEditor().getComponent(0).setForeground(AllFore);
        }
    }

    public static void putHilightColorAll(Color color) {
        AllHilight = color;
        for (NumberSpinner spinner : Instances) {
            spinner.setForeground(AllFore);
        }
    }

    public NumberSpinner(int value, int min, int max) {
        super(new SpinnerNumberModel(value, min, max, 1));
        this.getEditor().getComponent(0).setBackground(AllBack);
        this.getEditor().getComponent(0).setForeground(AllFore);
        this.getEditor().getComponent(0).setFont(AllFont);
        this.getEditor().getComponent(0).addMouseListener(new MouseHandler());
    }

    private class MouseHandler
    extends MouseAdapter {
        private Color iBackColor = null;

        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.iBackColor = NumberSpinner.this.getEditor().getComponent(0).getBackground();
            ((JTextField)NumberSpinner.this.getEditor().getComponent(0)).setBorder(SwingProgram.STDBORDER);
            NumberSpinner.this.getEditor().getComponent(0).setBackground(AllHilight);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            ((JTextField)NumberSpinner.this.getEditor().getComponent(0)).setBorder(SwingProgram.EMPTYBORDER);
            NumberSpinner.this.getEditor().getComponent(0).setBackground(this.iBackColor);
        }
    }
}

