/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPasswordField;
import mswing.StdColor;
import swing.ColorButton;
import swing.ColorPanel;
import swing.EntryField;
import swing.PanelLabel;

public class LoginPanel
extends ColorPanel {
    private PanelLabel jIdPrompt = new PanelLabel(" User id: ");
    private JPasswordField jIdField = null;
    private PanelLabel jPasswordPrompt = new PanelLabel(" Password: ");
    private JPasswordField jPasswordField = null;
    private ColorButton jCloseButton = null;

    public LoginPanel(boolean useId, boolean usePassword, boolean useCloseButton) {
        this.setLayout(new BorderLayout());
        this.getIdField().setBackground(StdColor.PALEYELLOW.color());
        this.getPasswordField().setBackground(StdColor.PALEYELLOW.color());
        ColorPanel left = new ColorPanel();
        left.setLayout(new BoxLayout(left, 0));
        if (useId) {
            left.add(this.jIdPrompt);
            left.add(this.getIdField());
        }
        if (usePassword) {
            left.add(this.jPasswordPrompt);
            left.add(this.getPasswordField());
        }
        this.add((Component)left, "Center");
        ColorPanel right = new ColorPanel();
        right.setLayout(new GridLayout(1, 0));
        if (useCloseButton) {
            this.jCloseButton = new ColorButton("Close");
            right.add(this.jCloseButton);
            this.jCloseButton.addActionListener(new CloseHandler());
        }
        this.add((Component)right, "East");
    }

    public void setHandler(ActionListener handler) {
        this.jIdField.addActionListener(handler);
        this.jPasswordField.addActionListener(handler);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.getIdField().setEnabled(enable);
        this.getPasswordField().setEnabled(enable);
        if (enable) {
            this.requestFocus();
        }
    }

    public String id() {
        String id = new String(this.getIdField().getPassword());
        return id.trim().toLowerCase();
    }

    public String password() {
        String pw = new String(this.getPasswordField().getPassword());
        return pw.trim().toLowerCase();
    }

    public void showPasswordError() {
        this.getPasswordField().setBackground(Color.red);
    }

    @Override
    public void requestFocus() {
        this.jIdField.requestFocus();
    }

    private JPasswordField getIdField() {
        if (this.jIdField == null) {
            this.jIdField = new JPasswordField();
            this.jIdField.setBackground(EntryField.backColorAll());
        }
        return this.jIdField;
    }

    private JPasswordField getPasswordField() {
        if (this.jPasswordField == null) {
            this.jPasswordField = new JPasswordField();
            this.jPasswordField.setBackground(EntryField.backColorAll());
            this.jPasswordField.setFont(new Font("Dialog", 1, 20));
        }
        return this.jPasswordField;
    }

    private class CloseHandler
    implements ActionListener {
        private CloseHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            System.exit(0);
        }
    }
}

