/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import mlib.MString;
import swing.EntryField;

public class DoubleEntryField
extends EntryField {
    private double iValue = 0.0;
    private double iMin = -1.7976931348623157E308;
    private double iMax = Double.MAX_VALUE;
    private int iRightDigits = 0;
    private boolean iValEntry = false;

    public DoubleEntryField() {
    }

    public DoubleEntryField(double value, double min, double max, int rightDigits) {
        this.iValue = value;
        this.iMin = min;
        this.iMax = max;
        this.iRightDigits = rightDigits;
        this.addActionListener(new ActionHandler());
        this.addFocusListener(new FocusHandler());
        this.addMouseListener(new MouseHandler());
    }

    public double getValue() {
        return this.iValue;
    }

    public void setValue(double value) {
        boolean bl = this.iValEntry = value >= this.iMin && value <= this.iMax;
        if (this.iValEntry) {
            MString format = MString.valueOf(value, this.iRightDigits);
            this.setText(format.toString());
            this.iValue = Double.parseDouble(format.toString());
        }
    }

    public void setMax(double max) {
        this.iMax = max;
    }

    public void setMin(double min) {
        this.iMin = min;
    }

    public boolean isValEntry() {
        return this.iValEntry;
    }

    private void process() {
        try {
            double value = Double.parseDouble(this.getText());
            boolean bl = this.iValEntry = value >= this.iMin && value <= this.iMax;
            if (this.iValEntry) {
                this.setValue(value);
            }
        }
        catch (NumberFormatException xcp) {
            this.iValEntry = false;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DoubleEntryField.this.process();
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            DoubleEntryField.this.process();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            DoubleEntryField.this.process();
        }
    }
}

