/*
 * Decompiled with CFR 0.152.
 */
package swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import swing.EntryField;
import swing.PanelLabel;
import utilt.Utility;

public class CheckboxPanel
extends JPanel {
    private LinkedList<Listener> iLis = new LinkedList();
    private ImageIcon iItemIcon = null;
    private int iNumSelected = 0;
    private ActionHandler iCheckHandler = new ActionHandler();
    private static LinkedList<CheckboxPanel> Instances = new LinkedList();
    private static Color AllFore = SystemColor.windowText;
    private static Color AllBack = SystemColor.window;
    private static Font AllFont = Utility.stdFont();

    public CheckboxPanel() {
        this.setBackground(AllBack);
        this.setLayout(new BoxLayout(this, 1));
        Instances.add(this);
    }

    public void setItemIcon(ImageIcon icon) {
        this.iItemIcon = icon;
    }

    public void fill(Collection<Object> objs) {
        Iterator<Object> iter = objs.iterator();
        while (iter.hasNext()) {
            Item item = new Item(iter.next());
            this.add(item);
        }
    }

    public int numSelected() {
        return this.iNumSelected;
    }

    public LinkedList<Object> selections() {
        LinkedList<Object> selections = new LinkedList<Object>();
        int count = this.getComponentCount();
        int i = 0;
        while (i < count) {
            Item item = (Item)this.getComponent(i);
            if (item.iBox.isSelected()) {
                selections.add(item.iObj);
            }
            ++i;
        }
        return selections;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        int count = this.getComponentCount();
        int i = 0;
        while (i < count) {
            Item item = (Item)this.getComponent(i);
            item.setEnabled(enable);
            ++i;
        }
    }

    public void selectAll(boolean select) {
        int count = this.getComponentCount();
        int i = 0;
        while (i < count) {
            Item album = (Item)this.getComponent(i);
            boolean wasSelected = album.iBox.isSelected();
            album.iBox.setSelected(select);
            boolean isSelected = album.iBox.isSelected();
            boolean changed = wasSelected ^ isSelected;
            if (changed) {
                this.iNumSelected = isSelected ? ++this.iNumSelected : --this.iNumSelected;
            }
            ++i;
        }
        EventObject evnt = new EventObject(this);
        this.fireChecked(evnt);
    }

    private void fireChecked(EventObject event) {
        for (Listener lis : this.iLis) {
            lis.checked(event);
        }
    }

    public void enableItem(Object obj, boolean enable) {
        int count = this.getComponentCount();
        int i = 0;
        while (i < count) {
            Item item = (Item)this.getComponent(i);
            if (item.iObj.equals(obj)) {
                item.iBox.setEnabled(enable);
                break;
            }
            ++i;
        }
    }

    public void selectItems(Collection<Object> objs) {
        int count = this.getComponentCount();
        int i = 0;
        while (i < count) {
            Item item = (Item)this.getComponent(i);
            Iterator<Object> iter = objs.iterator();
            while (iter.hasNext()) {
                if (!item.iObj.equals(iter.next())) continue;
                item.iBox.setSelected(true);
                ++this.iNumSelected;
            }
            ++i;
        }
        EventObject evnt = new EventObject(this);
        this.fireChecked(evnt);
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public synchronized void removeListener(Listener lis) {
        this.iLis.remove(lis);
    }

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (CheckboxPanel panel : Instances) {
            panel.setBackground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (CheckboxPanel panel : Instances) {
            panel.setFont(AllFont);
        }
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (CheckboxPanel panel : Instances) {
            panel.setForeground(AllFore);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object checked = null;
            int count = CheckboxPanel.this.getComponentCount();
            int i = 0;
            while (i < count) {
                Item item = (Item)CheckboxPanel.this.getComponent(i);
                if (item.iBox == event.getSource()) {
                    checked = item.iObj;
                    if (item.iBox.isSelected()) {
                        CheckboxPanel checkboxPanel = CheckboxPanel.this;
                        checkboxPanel.iNumSelected = checkboxPanel.iNumSelected + 1;
                        break;
                    }
                    CheckboxPanel checkboxPanel = CheckboxPanel.this;
                    checkboxPanel.iNumSelected = checkboxPanel.iNumSelected - 1;
                    break;
                }
                ++i;
            }
            EventObject evnt = new EventObject(checked);
            CheckboxPanel.this.fireChecked(evnt);
        }
    }

    private class Item
    extends JPanel {
        private Object iObj = null;
        private PanelLabel iLabel = new PanelLabel(true);
        private JCheckBox iBox = new JCheckBox();

        Item(Object obj) {
            this.iObj = obj;
            this.setBackground(AllBack);
            this.setLayout(new BorderLayout());
            this.add((Component)this.iLabel, "Center");
            this.add((Component)this.iBox, "West");
            this.iBox.setBackground(EntryField.backColorAll());
            this.iBox.setFont(EntryField.fontAll());
            this.iLabel.setBackground(AllBack);
            this.iLabel.setText(this.iObj.toString());
            if (CheckboxPanel.this.iItemIcon != null) {
                this.iLabel.setIcon(CheckboxPanel.this.iItemIcon);
                this.iLabel.setHorizontalTextPosition(4);
            }
            this.iBox.addActionListener(CheckboxPanel.this.iCheckHandler);
        }

        @Override
        public void setEnabled(boolean enable) {
            this.iLabel.setEnabled(enable);
            this.iBox.setEnabled(enable);
        }
    }

    public static interface Listener {
        public void checked(EventObject var1);
    }
}

