/*
 * Decompiled with CFR 0.152.
 */
package popup;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.MenuElement;
import javax.swing.border.Border;
import popup.PopupItem;
import popup.PopupObject;
import popup.PopupPanelLayout;
import swing.ColorPanel;

public abstract class PopupPanel
extends ColorPanel {
    private Font iLabelFont = null;
    private Font iMenuFont = null;
    private Color iItemSelColor = Color.magenta;
    private Color iItemBackColor = this.getBackground();
    private Color iItemForeColor = SystemColor.windowText;
    private int iHgap = 5;
    private int iVgap = 5;
    private boolean iMultipleSelect = false;
    private transient JPanel iItemsPanel = null;
    private transient Collection<PopupItem> iItems = null;
    private transient Comparator<PopupItem> iComparator = null;
    private transient JScrollPane iSpane = null;
    private transient LayoutManager iLayout = null;
    private transient MouseListener iMouseHandler = new MouseHandler();
    private transient KeyListener iKeyHandler = new KeyHandler();
    private transient JPopupMenu iMenu = null;
    private transient LinkedList<PopupItem> iSelections = new LinkedList();
    private transient PopupItem[] iItemsArray = null;
    private transient int iSelIndex = -1;
    private transient LinkedList<Listener> iLis = new LinkedList();
    private transient boolean iEnablePopup = true;
    private transient boolean iEnableSelection = true;
    private transient Border iSelectionBorder = null;
    private transient Border iItemBorder = null;
    private static int PopupButtonMask = 4;
    private static final int NOSELECTION = -1;
    private static Color AllSelectionColor = Color.magenta;
    private static LinkedList<PopupPanel> Instances = new LinkedList();

    public static void putSelectColorAll(Color fore) {
        AllSelectionColor = fore;
        for (PopupPanel panel : Instances) {
            panel.setSelectionColor(AllSelectionColor);
        }
    }

    public static void putBackColorAll(Color back) {
        for (PopupPanel panel : Instances) {
            panel.setItemBackColor(back);
        }
    }

    public static void putForeColorAll(Color fore) {
        for (PopupPanel panel : Instances) {
            panel.setItemForeColor(fore);
        }
    }

    public static void putFontAll(Font font) {
        for (PopupPanel panel : Instances) {
            panel.setMenuFont(font);
        }
    }

    public static int obtainPopupButtonMask() {
        return PopupButtonMask;
    }

    public static void putPopupButtonMask(int mask) {
        PopupButtonMask = mask;
    }

    protected PopupPanel() {
        this.setLayout(new GridLayout(1, 0));
        this.iItemsPanel = new ColorPanel();
        this.iSpane = new JScrollPane(this.iItemsPanel);
        this.iLayout = new PopupPanelLayout(this.iSpane, 0, this.iHgap, this.iVgap, true);
        this.iItemsPanel.setLayout(this.iLayout);
        this.add(this.iSpane);
        this.iSelectionBorder = BorderFactory.createLineBorder(this.iItemSelColor, PopupItem.borderWidth());
        this.iComparator = new DefaultComparator();
        this.iItems = new TreeSet<PopupItem>(this.iComparator);
        this.iItemsPanel.addMouseListener(this.iMouseHandler);
        this.addKeyListener(this.iKeyHandler);
        Instances.add(this);
    }

    protected PopupPanel(Comparator<PopupItem> comparator, int hgap, int vgap, Color itemBack, Color itemFore, Color itemSel, Font label, Font menu) {
        this.iComparator = comparator;
        this.iItems = new TreeSet<PopupItem>(this.iComparator);
        this.iItemForeColor = itemFore;
        this.iItemBackColor = itemBack;
        this.iItemSelColor = itemSel;
        this.iLabelFont = label;
        this.iMenuFont = menu;
        this.iHgap = hgap;
        this.iVgap = vgap;
        this.iLayout = new PopupPanelLayout(this.iSpane, 0, this.iHgap, this.iVgap, true);
        this.iItemsPanel.setLayout(this.iLayout);
        Instances.add(this);
    }

    public synchronized void add(PopupObject obj, boolean selectable, boolean selectAsMultiple) {
        PopupItem item = new PopupItem(this, obj, this.iItemBackColor, this.iItemForeColor, this.iLabelFont, this.iMenuFont, this.iItemBorder);
        this.iItems.add(item);
        item.setSelectable(selectable);
        item.setCanSelectAsMultiple(selectAsMultiple);
    }

    public synchronized void add(PopupObject obj, boolean selectable, boolean selectAsMultiple, Color fore) {
        PopupItem item = new PopupItem(this, obj, this.iItemBackColor, fore, this.iLabelFont, this.iMenuFont, this.iItemBorder);
        this.iItems.add(item);
        item.setSelectable(selectable);
        item.setCanSelectAsMultiple(selectAsMultiple);
    }

    public void fixVerticalScroll(boolean fix) {
        if (fix) {
            this.iSpane.setVerticalScrollBarPolicy(22);
        } else {
            this.iSpane.setVerticalScrollBarPolicy(20);
        }
    }

    Point calcMenuPos(MouseEvent event, Point itemLocation) {
        Point pos = new Point();
        int scrollPos = this.iSpane.getVerticalScrollBar().getValue();
        pos.x = event.getX() + itemLocation.x;
        pos.y = event.getY() + itemLocation.y - scrollPos;
        return pos;
    }

    public void clearSelectedItems() {
        for (PopupItem item : this.iSelections) {
            this.clearItem(item);
        }
        this.iSelections.clear();
    }

    public int numItems() {
        return this.iItems.size();
    }

    public int itemNum(PopupObject obj) {
        int num = -1;
        int i = 0;
        Iterator<PopupItem> iter = this.iItems.iterator();
        while (iter.hasNext() && num < 0) {
            PopupItem anItem = iter.next();
            if (anItem.getPopupObject() == obj) {
                num = i;
            }
            ++i;
        }
        return num;
    }

    @Override
    public void setToolTipText(String text) {
        this.iItemsPanel.setToolTipText(text);
    }

    public void setItemBorder(Border border) {
        this.iItemBorder = border;
    }

    public int firstSelectionIndex() {
        if (this.iSelections.size() != 1 || this.iItems.size() == 0) {
            this.iSelIndex = -1;
        } else {
            int i = 0;
            while (i < this.iItemsArray.length) {
                if (this.iItemsArray[i] == this.iSelections.getFirst()) {
                    this.iSelIndex = i;
                    break;
                }
                ++i;
            }
        }
        return this.iSelIndex;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public synchronized int numSelections() {
        return this.iSelections.size();
    }

    public synchronized LinkedList<PopupObject> selections() {
        LinkedList<PopupObject> objs = new LinkedList<PopupObject>();
        for (PopupItem item : this.iSelections) {
            objs.add(item.getPopupObject());
        }
        return objs;
    }

    public String firstItemLabel() {
        String label = null;
        if (this.iItems.size() > 0) {
            Iterator<PopupItem> iter = this.iItems.iterator();
            PopupItem item = iter.next();
            label = item.getLabel();
        }
        return label;
    }

    public synchronized void remove(PopupObject obj) {
        PopupItem item = this.findItem(obj);
        if (item != null) {
            this.clearItem(item);
            this.iItems.remove(item);
            item.dispose();
        }
        this.fillItemsArray();
        this.firstSelectionIndex();
    }

    @Override
    public synchronized void removeAll() {
        this.iItemsPanel.removeAll();
        this.iItemsPanel.validate();
        this.iItemsPanel.repaint();
        this.iItems.clear();
        this.fillItemsArray();
        this.firstSelectionIndex();
    }

    public synchronized PopupObject selectFirstItem() {
        PopupObject first = null;
        if (this.iItems.size() > 0) {
            if (this.iItemsArray.length == 0) {
                this.fillItemsArray();
            }
            this.iSelIndex = 0;
            this.setSelectedItem(this.iItemsArray[this.iSelIndex]);
            first = this.iItemsArray[this.iSelIndex].getPopupObject();
            PopupItem item = this.iItemsArray[this.iSelIndex];
            this.setSelectedItem(item);
            this.scrollToItem(item);
        }
        return first;
    }

    public synchronized void selectNextItem(boolean wrap) {
        if (this.iSelIndex != -1) {
            boolean doNext = wrap;
            if (wrap || this.iSelIndex < this.iItemsArray.length - 1) {
                doNext = true;
            }
            if (doNext) {
                this.clearSelectedItems();
                ++this.iSelIndex;
                if (this.iSelIndex >= this.iItemsArray.length) {
                    this.iSelIndex = 0;
                }
                PopupItem item = this.iItemsArray[this.iSelIndex];
                this.setSelectedItem(item);
                this.scrollToItem(item);
            }
        }
    }

    public synchronized void selectPrevItem(boolean wrap) {
        if (this.iSelIndex != -1) {
            boolean doPrev = wrap;
            if (wrap || this.iSelIndex > 0) {
                doPrev = true;
            }
            if (doPrev) {
                this.clearSelectedItems();
                --this.iSelIndex;
                if (this.iSelIndex < 0) {
                    this.iSelIndex = this.iItemsArray.length - 1;
                }
                PopupItem item = this.iItemsArray[this.iSelIndex];
                this.setSelectedItem(item);
                Point pos = item.getLocation();
                Dimension size = item.getSize();
                Dimension pSize = this.iItemsPanel.getSize();
                double ratio = (double)pSize.width / (double)pSize.height;
                Rectangle rect = new Rectangle((int)(pos.getX() * ratio), (int)(pos.getY() * ratio - (double)(4 * size.height)), size.width, size.height);
                item.scrollRectToVisible(rect);
            }
        }
    }

    public void setComparator(Comparator<PopupItem> comparator) {
        if (comparator != null) {
            this.iComparator = comparator;
            this.iItems = new TreeSet<PopupItem>(this.iComparator);
        } else {
            this.iComparator = null;
            this.iItems = new LinkedList<PopupItem>();
        }
    }

    public void setHgap(int gap) {
        this.iHgap = gap;
        this.iLayout = new PopupPanelLayout(this.iSpane, 0, this.iHgap, this.iVgap, true);
        this.iItemsPanel.setLayout(this.iLayout);
    }

    public void setItemBackColor(Color back) {
        this.iItemBackColor = back;
        if (this.iItemsArray != null) {
            int i = 0;
            while (i < this.iItemsArray.length) {
                this.iItemsArray[i].setBackground(back);
                ++i;
            }
        }
    }

    public void setItemForeColor(Color fore) {
        this.iItemForeColor = fore;
        if (this.iItemsArray != null) {
            int i = 0;
            while (i < this.iItemsArray.length) {
                this.iItemsArray[i].setForeground(fore);
                ++i;
            }
        }
    }

    public void setLabelFont(Font font) {
        this.iLabelFont = font;
        if (this.iItemsArray != null) {
            int i = 0;
            while (i < this.iItemsArray.length) {
                this.iItemsArray[i].setFont(font);
                ++i;
            }
        }
    }

    public void setMenuFont(Font font) {
        this.iMenuFont = font;
        this.setLabelFont(font);
    }

    public synchronized void setSelectedItem(PopupItem item) {
        this.clearSelectedItems();
        this.iSelections.add(item);
        this.firstSelectionIndex();
        this.highlightItem(item);
    }

    public synchronized void addSelection(PopupItem item) {
        boolean reset = false;
        Iterator items = this.iSelections.iterator();
        while (!reset && items.hasNext()) {
            PopupItem anItem = (PopupItem)items.next();
            boolean bl = reset = !anItem.canSelectAsMultiple();
        }
        if (!reset) {
            items = this.iSelections.iterator();
            boolean exists = false;
            while (!exists && items.hasNext()) {
                PopupItem anItem = (PopupItem)items.next();
                exists = anItem.getPopupObject().equalTo(item.getPopupObject());
            }
            if (!exists) {
                this.iSelections.add(item);
                this.highlightItem(item);
            }
        } else {
            this.setSelection(item.getPopupObject());
        }
    }

    public synchronized void addSelection(PopupObject obj) {
        PopupItem item = this.findItem(obj);
        if (item != null) {
            this.addSelection(item);
        }
    }

    public synchronized void selectAll() {
        this.clearSelectedItems();
        for (PopupItem item : this.iItems) {
            this.addSelection(item);
        }
    }

    public synchronized void setSelection(PopupObject obj) {
        this.clearSelectedItems();
        PopupItem item = this.findItem(obj);
        if (item != null) {
            this.iSelections.add(item);
            this.firstSelectionIndex();
        }
        if (this.iSelections.size() == 1) {
            item = this.iSelections.getFirst();
            this.highlightItem(item);
        }
    }

    public synchronized void selectItem(String label) {
        for (PopupItem item : this.iItems) {
            if (!item.getPopupObject().label().equals(label)) continue;
            this.setSelectedItem(item);
            break;
        }
    }

    public void setSelectionColor(Color selection) {
        this.iItemSelColor = selection;
        this.iSelectionBorder = BorderFactory.createLineBorder(this.iItemSelColor, PopupItem.borderWidth());
    }

    public void setVgap(int gap) {
        this.iVgap = gap;
        this.iLayout = new PopupPanelLayout(this.iSpane, 0, this.iHgap, this.iVgap, true);
        this.iItemsPanel.setLayout(this.iLayout);
    }

    public synchronized void showItems() {
        this.iItemsPanel.removeAll();
        for (PopupItem item : this.iItems) {
            item.updateIcon();
            this.iItemsPanel.add(item);
            if (!this.isSelected(item)) continue;
            this.highlightItem(item);
            if (this.iSelections.size() != 1) continue;
            this.setSelectedItem(item);
        }
        this.fillItemsArray();
        this.firstSelectionIndex();
        this.iItemsPanel.validate();
        this.iSpane.doLayout();
        this.iItemsPanel.repaint();
    }

    public Collection<PopupObject> allObjects() {
        LinkedList<PopupObject> objs = new LinkedList<PopupObject>();
        for (PopupItem item : this.iItems) {
            objs.add(item.getPopupObject());
        }
        return objs;
    }

    public synchronized void addListener(Listener lis) {
        boolean exists = lis == null;
        Iterator iter = this.iLis.iterator();
        while (!exists && iter.hasNext()) {
            boolean bl = exists = iter.next() == lis;
        }
        if (!exists) {
            this.iLis.add(lis);
        }
    }

    public synchronized void removeListener(Listener lis) {
        this.iLis.remove(lis);
    }

    public synchronized void fireSelected(PopupItem item, boolean doubleClick) {
        Event event = new Event(this);
        event.setSelection(item);
        event.setDoubleClick(doubleClick);
        for (Listener lis : this.iLis) {
            lis.selected(event);
        }
    }

    public boolean isMultipleSelect() {
        return this.iMultipleSelect;
    }

    public void setMultipleSelect(boolean multipleSelect) {
        this.iMultipleSelect = multipleSelect;
    }

    public void enablePopupMenus(boolean enable) {
        this.iEnablePopup = enable;
    }

    public boolean popupMenusEnabled() {
        return this.iEnablePopup;
    }

    public void enableSelection(boolean enable) {
        this.iEnableSelection = enable;
    }

    public boolean selectionEnabled() {
        return this.iEnableSelection;
    }

    public abstract void handleMenu(String var1);

    public abstract JPopupMenu panelMenu();

    private JPopupMenu getMenu() {
        if (this.iMenu == null) {
            this.iMenu = this.panelMenu();
        }
        return this.iMenu;
    }

    private PopupItem findItem(PopupObject obj) {
        PopupItem item = null;
        Iterator<PopupItem> iter = this.iItems.iterator();
        while (iter.hasNext() && item == null) {
            PopupItem anItem = iter.next();
            if (!anItem.getPopupObject().equalTo(obj)) continue;
            item = anItem;
        }
        return item;
    }

    private void clearItem(PopupItem item) {
        item.clearWasVisible();
        item.setForeground(item.getForeColor());
        item.setBorder(PopupItem.EMPTYBORDER);
        item.setFont(this.iLabelFont);
        this.iSpane.repaint();
    }

    private void fillItemsArray() {
        this.iItemsArray = new PopupItem[this.iItems.size()];
        int i = 0;
        Iterator<PopupItem> iter = this.iItems.iterator();
        while (iter.hasNext()) {
            this.iItemsArray[i] = iter.next();
            ++i;
        }
    }

    private void removeMenuListener() {
        MenuElement[] eles = this.getMenu().getSubElements();
        int i = 0;
        while (i < eles.length) {
            if (eles[i] instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)eles[i];
                item.removeActionListener((ActionListener)((Object)this.iMouseHandler));
            }
            ++i;
        }
    }

    private void addMenuListener() {
        MenuElement[] eles = this.getMenu().getSubElements();
        int i = 0;
        while (i < eles.length) {
            if (eles[i] instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)eles[i];
                item.setBackground(SystemColor.control);
                item.setForeground(SystemColor.controlText);
                item.addActionListener((ActionListener)((Object)this.iMouseHandler));
                if (this.iMenuFont != null) {
                    item.setFont(this.iMenuFont);
                }
            }
            ++i;
        }
    }

    private boolean isSelected(PopupItem item) {
        boolean selected = false;
        Iterator items = this.iSelections.iterator();
        while (!selected && items.hasNext()) {
            PopupItem anItem = (PopupItem)items.next();
            boolean bl = selected = anItem == item;
        }
        return selected;
    }

    private void showMenu(MouseEvent event) {
        if (this.getMenu() != null) {
            Point location = new Point(0, 0);
            Point pos = this.calcMenuPos(event, location);
            this.addMenuListener();
            this.getMenu().show(this, pos.x, pos.y);
        }
    }

    private void highlightItem(PopupItem item) {
        item.setForeground(AllSelectionColor);
        item.setBorder(this.iSelectionBorder);
        this.iSpane.repaint();
    }

    private void scrollToItem(PopupItem item) {
        Point pos = item.getLocation();
        Dimension size = item.getSize();
        Dimension pSize = this.iItemsPanel.getSize();
        double ratio = (double)pSize.width / (double)pSize.height;
        Rectangle rect = new Rectangle((int)(pos.getX() * ratio), (int)(pos.getY() * ratio), size.width, size.height);
        item.scrollRectToVisible(rect);
    }

    private class DefaultComparator
    implements Comparator<PopupItem> {
        private DefaultComparator() {
        }

        @Override
        public int compare(PopupItem item1, PopupItem item2) {
            int result = -1;
            if (item1 != null && item2 != null) {
                String str1 = item1.getPopupObject().label();
                String str2 = item2.getPopupObject().label();
                if (str1 != null && str2 != null) {
                    result = str1.compareToIgnoreCase(str2);
                }
            }
            return result;
        }
    }

    public class Event
    extends EventObject {
        private PopupItem iSelection;
        private boolean iDoubleClick;

        public Event(Object source) {
            super(source);
            this.iSelection = null;
            this.iDoubleClick = false;
        }

        public PopupItem getSelection() {
            return this.iSelection;
        }

        public void setSelection(PopupItem selection) {
            this.iSelection = selection;
        }

        public boolean isDoubleClick() {
            return this.iDoubleClick;
        }

        public void setDoubleClick(boolean doubleClick) {
            this.iDoubleClick = doubleClick;
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (PopupPanel.this.iEnableSelection && PopupPanel.this.iEnablePopup) {
                if (event.getKeyCode() == 39) {
                    PopupPanel.this.selectNextItem(false);
                } else if (event.getKeyCode() == 37) {
                    PopupPanel.this.selectPrevItem(false);
                } else if (event.getKeyCode() == 10) {
                    if (PopupPanel.this.iSelections.size() == 1) {
                        PopupItem item = (PopupItem)PopupPanel.this.iSelections.getFirst();
                        item.handleEnter();
                    }
                } else if (event.getKeyCode() == 32 && PopupPanel.this.iSelections.size() == 1) {
                    PopupPanel.this.selectNextItem(false);
                    PopupItem item = (PopupItem)PopupPanel.this.iSelections.getFirst();
                    item.handleEnter();
                }
            }
        }
    }

    public static interface Listener {
        public void selected(Event var1);
    }

    private class MouseHandler
    extends MouseAdapter
    implements ActionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 1 && PopupPanel.this.getMenu() != null && (event.getModifiers() & PopupPanel.obtainPopupButtonMask()) > 0) {
                PopupPanel.this.showMenu(event);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PopupPanel.this.removeMenuListener();
            PopupPanel.this.handleMenu(event.getActionCommand());
            PopupPanel.this.addMenuListener();
        }
    }
}

