/*
 * Decompiled with CFR 0.152.
 */
package popup;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import popup.PopupObject;
import popup.PopupPanel;
import utilt.Utility;

public class PopupItem
extends JPanel
implements Comparable<PopupItem> {
    private JLabel iIcon = new JLabel();
    private JLabel iLabel = new JLabel();
    private PopupObject iPopupObject = null;
    private PopupPanel iPopupPanel = null;
    private JPopupMenu iMenu = null;
    private volatile boolean iWasVisible = false;
    private boolean iSelectable = true;
    private boolean iCanSelectAsMultiple = false;
    private Font iMenuFont = Utility.stdFont();
    private Color iForeColor = Color.black;
    private static int BorderWidth = 3;
    public static final Border EMPTYBORDER = BorderFactory.createEmptyBorder(BorderWidth, BorderWidth, BorderWidth, BorderWidth);
    private MouseListener iEventHandler = new EventHandler();

    public static void putBorderWidth(int width) {
        BorderWidth = width;
    }

    public static int borderWidth() {
        return BorderWidth;
    }

    public PopupItem(PopupPanel panel, PopupObject obj, Color back, Color fore, Border border) {
        this.setLayout(new BoxLayout(this, 1));
        this.iForeColor = fore;
        this.add(this.iIcon);
        this.add(this.iLabel);
        if (fore != null) {
            this.setForeground(this.iForeColor);
        } else {
            this.setForeground(SystemColor.windowText);
        }
        if (back != null) {
            this.setBackground(back);
        } else {
            this.setBackground(SystemColor.window);
        }
        this.iIcon.setIcon(obj.thumb());
        this.iLabel.setText(obj.label());
        this.iLabel.setFont(this.iMenuFont);
        this.iIcon.setAlignmentX(0.5f);
        this.iLabel.setAlignmentX(0.5f);
        this.iLabel.setHorizontalTextPosition(0);
        this.iIcon.setHorizontalAlignment(0);
        this.setOpaque(true);
        if (border == null) {
            this.iIcon.setBorder(BorderFactory.createEmptyBorder(BorderWidth, BorderWidth, BorderWidth, BorderWidth));
        } else {
            this.iIcon.setBorder(border);
        }
        this.setBorder(EMPTYBORDER);
        this.iPopupObject = obj;
        this.iPopupPanel = panel;
        this.addMouseListener(this.iEventHandler);
    }

    public PopupItem(PopupPanel panel, PopupObject object, Color back, Color fore, Font label, Font menu, Border border) {
        this(panel, object, back, fore, border);
        if (label != null) {
            this.setFont(label);
        }
        this.iMenuFont = menu;
    }

    public void setSelectable(boolean selectable) {
        this.iSelectable = selectable;
    }

    public boolean isSelectable() {
        return this.iSelectable;
    }

    private void addMenuListener() {
        if (this.iMenu != null) {
            this.iMenu.addPopupMenuListener((PopupMenuListener)((Object)this.iEventHandler));
            MenuElement[] eles = this.iMenu.getSubElements();
            int i = 0;
            while (i < eles.length) {
                if (eles[i] instanceof JMenuItem) {
                    JMenuItem item = (JMenuItem)eles[i];
                    item.setBackground(SystemColor.control);
                    item.setForeground(SystemColor.controlText);
                    item.addActionListener((ActionListener)((Object)this.iEventHandler));
                    if (this.iMenuFont != null) {
                        item.setFont(this.iMenuFont);
                    }
                }
                ++i;
            }
        }
    }

    public void clearWasVisible() {
        this.iWasVisible = false;
        this.removeMenuListener();
    }

    public void dispose() {
        this.removeMouseListener(this.iEventHandler);
    }

    public PopupObject getPopupObject() {
        return this.iPopupObject;
    }

    private void removeMenuListener() {
        if (this.iMenu != null) {
            this.iMenu.removePopupMenuListener((PopupMenuListener)((Object)this.iEventHandler));
            MenuElement[] eles = this.iMenu.getSubElements();
            int i = 0;
            while (i < eles.length) {
                if (eles[i] instanceof JMenuItem) {
                    JMenuItem item = (JMenuItem)eles[i];
                    item.removeActionListener((ActionListener)((Object)this.iEventHandler));
                }
                ++i;
            }
        }
    }

    public void showMenu(MouseEvent event) {
        this.iMenu = this.iPopupObject.menu();
        if (this.iPopupPanel.popupMenusEnabled() && this.iMenu != null) {
            Point pos = this.iPopupPanel.calcMenuPos(event, this.getLocation());
            this.addMenuListener();
            this.iMenu.show(this.iPopupPanel, pos.x, pos.y);
        }
    }

    public void updateIcon() {
        this.iIcon.setIcon(this.iPopupObject.thumb());
    }

    public void handleEnter() {
        this.iPopupObject.handleEvent(this.iPopupPanel, true, "");
    }

    @Override
    public String toString() {
        return String.valueOf(this.iLabel.getText()) + " " + this.iPopupObject.toString();
    }

    public String getLabel() {
        return this.iLabel.getText();
    }

    @Override
    public int compareTo(PopupItem item) {
        int result = 0;
        if (item != this) {
            result = -1;
            if (item != null) {
                result = this.iPopupObject.label().compareToIgnoreCase(item.iPopupObject.label());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj.getClass() == PopupItem.class) {
            result = this.compareTo((PopupItem)obj) == 0;
        }
        return result;
    }

    public int hashCode() {
        return this.iPopupObject.label().toLowerCase().hashCode();
    }

    public boolean canSelectAsMultiple() {
        return this.iCanSelectAsMultiple;
    }

    public void setCanSelectAsMultiple(boolean can) {
        this.iCanSelectAsMultiple = can;
    }

    @Override
    public void setBackground(Color back) {
        super.setForeground(back);
        if (this.iLabel != null) {
            this.iLabel.setBackground(back);
        }
    }

    @Override
    public void setForeground(Color fore) {
        super.setForeground(fore);
        if (this.iLabel != null) {
            this.iLabel.setForeground(fore);
        }
    }

    public Color getForeColor() {
        return this.iForeColor;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.iLabel != null) {
            this.iLabel.setFont(font);
        }
    }

    private class EventHandler
    extends MouseAdapter
    implements ActionListener,
    PopupMenuListener {
        private EventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (PopupItem.this.iPopupPanel.selectionEnabled()) {
                boolean doubleClick;
                PopupItem item = PopupItem.this;
                int mods = event.getModifiers();
                if (PopupItem.this.iSelectable) {
                    if (!PopupItem.this.iPopupPanel.isMultipleSelect()) {
                        PopupItem.this.iPopupPanel.setSelectedItem(item);
                    } else if ((mods & 2) > 0 && item.canSelectAsMultiple()) {
                        PopupItem.this.iPopupPanel.addSelection(item);
                    } else {
                        PopupItem.this.iPopupPanel.setSelectedItem(item);
                    }
                }
                boolean bl = doubleClick = event.getClickCount() == 2;
                if (PopupItem.this.iPopupPanel.popupMenusEnabled()) {
                    if (doubleClick) {
                        PopupItem.this.iPopupObject.handleEvent(PopupItem.this.iPopupPanel, true, "");
                    } else if (event.getClickCount() == 1 && (mods & PopupPanel.obtainPopupButtonMask()) > 0) {
                        PopupItem.this.showMenu(event);
                    } else {
                        PopupItem.this.iPopupPanel.fireSelected(item, doubleClick);
                    }
                }
                PopupItem.this.iPopupPanel.requestFocus();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent event) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            PopupItem.this.iWasVisible = true;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PopupItem.this.removeMenuListener();
            if (PopupItem.this.iWasVisible) {
                PopupItem.this.iWasVisible = false;
                PopupItem.this.iPopupObject.handleEvent(PopupItem.this.iPopupPanel, false, event.getActionCommand());
            }
        }
    }
}

