/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import bpv.Album;
import files.FtpServer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import mswing.ThumbnailImage;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Website;
import oroma.db.WebsiteDef;
import utilt.ImageIOUtil;
import utilt.Utility;

public class WebImg
implements Serializable,
Cloneable,
Comparable<WebImg> {
    private PicInfo iPicInfo = null;
    private String iFilename = null;
    private int iMaxSize = 0;
    private int iThumbSize = 0;
    private String iLabel = "";
    private boolean iPortrait = false;
    private Date iUploadDate = null;
    private transient String iServerFolder = "";
    private transient Album iAlbum = null;
    private transient boolean iUseMark = true;
    private Image iImage = null;
    private static final String THUMBSUFFIX = "t";
    private static final Font COPYFONT = new Font("Dialog", 1, 12);
    private static final int OFFSET = 10;
    private static final int TEXTJPEGQUAL = 90;
    static final long serialVersionUID = 7023937401543170326L;

    private static void writeCopyright(Website site, String imagePath, int jpegQuality) throws Exception {
        File file = new File(imagePath);
        BufferedImage image = ImageIO.read(file);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        StringTokenizer tken = new StringTokenizer(site.def().copyright(), ",");
        String copyRight = tken.nextToken();
        Font font = COPYFONT;
        if (tken.hasMoreTokens()) {
            try {
                int fontSize = Integer.parseInt(tken.nextToken().trim());
                font = COPYFONT.deriveFont((float)fontSize);
            }
            catch (Exception fontSize) {
                // empty catch block
            }
        }
        g2.setFont(font);
        g2.setPaint(Color.magenta);
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(copyRight, context);
        int x = (int)((double)image.getWidth() - bounds.getWidth() - 10.0);
        int baseline = image.getHeight() - 10;
        g2.drawString(copyRight, x, baseline);
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
        ImageWriter writer = iter.next();
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        float quality = (float)jpegQuality / 100.0f;
        param.setCompressionQuality(quality);
        file = new File(imagePath);
        try (FileImageOutputStream output = null;){
            output = new FileImageOutputStream(file);
            writer.setOutput(output);
            IIOImage iioimage = new IIOImage(image, null, null);
            writer.write(null, iioimage, param);
            writer.dispose();
        }
    }

    public WebImg(String imgPath, BufferedImage img, PicInfo info, Website site) throws Exception {
        boolean makeAsis;
        this.iPicInfo = info;
        WebsiteDef def = site.def();
        ProgPreferences pref = ProgPreferences.singleton();
        int qual = Integer.parseInt(pref.webJpegQual());
        if (def.copyright() != null && def.copyright().length() > 0 && qual < 90) {
            qual = 90;
        }
        this.iFilename = info.id() + ".jpg";
        File imageDir = new File(site.imagePath());
        if (!imageDir.exists()) {
            imageDir.mkdir();
        }
        String savePath = String.valueOf(site.imagePath()) + '/' + this.iFilename;
        this.iMaxSize = site.def().maxPicSize();
        String rating = info.comboField("rating").value().toString().toLowerCase();
        boolean bl = makeAsis = rating.indexOf("asis") >= 0;
        if (makeAsis || this.iMaxSize <= -1) {
            Utility.copyFile(imgPath, savePath);
        } else {
            ImageIcon icon = new ImageIcon(img);
            double height = icon.getIconHeight();
            double width = icon.getIconWidth();
            if (height <= (double)this.iMaxSize && width <= (double)this.iMaxSize) {
                Utility.copyFile(imgPath, savePath);
            } else {
                img = ImageIOUtil.resize(img, this.iMaxSize);
                ImageIOUtil.writeJpeg(img, savePath, qual);
            }
        }
        if (site.def().copyright().length() > 0) {
            WebImg.writeCopyright(site, savePath, qual);
        }
        savePath = String.valueOf(site.imagePath()) + '/' + this.thumbFilename();
        ThumbnailImage thumb = new ThumbnailImage();
        this.iThumbSize = site.def().thumbSize();
        thumb.setup(img, this.iThumbSize);
        thumb.write(savePath);
        ImageIcon icon = new ImageIcon(img);
        double height = icon.getIconHeight();
        double width = icon.getIconWidth();
        this.iPortrait = height / width > 1.1;
    }

    public boolean needsBuild(Website site, PicInfo info) throws Exception {
        boolean needs;
        boolean bl = needs = this.iMaxSize != site.def().maxPicSize();
        if (!needs) {
            ThumbnailImage thumb = new ThumbnailImage();
            String savePath = String.valueOf(site.imagePath()) + '/' + this.thumbFilename();
            boolean bl2 = needs = !thumb.read(savePath);
            if (!needs) {
                int max = Math.max(thumb.getIconHeight(), thumb.getIconWidth());
                boolean bl3 = needs = Math.abs(max - site.def().thumbSize()) > 1;
            }
            if (!needs) {
                Date lastBuild = site.lastBuild();
                if (lastBuild == null) {
                    needs = true;
                } else {
                    long buildDate = lastBuild.getTime();
                    String pathname = info.picPathname();
                    File file = new File(pathname);
                    if (file.exists()) {
                        needs = buildDate <= file.lastModified();
                    }
                }
            }
        }
        return needs;
    }

    public boolean needsUpload(Website site, FtpServer server, String hostPath) throws Exception {
        boolean needed;
        boolean bl = needed = this.iUploadDate == null;
        if (!needed) {
            boolean bl2 = needed = server.fileExists(hostPath) == null;
        }
        if (!needed) {
            String path = String.valueOf(site.imagePath()) + '/' + this.iFilename;
            File file = new File(path);
            needed = file.lastModified() > this.iUploadDate.getTime();
        }
        return needed;
    }

    public boolean isPortrait() {
        return this.iPortrait;
    }

    public int maxSize() {
        return this.iMaxSize;
    }

    public String filename() {
        return this.iFilename;
    }

    public int thumbSize() {
        return this.iThumbSize;
    }

    public String label() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    public PicInfo picInfo() {
        return this.iPicInfo;
    }

    public void setPicInfo(PicInfo info) {
        this.iPicInfo = info;
    }

    public Date uploadDate() {
        return this.iUploadDate;
    }

    public void setUploadDate(Date uploadDate) {
        this.iUploadDate = uploadDate;
    }

    public String thumbFilename() {
        int index = this.iFilename.indexOf(46);
        String name = this.iFilename.substring(0, index);
        String thumbName = String.valueOf(name) + THUMBSUFFIX + ".jpg";
        return thumbName;
    }

    public Object clone() {
        WebImg clone = null;
        try {
            clone = (WebImg)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public int compareTo(WebImg img) {
        int result = 0;
        if (img != this) {
            result = -1;
            if (img != null) {
                result = img.picInfo().picPathname().compareTo(this.picInfo().picPathname());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo((WebImg)obj) == 0;
    }

    public int hashCode() {
        return this.picInfo().id();
    }

    public String toString() {
        return this.iPicInfo.picPathname();
    }

    public String serverFolder() {
        return this.iServerFolder;
    }

    public Album album() {
        return this.iAlbum;
    }

    public void setAlbum(Album album) {
        this.iAlbum = album;
    }

    public void setServerFolder(String folder) {
        this.iServerFolder = folder;
    }

    public boolean isUseMark() {
        return this.iUseMark;
    }

    public void setUseMark(boolean useMark) {
        this.iUseMark = useMark;
    }

    public Image image() {
        return this.iImage;
    }

    public void setImage(Image image) {
        this.iImage = image;
    }

    public static class DateComparator
    implements Comparator<WebImg> {
        private PicInfo.DateComparator iComparer = new PicInfo.DateComparator();

        @Override
        public int compare(WebImg img1, WebImg img2) {
            int result = -1;
            if (img1 != null && img2 != null) {
                result = this.iComparer.compare(img1.picInfo(), img2.picInfo());
            }
            return result;
        }
    }

    public static class GroupComparator
    implements Comparator<WebImg> {
        private PicInfo.GroupComparator iComparer = new PicInfo.GroupComparator();

        @Override
        public int compare(WebImg img1, WebImg img2) {
            int result = -1;
            if (img1 != null && img2 != null) {
                result = this.iComparer.compare(img1.picInfo(), img2.picInfo());
            }
            return result;
        }
    }

    public static class IdComparator
    implements Comparator<WebImg> {
        private PicInfo.IdComparator iComparer = new PicInfo.IdComparator();

        @Override
        public int compare(WebImg img1, WebImg img2) {
            int result = -1;
            if (img1 != null && img2 != null) {
                result = this.iComparer.compare(img1.picInfo(), img2.picInfo());
            }
            return result;
        }
    }

    public static class NumPixComparator
    implements Comparator<WebImg> {
        private PicInfo.NumPixComparator iComparer = new PicInfo.NumPixComparator();

        @Override
        public int compare(WebImg img1, WebImg img2) {
            int result = -1;
            if (img1 != null && img2 != null) {
                result = this.iComparer.compare(img1.picInfo(), img2.picInfo());
            }
            return result;
        }
    }

    public static class RegionComparator
    implements Comparator<WebImg> {
        private PicInfo.RegionComparator iComparer = new PicInfo.RegionComparator();

        @Override
        public int compare(WebImg img1, WebImg img2) {
            int result = -1;
            if (img1 != null && img2 != null) {
                result = this.iComparer.compare(img1.picInfo(), img2.picInfo());
            }
            return result;
        }
    }
}

