/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import oroma.db.ProgPreferences;
import oroma.db.Website;
import swing.EntryField;

public class WebIdFields
extends JPanel {
    private EntryField jTitleField = null;
    private EntryField jSubtitleField = null;
    private EntryField jCopyrightField = null;
    private EntryField jFooterField = null;
    private EntryField jFtpHostField = null;
    private EntryField jFtpUseridField = null;
    private JPasswordField jFtpPasswordField = null;
    private EntryField jAlbumNameField = null;
    private EntryField jLastBuild = null;
    private EntryField jLastUpload = null;
    private EntryField jFtpDirField = null;
    private EntryField jHomePage = null;
    private EntryField jImageDir = null;
    private static final String NODATE = "";

    public WebIdFields() {
        this.initialize();
    }

    public void removeAlbumName() {
        this.remove(this.jAlbumNameField);
        this.validate();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.getAlbumNameField().setEnabled(enable);
        this.getTitleField().setEnabled(enable);
        this.getSubtitleField().setEnabled(enable);
        this.getFooterField().setEnabled(enable);
        this.getCopyrightField().setEnabled(enable);
        this.getFtpHostField().setEnabled(enable);
        this.getFtpDirField().setEnabled(enable);
        this.getFtpUseridField().setEnabled(enable);
        this.getFtpPasswordField().setEnabled(enable);
        this.getHomePage().setEnabled(false);
        this.getLastBuild().setEnabled(false);
        this.getLastUpload().setEnabled(false);
        this.getAlbumNameField().setEnabled(enable);
        this.getImageDirField().setEnabled(enable);
    }

    private void initialize() {
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.setLayout(new GridLayout(0, 1));
        this.add(this.getAlbumNameField());
        this.add(this.getTitleField());
        this.add(this.getSubtitleField());
        this.add(this.getFooterField());
        this.add(this.getCopyrightField());
        this.add(this.getFtpHostField());
        this.add(this.getFtpDirField());
        this.add(this.getFtpUseridField());
        this.add(this.getFtpPasswordField());
        this.add(this.getImageDirField());
        this.add(this.getHomePage());
        this.add(this.getLastBuild());
        this.add(this.getLastUpload());
        this.getAlbumNameField().setEnabled(false);
    }

    public Component obtainFocusComp() {
        return this.getTitleField();
    }

    public void putDates(Website site, Date lastBuild, Date lastUpload) {
        String date = NODATE;
        if (lastBuild != null) {
            date = lastBuild.toString();
        }
        this.getLastBuild().setText(date);
        date = NODATE;
        if (lastUpload != null) {
            date = lastUpload.toString();
        }
        this.getLastUpload().setText(date);
        this.putHomePage(site);
    }

    public void put(Website site) {
        String name = String.valueOf(site.def().albumName()) + " (" + site.def().albumNum() + ")";
        this.getAlbumNameField().setText(name);
        this.getTitleField().setText(site.def().title());
        this.getSubtitleField().setText(site.def().subTitle());
        this.getFooterField().setText(site.def().footer());
        this.getCopyrightField().setText(site.def().copyright());
        this.getFtpHostField().setText(site.def().ftpHost());
        this.getFtpDirField().setText(site.def().ftpDir());
        this.getFtpUseridField().setText(site.def().ftpUserid());
        this.getFtpPasswordField().setText(site.def().ftpPassword());
        this.getImageDirField().setText(site.def().imageDir());
        this.putDates(site, site.lastBuild(), site.lastUpload());
    }

    private void putHomePage(Website site) {
        if (site.lastBuild() != null) {
            this.getHomePage().setText(String.valueOf(site.path()) + '/' + "bpm.html");
        } else {
            this.getHomePage().setText(NODATE);
        }
    }

    public void fill(Website site) {
        site.def().setTitle(this.getTitleField().getText());
        site.def().setSubTitle(this.getSubtitleField().getText());
        site.def().setFooter(this.getFooterField().getText());
        site.def().setCopyright(this.getCopyrightField().getText());
        site.def().setFtpHost(this.getFtpHostField().getText());
        site.def().setFtpDir(this.getFtpDirField().getText());
        site.def().setFtpUserid(this.getFtpUseridField().getText());
        char[] password = this.getFtpPasswordField().getPassword();
        site.def().setFtpPassword(new String(password));
        site.def().setImageDir(this.getImageDirField().getText());
    }

    private EntryField getTitleField() {
        if (this.jTitleField == null) {
            this.jTitleField = new EntryField();
        }
        return this.jTitleField;
    }

    private EntryField getSubtitleField() {
        if (this.jSubtitleField == null) {
            this.jSubtitleField = new EntryField();
        }
        return this.jSubtitleField;
    }

    private EntryField getFooterField() {
        if (this.jFooterField == null) {
            this.jFooterField = new EntryField();
        }
        return this.jFooterField;
    }

    private EntryField getCopyrightField() {
        if (this.jCopyrightField == null) {
            this.jCopyrightField = new EntryField();
        }
        return this.jCopyrightField;
    }

    private EntryField getFtpHostField() {
        if (this.jFtpHostField == null) {
            this.jFtpHostField = new EntryField();
        }
        return this.jFtpHostField;
    }

    private EntryField getFtpUseridField() {
        if (this.jFtpUseridField == null) {
            this.jFtpUseridField = new EntryField();
        }
        return this.jFtpUseridField;
    }

    private JPasswordField getFtpPasswordField() {
        if (this.jFtpPasswordField == null) {
            this.jFtpPasswordField = new JPasswordField();
            this.jFtpPasswordField.setBackground(EntryField.backColorAll());
        }
        return this.jFtpPasswordField;
    }

    private EntryField getAlbumNameField() {
        if (this.jAlbumNameField == null) {
            this.jAlbumNameField = new EntryField();
        }
        return this.jAlbumNameField;
    }

    private EntryField getLastBuild() {
        if (this.jLastBuild == null) {
            this.jLastBuild = new EntryField();
            this.jLastBuild.setEnabled(false);
        }
        return this.jLastBuild;
    }

    private EntryField getLastUpload() {
        if (this.jLastUpload == null) {
            this.jLastUpload = new EntryField();
            this.jLastUpload.setEnabled(false);
        }
        return this.jLastUpload;
    }

    private EntryField getFtpDirField() {
        if (this.jFtpDirField == null) {
            this.jFtpDirField = new EntryField();
        }
        return this.jFtpDirField;
    }

    private EntryField getHomePage() {
        if (this.jHomePage == null) {
            this.jHomePage = new EntryField();
            this.jHomePage.setEnabled(false);
        }
        return this.jHomePage;
    }

    private EntryField getImageDirField() {
        if (this.jImageDir == null) {
            this.jImageDir = new EntryField();
        }
        return this.jImageDir;
    }
}

