/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oroma.db.ProgPreferences;
import oroma.db.Website;
import oroma.website.WebColorsPanel;
import oroma.website.WebIdPanel;
import oroma.website.WebStructPanel;
import swing.EntryField;
import swing.StdScrollPane;
import swing.SwingProgram;

public class WebDefPanel
extends JPanel {
    private JTabbedPane jPane = new JTabbedPane();
    private JProgressBar iProgBar = new JProgressBar();
    private WebColorsPanel jColorsPanel = null;
    private WebStructPanel jStructPanel = null;
    private WebIdPanel jIdPanel = null;
    private static final int IDTAB = 0;
    private static final int STRUCTTAB = 1;
    private static final int COLORSTAB = 2;

    public WebDefPanel() {
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.setLayout(new BorderLayout());
        this.jPane.setBackground(ProgPreferences.singleton().dialogColor());
        this.jPane.addTab(" Identification ", null, new StdScrollPane(this.getIdPanel()), null);
        this.jPane.addTab(" Structure ", null, new StdScrollPane(this.getStructPanel()), null);
        this.jPane.addTab(" Colors ", null, new StdScrollPane(this.getColorsPanel()), null);
        this.jPane.setBackgroundAt(0, SwingProgram.TAB0COLOR);
        this.jPane.setBackgroundAt(1, SwingProgram.TAB1COLOR);
        this.jPane.setBackgroundAt(2, SwingProgram.TAB2COLOR);
        this.jPane.addChangeListener(new TabHandler());
        this.jPane.setSelectedIndex(0);
        this.jPane.setForegroundAt(0, SwingProgram.TABFORECOLOR);
        Font font = ProgPreferences.singleton().menuFont();
        this.jPane.setFont(font.deriveFont(1));
        this.iProgBar.setBackground(SystemColor.control);
        this.add((Component)this.jPane, "Center");
        this.add((Component)this.iProgBar, "South");
        EntryField.putBackColorAll(ProgPreferences.singleton().entryBackColor());
    }

    public void removeAlbumName() {
        this.jIdPanel.removeAlbumName();
    }

    public void put(Website site) {
        this.getColorsPanel().put(site);
        this.getStructPanel().put(site);
        this.getIdPanel().put(site);
    }

    public void fill(Website site) {
        this.getColorsPanel().fill(site);
        this.getStructPanel().fill(site);
        this.getIdPanel().fill(site);
    }

    public Component obtainFocusComp() {
        return this.getIdPanel().obtainFocusComp();
    }

    public void putPercent(int percent) {
        this.iProgBar.setValue(percent);
    }

    public void putDates(Website site, Date lastBuild, Date lastUpload) {
        this.getIdPanel().putDates(site, lastBuild, lastUpload);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.jColorsPanel.setEnabled(enable);
        this.jStructPanel.setEnabled(enable);
        this.jIdPanel.setEnabled(enable);
    }

    private WebColorsPanel getColorsPanel() {
        if (this.jColorsPanel == null) {
            this.jColorsPanel = new WebColorsPanel();
        }
        return this.jColorsPanel;
    }

    private WebStructPanel getStructPanel() {
        if (this.jStructPanel == null) {
            this.jStructPanel = new WebStructPanel();
        }
        return this.jStructPanel;
    }

    private WebIdPanel getIdPanel() {
        if (this.jIdPanel == null) {
            this.jIdPanel = new WebIdPanel();
        }
        return this.jIdPanel;
    }

    private class TabHandler
    implements ChangeListener {
        private TabHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            int selected = WebDefPanel.this.jPane.getSelectedIndex();
            WebDefPanel.this.jPane.setForegroundAt(1, Color.black);
            WebDefPanel.this.jPane.setForegroundAt(0, Color.black);
            WebDefPanel.this.jPane.setForegroundAt(2, Color.black);
            WebDefPanel.this.jPane.setForegroundAt(selected, SwingProgram.TABFORECOLOR);
        }
    }
}

