/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import files.ApacheFtpServer;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import mlib.MAppMsg;
import oroma.albumgui.PicturePanel;
import oroma.db.Database;
import oroma.db.ProgPreferences;
import oroma.db.Website;
import oroma.db.WebsiteDef;
import oroma.gui.BpmMsgs;
import oroma.website.WebDefPanel;
import oroma.website.WebMgr;
import swing.StatusBox;
import utilt.Utility;

public class WebDefDialog
extends CenteredDialog {
    private Website iSite = null;
    private WebDefPanel iWebDefPanel = new WebDefPanel();
    private int iUploadButton = -1;
    private int iDeleteButton = -1;
    private static WebMgr Mgr = null;
    private static WebDefDialog Singleton = null;

    public static void enableBuild(boolean enable) {
        if (Singleton != null) {
            Singleton.enableAcceptButton(enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableUpload(boolean enable) {
        Database database = Database.singleton();
        synchronized (database) {
            if (Singleton != null) {
                Singleton.enableCustomButton(WebDefDialog.Singleton.iUploadButton, enable);
            }
        }
    }

    public static void enableDelete(boolean enable) {
        if (Singleton != null) {
            Singleton.enableCustomButton(WebDefDialog.Singleton.iDeleteButton, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableCancel(boolean enable) {
        Database database = Database.singleton();
        synchronized (database) {
            if (Singleton != null) {
                Singleton.enableCancelButton(enable);
            }
        }
    }

    public static void putPercent(int percent) {
        if (Singleton != null) {
            WebDefDialog.Singleton.iWebDefPanel.putPercent(percent);
        }
    }

    public static void putDates(Date lastBuild, Date lastUpload) {
        if (Singleton != null) {
            DateUpdater updater = new DateUpdater(lastBuild, lastUpload);
            try {
                EventQueue.invokeAndWait(updater);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void enableInput(boolean enable) {
        if (Singleton != null) {
            WebDefDialog.Singleton.iWebDefPanel.setEnabled(enable);
        }
    }

    public static boolean isDisplayed() {
        return Singleton != null;
    }

    public static float calcHorzFrac() {
        return 0.6f;
    }

    public static float calcVertFrac() {
        int pixSize = 17 * (ProgPreferences.singleton().menuFont().getSize() + 25) + 75;
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        float vertFrac = (float)pixSize / (float)screen.height;
        return vertFrac;
    }

    public WebDefDialog(Frame owner) {
        super(owner);
        this.setModal(true);
        this.addClientPanel(this.iWebDefPanel);
        this.putAcceptLabel(" Build ", 'B');
        this.iUploadButton = this.addCustomButton("Upload", 'U', null, null);
        this.iDeleteButton = this.addCustomButton("Delete", 'U', null, null);
        this.putCancelLabel("Close", 'C');
        this.enableCustomButton(this.iUploadButton, false);
        this.setFont(ProgPreferences.singleton().menuFont());
        this.setFocusComp(this.iWebDefPanel.obtainFocusComp());
        Singleton = this;
        this.addWindowListener(new WindowHandler());
    }

    public void removeAlbumName() {
        this.iWebDefPanel.removeAlbumName();
    }

    @Override
    public void accept(DialogEvent event) {
        boolean result = true;
        this.iWebDefPanel.fill(this.iSite);
        if (result && (result = this.saveInfo())) {
            this.enableAcceptButton(false);
            WebDefDialog.enableUpload(false);
            this.enableCancelButton(true);
            this.enableCustomButton(this.iDeleteButton, false);
            WebDefDialog.enableInput(false);
            Mgr = new WebMgr(this.iSite, true);
            Mgr.start();
        }
    }

    @Override
    public void cancel(DialogEvent event) {
        if (Mgr != null) {
            WebMgr.halt();
        }
        this.dispose();
    }

    public void setSite(Website site) {
        this.iSite = (Website)site.clone();
        this.iWebDefPanel.put(this.iSite);
        if (this.iSite.lastBuild() != null) {
            this.enableCustomButton(this.iUploadButton, true);
        }
    }

    @Override
    public void custom(int index, DialogEvent event) {
        if (index == this.iUploadButton) {
            this.iWebDefPanel.fill(this.iSite);
            if (this.iSite.def().hasFtpParms()) {
                this.doUpload();
            } else {
                MAppMsg msg = BpmMsgs.get("ftp_info_reqd");
                StatusBox.singleton().showMsg(msg.format(), msg.isError());
            }
        } else if (index == this.iDeleteButton) {
            this.doDelete();
        }
    }

    private boolean saveInfo() {
        boolean result = false;
        try {
            Database.singleton().webDb().put(this.iSite);
            MAppMsg msg = BpmMsgs.get("saved_website_info");
            StatusBox.singleton().showMsg(msg.format(), msg.isError());
            result = true;
        }
        catch (Exception xcp) {
            MAppMsg msg = BpmMsgs.get("unable_save_website");
            StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
        }
        return result;
    }

    private void doDelete() {
        try {
            MAppMsg msg;
            Date lastUpload = this.iSite.lastUpload();
            String albumName = this.iSite.def().albumName();
            if (lastUpload != null) {
                msg = BpmMsgs.get("deleting_website");
                StatusBox.singleton().showMsg(msg.format(albumName), msg.isError());
                ApacheFtpServer server = WebMgr.connectToServer(this.iSite);
                server.deleteFolder(this.iSite.def().ftpDir());
            }
            Database.singleton().webDb().delete(albumName);
            this.iSite.setLastBuild(null);
            this.iSite.setLastUpload(null);
            this.setSite(this.iSite);
            msg = BpmMsgs.get("deleted_website");
            StatusBox.singleton().showMsg(msg.format(albumName), msg.isError());
            WebDefDialog.enableUpload(false);
        }
        catch (Exception xcp) {
            MAppMsg msg = BpmMsgs.get("unable_delete_website");
            StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
        }
    }

    private void doUpload() {
        this.iWebDefPanel.fill(this.iSite);
        WebsiteDef def = this.iSite.def();
        if (def.ftpHost().length() > 0 && def.ftpUserid().length() > 0 && def.ftpPassword().length() > 0) {
            this.enableAcceptButton(false);
            WebDefDialog.enableUpload(false);
            this.enableCancelButton(true);
            this.enableCustomButton(this.iDeleteButton, false);
            WebDefDialog.enableInput(false);
            Mgr = new WebMgr(this.iSite, false);
            Mgr.start();
        } else {
            MAppMsg msg = BpmMsgs.get("ftp_info_reqd");
            StatusBox.singleton().showMsg(msg.format(), msg.isError());
        }
    }

    private static class DateUpdater
    extends Thread {
        private Date iLastBuild = null;
        private Date iLastUpload = null;

        public DateUpdater(Date lastBuild, Date lastUpload) {
            this.iLastBuild = lastBuild;
            this.iLastUpload = lastUpload;
        }

        @Override
        public void run() {
            try {
                Singleton.iWebDefPanel.putDates(Singleton.iSite, this.iLastBuild, this.iLastUpload);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent event) {
            if (Mgr != null) {
                WebMgr.halt();
            }
            PicturePanel.singleton().requestFocus();
            Singleton = null;
        }
    }
}

